<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditScheduledAppointmentInputV2 StructType
 * @subpackage Structs
 */
class EditScheduledAppointmentInputV2 extends AbstractStructBase
{
    /**
     * The AppointmentId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AppointmentId;
    /**
     * The DateUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateUtc;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The TechnicianId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TechnicianId;
    /**
     * The Confirmation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Confirmation;
    /**
     * The Reminder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Reminder;
    /**
     * The DateEndRangeUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DateEndRangeUtc;
    /**
     * The IsVirtual
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsVirtual;
    /**
     * The EstimatedDurationMinutes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $EstimatedDurationMinutes;
    /**
     * The IncludeRepInfoInEmails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IncludeRepInfoInEmails;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The AppointmentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfAppointmentTypeEnum
     */
    public $AppointmentType;
    /**
     * The CustomerFacingInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerFacingInfo;
    /**
     * The MeetingLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MeetingLocation;
    /**
     * Constructor method for EditScheduledAppointmentInputV2
     * @uses EditScheduledAppointmentInputV2::setAppointmentId()
     * @uses EditScheduledAppointmentInputV2::setDateUtc()
     * @uses EditScheduledAppointmentInputV2::setStatus()
     * @uses EditScheduledAppointmentInputV2::setTechnicianId()
     * @uses EditScheduledAppointmentInputV2::setConfirmation()
     * @uses EditScheduledAppointmentInputV2::setReminder()
     * @uses EditScheduledAppointmentInputV2::setDateEndRangeUtc()
     * @uses EditScheduledAppointmentInputV2::setIsVirtual()
     * @uses EditScheduledAppointmentInputV2::setEstimatedDurationMinutes()
     * @uses EditScheduledAppointmentInputV2::setIncludeRepInfoInEmails()
     * @uses EditScheduledAppointmentInputV2::setNotes()
     * @uses EditScheduledAppointmentInputV2::setAppointmentType()
     * @uses EditScheduledAppointmentInputV2::setCustomerFacingInfo()
     * @uses EditScheduledAppointmentInputV2::setMeetingLocation()
     * @param int $appointmentId
     * @param string $dateUtc
     * @param string $status
     * @param int $technicianId
     * @param bool $confirmation
     * @param bool $reminder
     * @param string $dateEndRangeUtc
     * @param bool $isVirtual
     * @param int $estimatedDurationMinutes
     * @param bool $includeRepInfoInEmails
     * @param string $notes
     * @param \CustomerManagement\ArrayType\ArrayOfAppointmentTypeEnum $appointmentType
     * @param string $customerFacingInfo
     * @param string $meetingLocation
     */
    public function __construct($appointmentId = null, $dateUtc = null, $status = null, $technicianId = null, $confirmation = null, $reminder = null, $dateEndRangeUtc = null, $isVirtual = null, $estimatedDurationMinutes = null, $includeRepInfoInEmails = null, $notes = null, \CustomerManagement\ArrayType\ArrayOfAppointmentTypeEnum $appointmentType = null, $customerFacingInfo = null, $meetingLocation = null)
    {
        $this
            ->setAppointmentId($appointmentId)
            ->setDateUtc($dateUtc)
            ->setStatus($status)
            ->setTechnicianId($technicianId)
            ->setConfirmation($confirmation)
            ->setReminder($reminder)
            ->setDateEndRangeUtc($dateEndRangeUtc)
            ->setIsVirtual($isVirtual)
            ->setEstimatedDurationMinutes($estimatedDurationMinutes)
            ->setIncludeRepInfoInEmails($includeRepInfoInEmails)
            ->setNotes($notes)
            ->setAppointmentType($appointmentType)
            ->setCustomerFacingInfo($customerFacingInfo)
            ->setMeetingLocation($meetingLocation);
    }
    /**
     * Get AppointmentId value
     * @return int
     */
    public function getAppointmentId()
    {
        return $this->AppointmentId;
    }
    /**
     * Set AppointmentId value
     * @param int $appointmentId
     * @return \CustomerManagement\StructType\EditScheduledAppointmentInputV2
     */
    public function setAppointmentId($appointmentId = null)
    {
        // validation for constraint: int
        if (!is_null($appointmentId) && !(is_int($appointmentId) || ctype_digit($appointmentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($appointmentId, true), gettype($appointmentId)), __LINE__);
        }
        $this->AppointmentId = $appointmentId;
        return $this;
    }
    /**
     * Get DateUtc value
     * @return string
     */
    public function getDateUtc()
    {
        return $this->DateUtc;
    }
    /**
     * Set DateUtc value
     * @param string $dateUtc
     * @return \CustomerManagement\StructType\EditScheduledAppointmentInputV2
     */
    public function setDateUtc($dateUtc = null)
    {
        // validation for constraint: string
        if (!is_null($dateUtc) && !is_string($dateUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateUtc, true), gettype($dateUtc)), __LINE__);
        }
        $this->DateUtc = $dateUtc;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \CustomerManagement\EnumType\ScheduledServiceDateStatus::valueIsValid()
     * @uses \CustomerManagement\EnumType\ScheduledServiceDateStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \CustomerManagement\StructType\EditScheduledAppointmentInputV2
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\ScheduledServiceDateStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\ScheduledServiceDateStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \CustomerManagement\EnumType\ScheduledServiceDateStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get TechnicianId value
     * @return int
     */
    public function getTechnicianId()
    {
        return $this->TechnicianId;
    }
    /**
     * Set TechnicianId value
     * @param int $technicianId
     * @return \CustomerManagement\StructType\EditScheduledAppointmentInputV2
     */
    public function setTechnicianId($technicianId = null)
    {
        // validation for constraint: int
        if (!is_null($technicianId) && !(is_int($technicianId) || ctype_digit($technicianId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($technicianId, true), gettype($technicianId)), __LINE__);
        }
        $this->TechnicianId = $technicianId;
        return $this;
    }
    /**
     * Get Confirmation value
     * @return bool
     */
    public function getConfirmation()
    {
        return $this->Confirmation;
    }
    /**
     * Set Confirmation value
     * @param bool $confirmation
     * @return \CustomerManagement\StructType\EditScheduledAppointmentInputV2
     */
    public function setConfirmation($confirmation = null)
    {
        // validation for constraint: boolean
        if (!is_null($confirmation) && !is_bool($confirmation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($confirmation, true), gettype($confirmation)), __LINE__);
        }
        $this->Confirmation = $confirmation;
        return $this;
    }
    /**
     * Get Reminder value
     * @return bool
     */
    public function getReminder()
    {
        return $this->Reminder;
    }
    /**
     * Set Reminder value
     * @param bool $reminder
     * @return \CustomerManagement\StructType\EditScheduledAppointmentInputV2
     */
    public function setReminder($reminder = null)
    {
        // validation for constraint: boolean
        if (!is_null($reminder) && !is_bool($reminder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reminder, true), gettype($reminder)), __LINE__);
        }
        $this->Reminder = $reminder;
        return $this;
    }
    /**
     * Get DateEndRangeUtc value
     * @return string
     */
    public function getDateEndRangeUtc()
    {
        return $this->DateEndRangeUtc;
    }
    /**
     * Set DateEndRangeUtc value
     * @param string $dateEndRangeUtc
     * @return \CustomerManagement\StructType\EditScheduledAppointmentInputV2
     */
    public function setDateEndRangeUtc($dateEndRangeUtc = null)
    {
        // validation for constraint: string
        if (!is_null($dateEndRangeUtc) && !is_string($dateEndRangeUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateEndRangeUtc, true), gettype($dateEndRangeUtc)), __LINE__);
        }
        $this->DateEndRangeUtc = $dateEndRangeUtc;
        return $this;
    }
    /**
     * Get IsVirtual value
     * @return bool
     */
    public function getIsVirtual()
    {
        return $this->IsVirtual;
    }
    /**
     * Set IsVirtual value
     * @param bool $isVirtual
     * @return \CustomerManagement\StructType\EditScheduledAppointmentInputV2
     */
    public function setIsVirtual($isVirtual = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVirtual) && !is_bool($isVirtual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVirtual, true), gettype($isVirtual)), __LINE__);
        }
        $this->IsVirtual = $isVirtual;
        return $this;
    }
    /**
     * Get EstimatedDurationMinutes value
     * @return int
     */
    public function getEstimatedDurationMinutes()
    {
        return $this->EstimatedDurationMinutes;
    }
    /**
     * Set EstimatedDurationMinutes value
     * @param int $estimatedDurationMinutes
     * @return \CustomerManagement\StructType\EditScheduledAppointmentInputV2
     */
    public function setEstimatedDurationMinutes($estimatedDurationMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($estimatedDurationMinutes) && !(is_int($estimatedDurationMinutes) || ctype_digit($estimatedDurationMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($estimatedDurationMinutes, true), gettype($estimatedDurationMinutes)), __LINE__);
        }
        $this->EstimatedDurationMinutes = $estimatedDurationMinutes;
        return $this;
    }
    /**
     * Get IncludeRepInfoInEmails value
     * @return bool
     */
    public function getIncludeRepInfoInEmails()
    {
        return $this->IncludeRepInfoInEmails;
    }
    /**
     * Set IncludeRepInfoInEmails value
     * @param bool $includeRepInfoInEmails
     * @return \CustomerManagement\StructType\EditScheduledAppointmentInputV2
     */
    public function setIncludeRepInfoInEmails($includeRepInfoInEmails = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeRepInfoInEmails) && !is_bool($includeRepInfoInEmails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeRepInfoInEmails, true), gettype($includeRepInfoInEmails)), __LINE__);
        }
        $this->IncludeRepInfoInEmails = $includeRepInfoInEmails;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \CustomerManagement\StructType\EditScheduledAppointmentInputV2
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get AppointmentType value
     * @return \CustomerManagement\ArrayType\ArrayOfAppointmentTypeEnum|null
     */
    public function getAppointmentType()
    {
        return $this->AppointmentType;
    }
    /**
     * Set AppointmentType value
     * @param \CustomerManagement\ArrayType\ArrayOfAppointmentTypeEnum $appointmentType
     * @return \CustomerManagement\StructType\EditScheduledAppointmentInputV2
     */
    public function setAppointmentType(\CustomerManagement\ArrayType\ArrayOfAppointmentTypeEnum $appointmentType = null)
    {
        $this->AppointmentType = $appointmentType;
        return $this;
    }
    /**
     * Get CustomerFacingInfo value
     * @return string|null
     */
    public function getCustomerFacingInfo()
    {
        return $this->CustomerFacingInfo;
    }
    /**
     * Set CustomerFacingInfo value
     * @param string $customerFacingInfo
     * @return \CustomerManagement\StructType\EditScheduledAppointmentInputV2
     */
    public function setCustomerFacingInfo($customerFacingInfo = null)
    {
        // validation for constraint: string
        if (!is_null($customerFacingInfo) && !is_string($customerFacingInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerFacingInfo, true), gettype($customerFacingInfo)), __LINE__);
        }
        $this->CustomerFacingInfo = $customerFacingInfo;
        return $this;
    }
    /**
     * Get MeetingLocation value
     * @return string|null
     */
    public function getMeetingLocation()
    {
        return $this->MeetingLocation;
    }
    /**
     * Set MeetingLocation value
     * @param string $meetingLocation
     * @return \CustomerManagement\StructType\EditScheduledAppointmentInputV2
     */
    public function setMeetingLocation($meetingLocation = null)
    {
        // validation for constraint: string
        if (!is_null($meetingLocation) && !is_string($meetingLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($meetingLocation, true), gettype($meetingLocation)), __LINE__);
        }
        $this->MeetingLocation = $meetingLocation;
        return $this;
    }
}
