<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCommitmentInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfCommitmentInfo extends AbstractStructArrayBase
{
    /**
     * The CommitmentInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CustomerManagement\StructType\CommitmentInfo[]
     */
    public $CommitmentInfo;
    /**
     * Constructor method for ArrayOfCommitmentInfo
     * @uses ArrayOfCommitmentInfo::setCommitmentInfo()
     * @param \CustomerManagement\StructType\CommitmentInfo[] $commitmentInfo
     */
    public function __construct(array $commitmentInfo = array())
    {
        $this
            ->setCommitmentInfo($commitmentInfo);
    }
    /**
     * Get CommitmentInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CustomerManagement\StructType\CommitmentInfo[]|null
     */
    public function getCommitmentInfo()
    {
        return isset($this->CommitmentInfo) ? $this->CommitmentInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCommitmentInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommitmentInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommitmentInfoForArrayConstraintsFromSetCommitmentInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCommitmentInfoCommitmentInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfCommitmentInfoCommitmentInfoItem instanceof \CustomerManagement\StructType\CommitmentInfo) {
                $invalidValues[] = is_object($arrayOfCommitmentInfoCommitmentInfoItem) ? get_class($arrayOfCommitmentInfoCommitmentInfoItem) : sprintf('%s(%s)', gettype($arrayOfCommitmentInfoCommitmentInfoItem), var_export($arrayOfCommitmentInfoCommitmentInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CommitmentInfo property can only contain items of type \CustomerManagement\StructType\CommitmentInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CommitmentInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\CommitmentInfo[] $commitmentInfo
     * @return \CustomerManagement\ArrayType\ArrayOfCommitmentInfo
     */
    public function setCommitmentInfo(array $commitmentInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($commitmentInfoArrayErrorMessage = self::validateCommitmentInfoForArrayConstraintsFromSetCommitmentInfo($commitmentInfo))) {
            throw new \InvalidArgumentException($commitmentInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($commitmentInfo) || (is_array($commitmentInfo) && empty($commitmentInfo))) {
            unset($this->CommitmentInfo);
        } else {
            $this->CommitmentInfo = $commitmentInfo;
        }
        return $this;
    }
    /**
     * Add item to CommitmentInfo value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\CommitmentInfo $item
     * @return \CustomerManagement\ArrayType\ArrayOfCommitmentInfo
     */
    public function addToCommitmentInfo(\CustomerManagement\StructType\CommitmentInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CustomerManagement\StructType\CommitmentInfo) {
            throw new \InvalidArgumentException(sprintf('The CommitmentInfo property can only contain items of type \CustomerManagement\StructType\CommitmentInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CommitmentInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CustomerManagement\StructType\CommitmentInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CustomerManagement\StructType\CommitmentInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CustomerManagement\StructType\CommitmentInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CustomerManagement\StructType\CommitmentInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CustomerManagement\StructType\CommitmentInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CommitmentInfo
     */
    public function getAttributeName()
    {
        return 'CommitmentInfo';
    }
}
