<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDownloadableSettingsOutput StructType
 * @subpackage Structs
 */
class GetDownloadableSettingsOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The Settings
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfPanelSettingInfo
     */
    public $Settings;
    /**
     * Constructor method for GetDownloadableSettingsOutput
     * @uses GetDownloadableSettingsOutput::setSuccess()
     * @uses GetDownloadableSettingsOutput::setErrorMessage()
     * @uses GetDownloadableSettingsOutput::setSettings()
     * @param bool $success
     * @param string $errorMessage
     * @param \CustomerManagement\ArrayType\ArrayOfPanelSettingInfo $settings
     */
    public function __construct($success = null, $errorMessage = null, \CustomerManagement\ArrayType\ArrayOfPanelSettingInfo $settings = null)
    {
        $this
            ->setSuccess($success)
            ->setErrorMessage($errorMessage)
            ->setSettings($settings);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\GetDownloadableSettingsOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\GetDownloadableSettingsOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get Settings value
     * @return \CustomerManagement\ArrayType\ArrayOfPanelSettingInfo|null
     */
    public function getSettings()
    {
        return $this->Settings;
    }
    /**
     * Set Settings value
     * @param \CustomerManagement\ArrayType\ArrayOfPanelSettingInfo $settings
     * @return \CustomerManagement\StructType\GetDownloadableSettingsOutput
     */
    public function setSettings(\CustomerManagement\ArrayType\ArrayOfPanelSettingInfo $settings = null)
    {
        $this->Settings = $settings;
        return $this;
    }
}
