<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetWifiInput StructType
 * @subpackage Structs
 */
class SetWifiInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The DeviceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeviceId;
    /**
     * The EncryptionType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EncryptionType;
    /**
     * The EncryptionAlgorithm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $EncryptionAlgorithm;
    /**
     * The SSID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SSID;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * Constructor method for SetWifiInput
     * @uses SetWifiInput::setCustomerId()
     * @uses SetWifiInput::setDeviceId()
     * @uses SetWifiInput::setEncryptionType()
     * @uses SetWifiInput::setEncryptionAlgorithm()
     * @uses SetWifiInput::setSSID()
     * @uses SetWifiInput::setPassword()
     * @param int $customerId
     * @param int $deviceId
     * @param string $encryptionType
     * @param string $encryptionAlgorithm
     * @param string $sSID
     * @param string $password
     */
    public function __construct($customerId = null, $deviceId = null, $encryptionType = null, $encryptionAlgorithm = null, $sSID = null, $password = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setDeviceId($deviceId)
            ->setEncryptionType($encryptionType)
            ->setEncryptionAlgorithm($encryptionAlgorithm)
            ->setSSID($sSID)
            ->setPassword($password);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\SetWifiInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get DeviceId value
     * @return int
     */
    public function getDeviceId()
    {
        return $this->DeviceId;
    }
    /**
     * Set DeviceId value
     * @param int $deviceId
     * @return \CustomerManagement\StructType\SetWifiInput
     */
    public function setDeviceId($deviceId = null)
    {
        // validation for constraint: int
        if (!is_null($deviceId) && !(is_int($deviceId) || ctype_digit($deviceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceId, true), gettype($deviceId)), __LINE__);
        }
        $this->DeviceId = $deviceId;
        return $this;
    }
    /**
     * Get EncryptionType value
     * @return string
     */
    public function getEncryptionType()
    {
        return $this->EncryptionType;
    }
    /**
     * Set EncryptionType value
     * @uses \CustomerManagement\EnumType\WiFiEncryptionTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\WiFiEncryptionTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $encryptionType
     * @return \CustomerManagement\StructType\SetWifiInput
     */
    public function setEncryptionType($encryptionType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\WiFiEncryptionTypeEnum::valueIsValid($encryptionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\WiFiEncryptionTypeEnum', is_array($encryptionType) ? implode(', ', $encryptionType) : var_export($encryptionType, true), implode(', ', \CustomerManagement\EnumType\WiFiEncryptionTypeEnum::getValidValues())), __LINE__);
        }
        $this->EncryptionType = $encryptionType;
        return $this;
    }
    /**
     * Get EncryptionAlgorithm value
     * @return string
     */
    public function getEncryptionAlgorithm()
    {
        return $this->EncryptionAlgorithm;
    }
    /**
     * Set EncryptionAlgorithm value
     * @uses \CustomerManagement\EnumType\WiFiEncryptionAlgorithmEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\WiFiEncryptionAlgorithmEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $encryptionAlgorithm
     * @return \CustomerManagement\StructType\SetWifiInput
     */
    public function setEncryptionAlgorithm($encryptionAlgorithm = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\WiFiEncryptionAlgorithmEnum::valueIsValid($encryptionAlgorithm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\WiFiEncryptionAlgorithmEnum', is_array($encryptionAlgorithm) ? implode(', ', $encryptionAlgorithm) : var_export($encryptionAlgorithm, true), implode(', ', \CustomerManagement\EnumType\WiFiEncryptionAlgorithmEnum::getValidValues())), __LINE__);
        }
        $this->EncryptionAlgorithm = $encryptionAlgorithm;
        return $this;
    }
    /**
     * Get SSID value
     * @return string|null
     */
    public function getSSID()
    {
        return $this->SSID;
    }
    /**
     * Set SSID value
     * @param string $sSID
     * @return \CustomerManagement\StructType\SetWifiInput
     */
    public function setSSID($sSID = null)
    {
        // validation for constraint: string
        if (!is_null($sSID) && !is_string($sSID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sSID, true), gettype($sSID)), __LINE__);
        }
        $this->SSID = $sSID;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \CustomerManagement\StructType\SetWifiInput
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
}
