<?php

namespace CustomerManagement\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \CustomerManagement\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\CustomerManagement\StructType\Authentication $authentication, $nameSpace = 'http://www.alarm.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named SendEnterpriseNotice
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Sends a message to the customers panel.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\SendEnterpriseNotice $parameters
     * @return \CustomerManagement\StructType\SendEnterpriseNoticeResponse|bool
     */
    public function SendEnterpriseNotice(\CustomerManagement\StructType\SendEnterpriseNotice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendEnterpriseNotice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendDeviceGetAssociationsCommand
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Send a string command to get associations for a specific customer-device-association group - to be logged in event history.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\SendDeviceGetAssociationsCommand $parameters
     * @return \CustomerManagement\StructType\SendDeviceGetAssociationsCommandResponse|bool
     */
    public function SendDeviceGetAssociationsCommand(\CustomerManagement\StructType\SendDeviceGetAssociationsCommand $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendDeviceGetAssociationsCommand($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CustomerManagement\StructType\SendDeviceGetAssociationsCommandResponse|\CustomerManagement\StructType\SendEnterpriseNoticeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
