<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWsUserCodeInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfWsUserCodeInfo extends AbstractStructArrayBase
{
    /**
     * The WsUserCodeInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CustomerManagement\StructType\WsUserCodeInfo[]
     */
    public $WsUserCodeInfo;
    /**
     * Constructor method for ArrayOfWsUserCodeInfo
     * @uses ArrayOfWsUserCodeInfo::setWsUserCodeInfo()
     * @param \CustomerManagement\StructType\WsUserCodeInfo[] $wsUserCodeInfo
     */
    public function __construct(array $wsUserCodeInfo = array())
    {
        $this
            ->setWsUserCodeInfo($wsUserCodeInfo);
    }
    /**
     * Get WsUserCodeInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CustomerManagement\StructType\WsUserCodeInfo[]|null
     */
    public function getWsUserCodeInfo()
    {
        return isset($this->WsUserCodeInfo) ? $this->WsUserCodeInfo : null;
    }
    /**
     * Set WsUserCodeInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\WsUserCodeInfo[] $wsUserCodeInfo
     * @return \CustomerManagement\ArrayType\ArrayOfWsUserCodeInfo
     */
    public function setWsUserCodeInfo(array $wsUserCodeInfo = array())
    {
        foreach ($wsUserCodeInfo as $arrayOfWsUserCodeInfoWsUserCodeInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfWsUserCodeInfoWsUserCodeInfoItem instanceof \CustomerManagement\StructType\WsUserCodeInfo) {
                throw new \InvalidArgumentException(sprintf('The WsUserCodeInfo property can only contain items of \CustomerManagement\StructType\WsUserCodeInfo, "%s" given', is_object($arrayOfWsUserCodeInfoWsUserCodeInfoItem) ? get_class($arrayOfWsUserCodeInfoWsUserCodeInfoItem) : gettype($arrayOfWsUserCodeInfoWsUserCodeInfoItem)), __LINE__);
            }
        }
        if (is_null($wsUserCodeInfo) || (is_array($wsUserCodeInfo) && empty($wsUserCodeInfo))) {
            unset($this->WsUserCodeInfo);
        } else {
            $this->WsUserCodeInfo = $wsUserCodeInfo;
        }
        return $this;
    }
    /**
     * Add item to WsUserCodeInfo value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\WsUserCodeInfo $item
     * @return \CustomerManagement\ArrayType\ArrayOfWsUserCodeInfo
     */
    public function addToWsUserCodeInfo(\CustomerManagement\StructType\WsUserCodeInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CustomerManagement\StructType\WsUserCodeInfo) {
            throw new \InvalidArgumentException(sprintf('The WsUserCodeInfo property can only contain items of \CustomerManagement\StructType\WsUserCodeInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->WsUserCodeInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CustomerManagement\StructType\WsUserCodeInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CustomerManagement\StructType\WsUserCodeInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CustomerManagement\StructType\WsUserCodeInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CustomerManagement\StructType\WsUserCodeInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CustomerManagement\StructType\WsUserCodeInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WsUserCodeInfo
     */
    public function getAttributeName()
    {
        return 'WsUserCodeInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\ArrayType\ArrayOfWsUserCodeInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
