<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for WiFiEncryptionTypeEnum EnumType
 * @subpackage Enumerations
 */
class WiFiEncryptionTypeEnum
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Wep'
     * @return string 'Wep'
     */
    const VALUE_WEP = 'Wep';
    /**
     * Constant for value 'Wpa'
     * @return string 'Wpa'
     */
    const VALUE_WPA = 'Wpa';
    /**
     * Constant for value 'Wpa2'
     * @return string 'Wpa2'
     */
    const VALUE_WPA_2_1 = 'Wpa2';
    /**
     * Constant for value 'Wpa2Enterprise'
     * @return string 'Wpa2Enterprise'
     */
    const VALUE_WPA_2_ENTERPRISE = 'Wpa2Enterprise';
    /**
     * Constant for value 'Wps'
     * @return string 'Wps'
     */
    const VALUE_WPS = 'Wps';
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_WEP
     * @uses self::VALUE_WPA_1
     * @uses self::VALUE_WPA_2_1
     * @uses self::VALUE_WPA_2_ENTERPRISE
     * @uses self::VALUE_WPS
     * @uses self::VALUE_UNKNOWN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_WEP,
            self::VALUE_WPA_1,
            self::VALUE_WPA_2_1,
            self::VALUE_WPA_2_ENTERPRISE,
            self::VALUE_WPS,
            self::VALUE_UNKNOWN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
