<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRemoveNotificationsOutput ArrayType
 * @subpackage Arrays
 */
class ArrayOfRemoveNotificationsOutput extends AbstractStructArrayBase
{
    /**
     * The RemoveNotificationsOutput
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CustomerManagement\StructType\RemoveNotificationsOutput[]
     */
    public $RemoveNotificationsOutput;
    /**
     * Constructor method for ArrayOfRemoveNotificationsOutput
     * @uses ArrayOfRemoveNotificationsOutput::setRemoveNotificationsOutput()
     * @param \CustomerManagement\StructType\RemoveNotificationsOutput[] $removeNotificationsOutput
     */
    public function __construct(array $removeNotificationsOutput = array())
    {
        $this
            ->setRemoveNotificationsOutput($removeNotificationsOutput);
    }
    /**
     * Get RemoveNotificationsOutput value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CustomerManagement\StructType\RemoveNotificationsOutput[]|null
     */
    public function getRemoveNotificationsOutput()
    {
        return isset($this->RemoveNotificationsOutput) ? $this->RemoveNotificationsOutput : null;
    }
    /**
     * Set RemoveNotificationsOutput value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\RemoveNotificationsOutput[] $removeNotificationsOutput
     * @return \CustomerManagement\ArrayType\ArrayOfRemoveNotificationsOutput
     */
    public function setRemoveNotificationsOutput(array $removeNotificationsOutput = array())
    {
        foreach ($removeNotificationsOutput as $arrayOfRemoveNotificationsOutputRemoveNotificationsOutputItem) {
            // validation for constraint: itemType
            if (!$arrayOfRemoveNotificationsOutputRemoveNotificationsOutputItem instanceof \CustomerManagement\StructType\RemoveNotificationsOutput) {
                throw new \InvalidArgumentException(sprintf('The RemoveNotificationsOutput property can only contain items of \CustomerManagement\StructType\RemoveNotificationsOutput, "%s" given', is_object($arrayOfRemoveNotificationsOutputRemoveNotificationsOutputItem) ? get_class($arrayOfRemoveNotificationsOutputRemoveNotificationsOutputItem) : gettype($arrayOfRemoveNotificationsOutputRemoveNotificationsOutputItem)), __LINE__);
            }
        }
        if (is_null($removeNotificationsOutput) || (is_array($removeNotificationsOutput) && empty($removeNotificationsOutput))) {
            unset($this->RemoveNotificationsOutput);
        } else {
            $this->RemoveNotificationsOutput = $removeNotificationsOutput;
        }
        return $this;
    }
    /**
     * Add item to RemoveNotificationsOutput value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\RemoveNotificationsOutput $item
     * @return \CustomerManagement\ArrayType\ArrayOfRemoveNotificationsOutput
     */
    public function addToRemoveNotificationsOutput(\CustomerManagement\StructType\RemoveNotificationsOutput $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CustomerManagement\StructType\RemoveNotificationsOutput) {
            throw new \InvalidArgumentException(sprintf('The RemoveNotificationsOutput property can only contain items of \CustomerManagement\StructType\RemoveNotificationsOutput, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RemoveNotificationsOutput[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CustomerManagement\StructType\RemoveNotificationsOutput|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CustomerManagement\StructType\RemoveNotificationsOutput|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CustomerManagement\StructType\RemoveNotificationsOutput|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CustomerManagement\StructType\RemoveNotificationsOutput|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CustomerManagement\StructType\RemoveNotificationsOutput|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RemoveNotificationsOutput
     */
    public function getAttributeName()
    {
        return 'RemoveNotificationsOutput';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\ArrayType\ArrayOfRemoveNotificationsOutput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
