<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for AddOnFeatureEnum EnumType
 * @subpackage Enumerations
 */
class AddOnFeatureEnum
{
    /**
     * Constant for value 'VoiceNotificationsForAlarms'
     * @return string 'VoiceNotificationsForAlarms'
     */
    const VALUE_VOICE_NOTIFICATIONS_FOR_ALARMS = 'VoiceNotificationsForAlarms';
    /**
     * Constant for value 'VoiceNotificationsForMonitoring'
     * @return string 'VoiceNotificationsForMonitoring'
     */
    const VALUE_VOICE_NOTIFICATIONS_FOR_MONITORING = 'VoiceNotificationsForMonitoring';
    /**
     * Constant for value 'LightAutomation'
     * @return string 'LightAutomation'
     */
    const VALUE_LIGHT_AUTOMATION = 'LightAutomation';
    /**
     * Constant for value 'UserCodeControl'
     * @return string 'UserCodeControl'
     */
    const VALUE_USER_CODE_CONTROL = 'UserCodeControl';
    /**
     * Constant for value 'RemoteArming'
     * @return string 'RemoteArming'
     */
    const VALUE_REMOTE_ARMING = 'RemoteArming';
    /**
     * Constant for value 'ThermostatControl'
     * @return string 'ThermostatControl'
     */
    const VALUE_THERMOSTAT_CONTROL = 'ThermostatControl';
    /**
     * Constant for value 'ArmingSupervision'
     * @return string 'ArmingSupervision'
     */
    const VALUE_ARMING_SUPERVISION = 'ArmingSupervision';
    /**
     * Constant for value 'NormalActivityReports'
     * @return string 'NormalActivityReports'
     */
    const VALUE_NORMAL_ACTIVITY_REPORTS = 'NormalActivityReports';
    /**
     * Constant for value 'ArmingReports'
     * @return string 'ArmingReports'
     */
    const VALUE_ARMING_REPORTS = 'ArmingReports';
    /**
     * Constant for value 'ArmingSchedules'
     * @return string 'ArmingSchedules'
     */
    const VALUE_ARMING_SCHEDULES = 'ArmingSchedules';
    /**
     * Constant for value 'Inactivity'
     * @return string 'Inactivity'
     */
    const VALUE_INACTIVITY = 'Inactivity';
    /**
     * Constant for value 'FiveNormalActivitySensors'
     * @return string 'FiveNormalActivitySensors'
     */
    const VALUE_FIVE_NORMAL_ACTIVITY_SENSORS = 'FiveNormalActivitySensors';
    /**
     * Constant for value 'ProVideo'
     * @return string 'ProVideo'
     */
    const VALUE_PRO_VIDEO = 'ProVideo';
    /**
     * Constant for value 'ProVideoPlus'
     * @return string 'ProVideoPlus'
     */
    const VALUE_PRO_VIDEO_PLUS = 'ProVideoPlus';
    /**
     * Constant for value 'TwoFiftyMBExtraVideoStorage'
     * @return string 'TwoFiftyMBExtraVideoStorage'
     */
    const VALUE_TWO_FIFTY_MBEXTRA_VIDEO_STORAGE = 'TwoFiftyMBExtraVideoStorage';
    /**
     * Constant for value 'TwoWayVoice'
     * @return string 'TwoWayVoice'
     */
    const VALUE_TWO_WAY_VOICE = 'TwoWayVoice';
    /**
     * Constant for value 'WeatherToPanel'
     * @return string 'WeatherToPanel'
     */
    const VALUE_WEATHER_TO_PANEL = 'WeatherToPanel';
    /**
     * Constant for value 'DigitalInputVideos'
     * @return string 'DigitalInputVideos'
     */
    const VALUE_DIGITAL_INPUT_VIDEOS = 'DigitalInputVideos';
    /**
     * Constant for value 'MedicationAlerts'
     * @return string 'MedicationAlerts'
     */
    const VALUE_MEDICATION_ALERTS = 'MedicationAlerts';
    /**
     * Constant for value 'ZWaveLights'
     * @return string 'ZWaveLights'
     */
    const VALUE_ZWAVE_LIGHTS = 'ZWaveLights';
    /**
     * Constant for value 'ZWaveThermostats'
     * @return string 'ZWaveThermostats'
     */
    const VALUE_ZWAVE_THERMOSTATS = 'ZWaveThermostats';
    /**
     * Constant for value 'ZWaveLocks'
     * @return string 'ZWaveLocks'
     */
    const VALUE_ZWAVE_LOCKS = 'ZWaveLocks';
    /**
     * Constant for value 'EnterpriseNotices'
     * @return string 'EnterpriseNotices'
     */
    const VALUE_ENTERPRISE_NOTICES = 'EnterpriseNotices';
    /**
     * Constant for value 'ZWaveEnergy'
     * @return string 'ZWaveEnergy'
     */
    const VALUE_ZWAVE_ENERGY = 'ZWaveEnergy';
    /**
     * Constant for value 'Reminders'
     * @return string 'Reminders'
     */
    const VALUE_REMINDERS = 'Reminders';
    /**
     * Constant for value 'SevereWeatherAlerts'
     * @return string 'SevereWeatherAlerts'
     */
    const VALUE_SEVERE_WEATHER_ALERTS = 'SevereWeatherAlerts';
    /**
     * Constant for value 'ImageSensorAlarms'
     * @return string 'ImageSensorAlarms'
     */
    const VALUE_IMAGE_SENSOR_ALARMS = 'ImageSensorAlarms';
    /**
     * Constant for value 'ImageSensorPlus'
     * @return string 'ImageSensorPlus'
     */
    const VALUE_IMAGE_SENSOR_PLUS = 'ImageSensorPlus';
    /**
     * Constant for value 'ImageSensorExtraUploads'
     * @return string 'ImageSensorExtraUploads'
     */
    const VALUE_IMAGE_SENSOR_EXTRA_UPLOADS = 'ImageSensorExtraUploads';
    /**
     * Constant for value 'EnterpriseSecurityConsole'
     * @return string 'EnterpriseSecurityConsole'
     */
    const VALUE_ENTERPRISE_SECURITY_CONSOLE = 'EnterpriseSecurityConsole';
    /**
     * Constant for value 'SmartEnergyPlus'
     * @return string 'SmartEnergyPlus'
     */
    const VALUE_SMART_ENERGY_PLUS = 'SmartEnergyPlus';
    /**
     * Constant for value 'Securus'
     * @return string 'Securus'
     */
    const VALUE_SECURUS = 'Securus';
    /**
     * Constant for value 'LutronRemoteAccess'
     * @return string 'LutronRemoteAccess'
     */
    const VALUE_LUTRON_REMOTE_ACCESS = 'LutronRemoteAccess';
    /**
     * Constant for value 'Obsolete_LutronLightsAndThermostats'
     * @return string 'Obsolete_LutronLightsAndThermostats'
     */
    const VALUE_OBSOLETE_LUTRON_LIGHTS_AND_THERMOSTATS = 'Obsolete_LutronLightsAndThermostats';
    /**
     * Constant for value 'IDProtection'
     * @return string 'IDProtection'
     */
    const VALUE_IDPROTECTION = 'IDProtection';
    /**
     * Constant for value 'GreenButton'
     * @return string 'GreenButton'
     */
    const VALUE_GREEN_BUTTON = 'GreenButton';
    /**
     * Constant for value 'GarageDoors'
     * @return string 'GarageDoors'
     */
    const VALUE_GARAGE_DOORS = 'GarageDoors';
    /**
     * Constant for value 'Wellness'
     * @return string 'Wellness'
     */
    const VALUE_WELLNESS = 'Wellness';
    /**
     * Constant for value 'AdvancedEnergy'
     * @return string 'AdvancedEnergy'
     */
    const VALUE_ADVANCED_ENERGY = 'AdvancedEnergy';
    /**
     * Constant for value 'AdvancedAutomation'
     * @return string 'AdvancedAutomation'
     */
    const VALUE_ADVANCED_AUTOMATION = 'AdvancedAutomation';
    /**
     * Constant for value 'LutronIntegration'
     * @return string 'LutronIntegration'
     */
    const VALUE_LUTRON_INTEGRATION = 'LutronIntegration';
    /**
     * Constant for value 'LiftMasterIntegration'
     * @return string 'LiftMasterIntegration'
     */
    const VALUE_LIFT_MASTER_INTEGRATION = 'LiftMasterIntegration';
    /**
     * Constant for value 'SchneiderIntegration'
     * @return string 'SchneiderIntegration'
     */
    const VALUE_SCHNEIDER_INTEGRATION = 'SchneiderIntegration';
    /**
     * Constant for value 'Video24x7PerSVR'
     * @return string 'Video24x7PerSVR'
     */
    const VALUE_VIDEO_24_X_7_PER_SVR = 'Video24x7PerSVR';
    /**
     * Constant for value 'TaggIntegration'
     * @return string 'TaggIntegration'
     */
    const VALUE_TAGG_INTEGRATION = 'TaggIntegration';
    /**
     * Constant for value 'WaterManagement'
     * @return string 'WaterManagement'
     */
    const VALUE_WATER_MANAGEMENT = 'WaterManagement';
    /**
     * Constant for value 'CommercialActivityReports'
     * @return string 'CommercialActivityReports'
     */
    const VALUE_COMMERCIAL_ACTIVITY_REPORTS = 'CommercialActivityReports';
    /**
     * Constant for value 'BeCloseCommunityView'
     * @return string 'BeCloseCommunityView'
     */
    const VALUE_BE_CLOSE_COMMUNITY_VIEW = 'BeCloseCommunityView';
    /**
     * Constant for value 'ULCommericial'
     * @return string 'ULCommericial'
     */
    const VALUE_ULCOMMERICIAL = 'ULCommericial';
    /**
     * Constant for value 'SolarMonitoring'
     * @return string 'SolarMonitoring'
     */
    const VALUE_SOLAR_MONITORING = 'SolarMonitoring';
    /**
     * Constant for value 'SolarEdgeIntegration'
     * @return string 'SolarEdgeIntegration'
     */
    const VALUE_SOLAR_EDGE_INTEGRATION = 'SolarEdgeIntegration';
    /**
     * Constant for value 'EnphaseIntegration'
     * @return string 'EnphaseIntegration'
     */
    const VALUE_ENPHASE_INTEGRATION = 'EnphaseIntegration';
    /**
     * Constant for value 'NESTIntegration'
     * @return string 'NESTIntegration'
     */
    const VALUE_NESTINTEGRATION = 'NESTIntegration';
    /**
     * Constant for value 'SMSAlarms'
     * @return string 'SMSAlarms'
     */
    const VALUE_SMSALARMS = 'SMSAlarms';
    /**
     * Constant for value 'SMSNotificationsMexico'
     * @return string 'SMSNotificationsMexico'
     */
    const VALUE_SMSNOTIFICATIONS_MEXICO = 'SMSNotificationsMexico';
    /**
     * Constant for value 'EnterpriseEnergy'
     * @return string 'EnterpriseEnergy'
     */
    const VALUE_ENTERPRISE_ENERGY = 'EnterpriseEnergy';
    /**
     * Constant for value 'EnterpriseWellness'
     * @return string 'EnterpriseWellness'
     */
    const VALUE_ENTERPRISE_WELLNESS = 'EnterpriseWellness';
    /**
     * Constant for value 'IrrigationControl'
     * @return string 'IrrigationControl'
     */
    const VALUE_IRRIGATION_CONTROL = 'IrrigationControl';
    /**
     * Constant for value 'RachioIntegration'
     * @return string 'RachioIntegration'
     */
    const VALUE_RACHIO_INTEGRATION = 'RachioIntegration';
    /**
     * Constant for value 'ConnectedCar'
     * @return string 'ConnectedCar'
     */
    const VALUE_CONNECTED_CAR = 'ConnectedCar';
    /**
     * Constant for value 'PropaneMonitoring'
     * @return string 'PropaneMonitoring'
     */
    const VALUE_PROPANE_MONITORING = 'PropaneMonitoring';
    /**
     * Constant for value 'SMSNotificationsChile'
     * @return string 'SMSNotificationsChile'
     */
    const VALUE_SMSNOTIFICATIONS_CHILE = 'SMSNotificationsChile';
    /**
     * Constant for value 'SMSNotificationsColombia'
     * @return string 'SMSNotificationsColombia'
     */
    const VALUE_SMSNOTIFICATIONS_COLOMBIA = 'SMSNotificationsColombia';
    /**
     * Constant for value 'SMSNotificationsNZ'
     * @return string 'SMSNotificationsNZ'
     */
    const VALUE_SMSNOTIFICATIONS_NZ = 'SMSNotificationsNZ';
    /**
     * Constant for value 'SMSNotificationsAustralia'
     * @return string 'SMSNotificationsAustralia'
     */
    const VALUE_SMSNOTIFICATIONS_AUSTRALIA = 'SMSNotificationsAustralia';
    /**
     * Constant for value 'SMSNotificationsBrazil'
     * @return string 'SMSNotificationsBrazil'
     */
    const VALUE_SMSNOTIFICATIONS_BRAZIL = 'SMSNotificationsBrazil';
    /**
     * Constant for value 'SMSNotificationsPanama'
     * @return string 'SMSNotificationsPanama'
     */
    const VALUE_SMSNOTIFICATIONS_PANAMA = 'SMSNotificationsPanama';
    /**
     * Constant for value 'CosaIntegration'
     * @return string 'CosaIntegration'
     */
    const VALUE_COSA_INTEGRATION = 'CosaIntegration';
    /**
     * Constant for value 'OSnappIntegration'
     * @return string 'OSnappIntegration'
     */
    const VALUE_OSNAPP_INTEGRATION = 'OSnappIntegration';
    /**
     * Constant for value 'ConnectedCarPlus'
     * @return string 'ConnectedCarPlus'
     */
    const VALUE_CONNECTED_CAR_PLUS = 'ConnectedCarPlus';
    /**
     * Constant for value 'DoorbellCameras'
     * @return string 'DoorbellCameras'
     */
    const VALUE_DOORBELL_CAMERAS = 'DoorbellCameras';
    /**
     * Constant for value 'UnexpectedActivityAlerts'
     * @return string 'UnexpectedActivityAlerts'
     */
    const VALUE_UNEXPECTED_ACTIVITY_ALERTS = 'UnexpectedActivityAlerts';
    /**
     * Constant for value 'AccessControl'
     * @return string 'AccessControl'
     */
    const VALUE_ACCESS_CONTROL = 'AccessControl';
    /**
     * Constant for value 'FireFighter'
     * @return string 'FireFighter'
     */
    const VALUE_FIRE_FIGHTER = 'FireFighter';
    /**
     * Constant for value 'HourlySupervision'
     * @return string 'HourlySupervision'
     */
    const VALUE_HOURLY_SUPERVISION = 'HourlySupervision';
    /**
     * Constant for value 'SixHourSupervision'
     * @return string 'SixHourSupervision'
     */
    const VALUE_SIX_HOUR_SUPERVISION = 'SixHourSupervision';
    /**
     * Constant for value 'BasicDoorbell'
     * @return string 'BasicDoorbell'
     */
    const VALUE_BASIC_DOORBELL = 'BasicDoorbell';
    /**
     * Constant for value 'AlarmVisualVerification'
     * @return string 'AlarmVisualVerification'
     */
    const VALUE_ALARM_VISUAL_VERIFICATION = 'AlarmVisualVerification';
    /**
     * Constant for value 'PanicButton'
     * @return string 'PanicButton'
     */
    const VALUE_PANIC_BUTTON = 'PanicButton';
    /**
     * Constant for value 'AudioIntegration'
     * @return string 'AudioIntegration'
     */
    const VALUE_AUDIO_INTEGRATION = 'AudioIntegration';
    /**
     * Constant for value 'KonaLabsWaterMetering'
     * @return string 'KonaLabsWaterMetering'
     */
    const VALUE_KONA_LABS_WATER_METERING = 'KonaLabsWaterMetering';
    /**
     * Constant for value 'VideoDeviceAudio'
     * @return string 'VideoDeviceAudio'
     */
    const VALUE_VIDEO_DEVICE_AUDIO = 'VideoDeviceAudio';
    /**
     * Constant for value 'CancelVerify'
     * @return string 'CancelVerify'
     */
    const VALUE_CANCEL_VERIFY = 'CancelVerify';
    /**
     * Constant for value 'SMSNotificationsBelgium'
     * @return string 'SMSNotificationsBelgium'
     */
    const VALUE_SMSNOTIFICATIONS_BELGIUM = 'SMSNotificationsBelgium';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_VOICE_NOTIFICATIONS_FOR_ALARMS
     * @uses self::VALUE_VOICE_NOTIFICATIONS_FOR_MONITORING
     * @uses self::VALUE_LIGHT_AUTOMATION
     * @uses self::VALUE_USER_CODE_CONTROL
     * @uses self::VALUE_REMOTE_ARMING
     * @uses self::VALUE_THERMOSTAT_CONTROL
     * @uses self::VALUE_ARMING_SUPERVISION
     * @uses self::VALUE_NORMAL_ACTIVITY_REPORTS
     * @uses self::VALUE_ARMING_REPORTS
     * @uses self::VALUE_ARMING_SCHEDULES
     * @uses self::VALUE_INACTIVITY
     * @uses self::VALUE_FIVE_NORMAL_ACTIVITY_SENSORS
     * @uses self::VALUE_PRO_VIDEO
     * @uses self::VALUE_PRO_VIDEO_PLUS
     * @uses self::VALUE_TWO_FIFTY_MBEXTRA_VIDEO_STORAGE
     * @uses self::VALUE_TWO_WAY_VOICE
     * @uses self::VALUE_WEATHER_TO_PANEL
     * @uses self::VALUE_DIGITAL_INPUT_VIDEOS
     * @uses self::VALUE_MEDICATION_ALERTS
     * @uses self::VALUE_ZWAVE_LIGHTS
     * @uses self::VALUE_ZWAVE_THERMOSTATS
     * @uses self::VALUE_ZWAVE_LOCKS
     * @uses self::VALUE_ENTERPRISE_NOTICES
     * @uses self::VALUE_ZWAVE_ENERGY
     * @uses self::VALUE_REMINDERS
     * @uses self::VALUE_SEVERE_WEATHER_ALERTS
     * @uses self::VALUE_IMAGE_SENSOR_ALARMS
     * @uses self::VALUE_IMAGE_SENSOR_PLUS
     * @uses self::VALUE_IMAGE_SENSOR_EXTRA_UPLOADS
     * @uses self::VALUE_ENTERPRISE_SECURITY_CONSOLE
     * @uses self::VALUE_SMART_ENERGY_PLUS
     * @uses self::VALUE_SECURUS
     * @uses self::VALUE_LUTRON_REMOTE_ACCESS
     * @uses self::VALUE_OBSOLETE_LUTRON_LIGHTS_AND_THERMOSTATS
     * @uses self::VALUE_IDPROTECTION
     * @uses self::VALUE_GREEN_BUTTON
     * @uses self::VALUE_GARAGE_DOORS
     * @uses self::VALUE_WELLNESS
     * @uses self::VALUE_ADVANCED_ENERGY
     * @uses self::VALUE_ADVANCED_AUTOMATION
     * @uses self::VALUE_LUTRON_INTEGRATION
     * @uses self::VALUE_LIFT_MASTER_INTEGRATION
     * @uses self::VALUE_SCHNEIDER_INTEGRATION
     * @uses self::VALUE_VIDEO_24_X_7_PER_SVR
     * @uses self::VALUE_TAGG_INTEGRATION
     * @uses self::VALUE_WATER_MANAGEMENT
     * @uses self::VALUE_COMMERCIAL_ACTIVITY_REPORTS
     * @uses self::VALUE_BE_CLOSE_COMMUNITY_VIEW
     * @uses self::VALUE_ULCOMMERICIAL
     * @uses self::VALUE_SOLAR_MONITORING
     * @uses self::VALUE_SOLAR_EDGE_INTEGRATION
     * @uses self::VALUE_ENPHASE_INTEGRATION
     * @uses self::VALUE_NESTINTEGRATION
     * @uses self::VALUE_SMSALARMS
     * @uses self::VALUE_SMSNOTIFICATIONS_MEXICO
     * @uses self::VALUE_ENTERPRISE_ENERGY
     * @uses self::VALUE_ENTERPRISE_WELLNESS
     * @uses self::VALUE_IRRIGATION_CONTROL
     * @uses self::VALUE_RACHIO_INTEGRATION
     * @uses self::VALUE_CONNECTED_CAR
     * @uses self::VALUE_PROPANE_MONITORING
     * @uses self::VALUE_SMSNOTIFICATIONS_CHILE
     * @uses self::VALUE_SMSNOTIFICATIONS_COLOMBIA
     * @uses self::VALUE_SMSNOTIFICATIONS_NZ
     * @uses self::VALUE_SMSNOTIFICATIONS_AUSTRALIA
     * @uses self::VALUE_SMSNOTIFICATIONS_BRAZIL
     * @uses self::VALUE_SMSNOTIFICATIONS_PANAMA
     * @uses self::VALUE_COSA_INTEGRATION
     * @uses self::VALUE_OSNAPP_INTEGRATION
     * @uses self::VALUE_CONNECTED_CAR_PLUS
     * @uses self::VALUE_DOORBELL_CAMERAS
     * @uses self::VALUE_UNEXPECTED_ACTIVITY_ALERTS
     * @uses self::VALUE_ACCESS_CONTROL
     * @uses self::VALUE_FIRE_FIGHTER
     * @uses self::VALUE_HOURLY_SUPERVISION
     * @uses self::VALUE_SIX_HOUR_SUPERVISION
     * @uses self::VALUE_BASIC_DOORBELL
     * @uses self::VALUE_ALARM_VISUAL_VERIFICATION
     * @uses self::VALUE_PANIC_BUTTON
     * @uses self::VALUE_AUDIO_INTEGRATION
     * @uses self::VALUE_KONA_LABS_WATER_METERING
     * @uses self::VALUE_VIDEO_DEVICE_AUDIO
     * @uses self::VALUE_CANCEL_VERIFY
     * @uses self::VALUE_SMSNOTIFICATIONS_BELGIUM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_VOICE_NOTIFICATIONS_FOR_ALARMS,
            self::VALUE_VOICE_NOTIFICATIONS_FOR_MONITORING,
            self::VALUE_LIGHT_AUTOMATION,
            self::VALUE_USER_CODE_CONTROL,
            self::VALUE_REMOTE_ARMING,
            self::VALUE_THERMOSTAT_CONTROL,
            self::VALUE_ARMING_SUPERVISION,
            self::VALUE_NORMAL_ACTIVITY_REPORTS,
            self::VALUE_ARMING_REPORTS,
            self::VALUE_ARMING_SCHEDULES,
            self::VALUE_INACTIVITY,
            self::VALUE_FIVE_NORMAL_ACTIVITY_SENSORS,
            self::VALUE_PRO_VIDEO,
            self::VALUE_PRO_VIDEO_PLUS,
            self::VALUE_TWO_FIFTY_MBEXTRA_VIDEO_STORAGE,
            self::VALUE_TWO_WAY_VOICE,
            self::VALUE_WEATHER_TO_PANEL,
            self::VALUE_DIGITAL_INPUT_VIDEOS,
            self::VALUE_MEDICATION_ALERTS,
            self::VALUE_ZWAVE_LIGHTS,
            self::VALUE_ZWAVE_THERMOSTATS,
            self::VALUE_ZWAVE_LOCKS,
            self::VALUE_ENTERPRISE_NOTICES,
            self::VALUE_ZWAVE_ENERGY,
            self::VALUE_REMINDERS,
            self::VALUE_SEVERE_WEATHER_ALERTS,
            self::VALUE_IMAGE_SENSOR_ALARMS,
            self::VALUE_IMAGE_SENSOR_PLUS,
            self::VALUE_IMAGE_SENSOR_EXTRA_UPLOADS,
            self::VALUE_ENTERPRISE_SECURITY_CONSOLE,
            self::VALUE_SMART_ENERGY_PLUS,
            self::VALUE_SECURUS,
            self::VALUE_LUTRON_REMOTE_ACCESS,
            self::VALUE_OBSOLETE_LUTRON_LIGHTS_AND_THERMOSTATS,
            self::VALUE_IDPROTECTION,
            self::VALUE_GREEN_BUTTON,
            self::VALUE_GARAGE_DOORS,
            self::VALUE_WELLNESS,
            self::VALUE_ADVANCED_ENERGY,
            self::VALUE_ADVANCED_AUTOMATION,
            self::VALUE_LUTRON_INTEGRATION,
            self::VALUE_LIFT_MASTER_INTEGRATION,
            self::VALUE_SCHNEIDER_INTEGRATION,
            self::VALUE_VIDEO_24_X_7_PER_SVR,
            self::VALUE_TAGG_INTEGRATION,
            self::VALUE_WATER_MANAGEMENT,
            self::VALUE_COMMERCIAL_ACTIVITY_REPORTS,
            self::VALUE_BE_CLOSE_COMMUNITY_VIEW,
            self::VALUE_ULCOMMERICIAL,
            self::VALUE_SOLAR_MONITORING,
            self::VALUE_SOLAR_EDGE_INTEGRATION,
            self::VALUE_ENPHASE_INTEGRATION,
            self::VALUE_NESTINTEGRATION,
            self::VALUE_SMSALARMS,
            self::VALUE_SMSNOTIFICATIONS_MEXICO,
            self::VALUE_ENTERPRISE_ENERGY,
            self::VALUE_ENTERPRISE_WELLNESS,
            self::VALUE_IRRIGATION_CONTROL,
            self::VALUE_RACHIO_INTEGRATION,
            self::VALUE_CONNECTED_CAR,
            self::VALUE_PROPANE_MONITORING,
            self::VALUE_SMSNOTIFICATIONS_CHILE,
            self::VALUE_SMSNOTIFICATIONS_COLOMBIA,
            self::VALUE_SMSNOTIFICATIONS_NZ,
            self::VALUE_SMSNOTIFICATIONS_AUSTRALIA,
            self::VALUE_SMSNOTIFICATIONS_BRAZIL,
            self::VALUE_SMSNOTIFICATIONS_PANAMA,
            self::VALUE_COSA_INTEGRATION,
            self::VALUE_OSNAPP_INTEGRATION,
            self::VALUE_CONNECTED_CAR_PLUS,
            self::VALUE_DOORBELL_CAMERAS,
            self::VALUE_UNEXPECTED_ACTIVITY_ALERTS,
            self::VALUE_ACCESS_CONTROL,
            self::VALUE_FIRE_FIGHTER,
            self::VALUE_HOURLY_SUPERVISION,
            self::VALUE_SIX_HOUR_SUPERVISION,
            self::VALUE_BASIC_DOORBELL,
            self::VALUE_ALARM_VISUAL_VERIFICATION,
            self::VALUE_PANIC_BUTTON,
            self::VALUE_AUDIO_INTEGRATION,
            self::VALUE_KONA_LABS_WATER_METERING,
            self::VALUE_VIDEO_DEVICE_AUDIO,
            self::VALUE_CANCEL_VERIFY,
            self::VALUE_SMSNOTIFICATIONS_BELGIUM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
