<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLong ArrayType
 * @subpackage Arrays
 */
class ArrayOfLong extends AbstractStructArrayBase
{
    /**
     * The long
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $long;
    /**
     * Constructor method for ArrayOfLong
     * @uses ArrayOfLong::setLong()
     * @param int[] $long
     */
    public function __construct(array $long = array())
    {
        $this
            ->setLong($long);
    }
    /**
     * Get long value
     * @return int[]|null
     */
    public function getLong()
    {
        return $this->long;
    }
    /**
     * Set long value
     * @throws \InvalidArgumentException
     * @param int[] $long
     * @return \CustomerManagement\ArrayType\ArrayOfLong
     */
    public function setLong(array $long = array())
    {
        foreach ($long as $arrayOfLongLongItem) {
            // validation for constraint: itemType
            if (!is_numeric($arrayOfLongLongItem)) {
                throw new \InvalidArgumentException(sprintf('The long property can only contain items of long, "%s" given', is_object($arrayOfLongLongItem) ? get_class($arrayOfLongLongItem) : gettype($arrayOfLongLongItem)), __LINE__);
            }
        }
        $this->long = $long;
        return $this;
    }
    /**
     * Add item to long value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \CustomerManagement\ArrayType\ArrayOfLong
     */
    public function addToLong($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The long property can only contain items of long, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->long[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return int|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return int|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return int|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return int|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return int|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string long
     */
    public function getAttributeName()
    {
        return 'long';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\ArrayType\ArrayOfLong
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
