<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateDealerCustomerSourceInput StructType
 * @subpackage Structs
 */
class UpdateDealerCustomerSourceInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The DealerCustomerSourceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DealerCustomerSourceId;
    /**
     * The BuilderProgramId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $BuilderProgramId;
    /**
     * The DealerCustomerSourceOther
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DealerCustomerSourceOther;
    /**
     * Constructor method for UpdateDealerCustomerSourceInput
     * @uses UpdateDealerCustomerSourceInput::setCustomerId()
     * @uses UpdateDealerCustomerSourceInput::setDealerCustomerSourceId()
     * @uses UpdateDealerCustomerSourceInput::setBuilderProgramId()
     * @uses UpdateDealerCustomerSourceInput::setDealerCustomerSourceOther()
     * @param int $customerId
     * @param int $dealerCustomerSourceId
     * @param int $builderProgramId
     * @param string $dealerCustomerSourceOther
     */
    public function __construct($customerId = null, $dealerCustomerSourceId = null, $builderProgramId = null, $dealerCustomerSourceOther = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setDealerCustomerSourceId($dealerCustomerSourceId)
            ->setBuilderProgramId($builderProgramId)
            ->setDealerCustomerSourceOther($dealerCustomerSourceOther);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateDealerCustomerSourceInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get DealerCustomerSourceId value
     * @return int
     */
    public function getDealerCustomerSourceId()
    {
        return $this->DealerCustomerSourceId;
    }
    /**
     * Set DealerCustomerSourceId value
     * @param int $dealerCustomerSourceId
     * @return \CustomerManagement\StructType\UpdateDealerCustomerSourceInput
     */
    public function setDealerCustomerSourceId($dealerCustomerSourceId = null)
    {
        // validation for constraint: int
        if (!is_null($dealerCustomerSourceId) && !(is_int($dealerCustomerSourceId) || ctype_digit($dealerCustomerSourceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dealerCustomerSourceId, true), gettype($dealerCustomerSourceId)), __LINE__);
        }
        $this->DealerCustomerSourceId = $dealerCustomerSourceId;
        return $this;
    }
    /**
     * Get BuilderProgramId value
     * @return int
     */
    public function getBuilderProgramId()
    {
        return $this->BuilderProgramId;
    }
    /**
     * Set BuilderProgramId value
     * @param int $builderProgramId
     * @return \CustomerManagement\StructType\UpdateDealerCustomerSourceInput
     */
    public function setBuilderProgramId($builderProgramId = null)
    {
        // validation for constraint: int
        if (!is_null($builderProgramId) && !(is_int($builderProgramId) || ctype_digit($builderProgramId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($builderProgramId, true), gettype($builderProgramId)), __LINE__);
        }
        $this->BuilderProgramId = $builderProgramId;
        return $this;
    }
    /**
     * Get DealerCustomerSourceOther value
     * @return string|null
     */
    public function getDealerCustomerSourceOther()
    {
        return $this->DealerCustomerSourceOther;
    }
    /**
     * Set DealerCustomerSourceOther value
     * @param string $dealerCustomerSourceOther
     * @return \CustomerManagement\StructType\UpdateDealerCustomerSourceInput
     */
    public function setDealerCustomerSourceOther($dealerCustomerSourceOther = null)
    {
        // validation for constraint: string
        if (!is_null($dealerCustomerSourceOther) && !is_string($dealerCustomerSourceOther)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dealerCustomerSourceOther, true), gettype($dealerCustomerSourceOther)), __LINE__);
        }
        $this->DealerCustomerSourceOther = $dealerCustomerSourceOther;
        return $this;
    }
}
