<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NewArmingSchedule StructType
 * @subpackage Structs
 */
class NewArmingSchedule extends AbstractStructBase
{
    /**
     * The ScheduleDay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ScheduleDay;
    /**
     * The FirstArmingState
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FirstArmingState;
    /**
     * The SecondArmingState
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $SecondArmingState;
    /**
     * The StartMinutes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StartMinutes;
    /**
     * The EndMinutes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $EndMinutes;
    /**
     * The Partition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Partition;
    /**
     * Constructor method for NewArmingSchedule
     * @uses NewArmingSchedule::setScheduleDay()
     * @uses NewArmingSchedule::setFirstArmingState()
     * @uses NewArmingSchedule::setSecondArmingState()
     * @uses NewArmingSchedule::setStartMinutes()
     * @uses NewArmingSchedule::setEndMinutes()
     * @uses NewArmingSchedule::setPartition()
     * @param string $scheduleDay
     * @param string $firstArmingState
     * @param string $secondArmingState
     * @param int $startMinutes
     * @param int $endMinutes
     * @param int $partition
     */
    public function __construct($scheduleDay = null, $firstArmingState = null, $secondArmingState = null, $startMinutes = null, $endMinutes = null, $partition = null)
    {
        $this
            ->setScheduleDay($scheduleDay)
            ->setFirstArmingState($firstArmingState)
            ->setSecondArmingState($secondArmingState)
            ->setStartMinutes($startMinutes)
            ->setEndMinutes($endMinutes)
            ->setPartition($partition);
    }
    /**
     * Get ScheduleDay value
     * @return string
     */
    public function getScheduleDay()
    {
        return $this->ScheduleDay;
    }
    /**
     * Set ScheduleDay value
     * @uses \CustomerManagement\EnumType\ScheduleDayEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\ScheduleDayEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scheduleDay
     * @return \CustomerManagement\StructType\NewArmingSchedule
     */
    public function setScheduleDay($scheduleDay = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\ScheduleDayEnum::valueIsValid($scheduleDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\ScheduleDayEnum', is_array($scheduleDay) ? implode(', ', $scheduleDay) : var_export($scheduleDay, true), implode(', ', \CustomerManagement\EnumType\ScheduleDayEnum::getValidValues())), __LINE__);
        }
        $this->ScheduleDay = $scheduleDay;
        return $this;
    }
    /**
     * Get FirstArmingState value
     * @return string
     */
    public function getFirstArmingState()
    {
        return $this->FirstArmingState;
    }
    /**
     * Set FirstArmingState value
     * @uses \CustomerManagement\EnumType\ArmingStateActionEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\ArmingStateActionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $firstArmingState
     * @return \CustomerManagement\StructType\NewArmingSchedule
     */
    public function setFirstArmingState($firstArmingState = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\ArmingStateActionEnum::valueIsValid($firstArmingState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\ArmingStateActionEnum', is_array($firstArmingState) ? implode(', ', $firstArmingState) : var_export($firstArmingState, true), implode(', ', \CustomerManagement\EnumType\ArmingStateActionEnum::getValidValues())), __LINE__);
        }
        $this->FirstArmingState = $firstArmingState;
        return $this;
    }
    /**
     * Get SecondArmingState value
     * @return string
     */
    public function getSecondArmingState()
    {
        return $this->SecondArmingState;
    }
    /**
     * Set SecondArmingState value
     * @uses \CustomerManagement\EnumType\ArmingStateActionEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\ArmingStateActionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $secondArmingState
     * @return \CustomerManagement\StructType\NewArmingSchedule
     */
    public function setSecondArmingState($secondArmingState = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\ArmingStateActionEnum::valueIsValid($secondArmingState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\ArmingStateActionEnum', is_array($secondArmingState) ? implode(', ', $secondArmingState) : var_export($secondArmingState, true), implode(', ', \CustomerManagement\EnumType\ArmingStateActionEnum::getValidValues())), __LINE__);
        }
        $this->SecondArmingState = $secondArmingState;
        return $this;
    }
    /**
     * Get StartMinutes value
     * @return int
     */
    public function getStartMinutes()
    {
        return $this->StartMinutes;
    }
    /**
     * Set StartMinutes value
     * @param int $startMinutes
     * @return \CustomerManagement\StructType\NewArmingSchedule
     */
    public function setStartMinutes($startMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($startMinutes) && !(is_int($startMinutes) || ctype_digit($startMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($startMinutes, true), gettype($startMinutes)), __LINE__);
        }
        $this->StartMinutes = $startMinutes;
        return $this;
    }
    /**
     * Get EndMinutes value
     * @return int
     */
    public function getEndMinutes()
    {
        return $this->EndMinutes;
    }
    /**
     * Set EndMinutes value
     * @param int $endMinutes
     * @return \CustomerManagement\StructType\NewArmingSchedule
     */
    public function setEndMinutes($endMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($endMinutes) && !(is_int($endMinutes) || ctype_digit($endMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($endMinutes, true), gettype($endMinutes)), __LINE__);
        }
        $this->EndMinutes = $endMinutes;
        return $this;
    }
    /**
     * Get Partition value
     * @return int
     */
    public function getPartition()
    {
        return $this->Partition;
    }
    /**
     * Set Partition value
     * @param int $partition
     * @return \CustomerManagement\StructType\NewArmingSchedule
     */
    public function setPartition($partition = null)
    {
        // validation for constraint: int
        if (!is_null($partition) && !(is_int($partition) || ctype_digit($partition))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($partition, true), gettype($partition)), __LINE__);
        }
        $this->Partition = $partition;
        return $this;
    }
}
