<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCustomerAddressInput StructType
 * @subpackage Structs
 */
class UpdateCustomerAddressInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The UseGivenAddressForBoth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $UseGivenAddressForBoth;
    /**
     * The InstallAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\Address
     */
    public $InstallAddress;
    /**
     * The CustomerAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\StructType\Address
     */
    public $CustomerAddress;
    /**
     * Constructor method for UpdateCustomerAddressInput
     * @uses UpdateCustomerAddressInput::setCustomerId()
     * @uses UpdateCustomerAddressInput::setUseGivenAddressForBoth()
     * @uses UpdateCustomerAddressInput::setInstallAddress()
     * @uses UpdateCustomerAddressInput::setCustomerAddress()
     * @param int $customerId
     * @param bool $useGivenAddressForBoth
     * @param \CustomerManagement\StructType\Address $installAddress
     * @param \CustomerManagement\StructType\Address $customerAddress
     */
    public function __construct($customerId = null, $useGivenAddressForBoth = null, \CustomerManagement\StructType\Address $installAddress = null, \CustomerManagement\StructType\Address $customerAddress = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setUseGivenAddressForBoth($useGivenAddressForBoth)
            ->setInstallAddress($installAddress)
            ->setCustomerAddress($customerAddress);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateCustomerAddressInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get UseGivenAddressForBoth value
     * @return bool
     */
    public function getUseGivenAddressForBoth()
    {
        return $this->UseGivenAddressForBoth;
    }
    /**
     * Set UseGivenAddressForBoth value
     * @param bool $useGivenAddressForBoth
     * @return \CustomerManagement\StructType\UpdateCustomerAddressInput
     */
    public function setUseGivenAddressForBoth($useGivenAddressForBoth = null)
    {
        // validation for constraint: boolean
        if (!is_null($useGivenAddressForBoth) && !is_bool($useGivenAddressForBoth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($useGivenAddressForBoth)), __LINE__);
        }
        $this->UseGivenAddressForBoth = $useGivenAddressForBoth;
        return $this;
    }
    /**
     * Get InstallAddress value
     * @return \CustomerManagement\StructType\Address|null
     */
    public function getInstallAddress()
    {
        return $this->InstallAddress;
    }
    /**
     * Set InstallAddress value
     * @param \CustomerManagement\StructType\Address $installAddress
     * @return \CustomerManagement\StructType\UpdateCustomerAddressInput
     */
    public function setInstallAddress(\CustomerManagement\StructType\Address $installAddress = null)
    {
        $this->InstallAddress = $installAddress;
        return $this;
    }
    /**
     * Get CustomerAddress value
     * @return \CustomerManagement\StructType\Address|null
     */
    public function getCustomerAddress()
    {
        return $this->CustomerAddress;
    }
    /**
     * Set CustomerAddress value
     * @param \CustomerManagement\StructType\Address $customerAddress
     * @return \CustomerManagement\StructType\UpdateCustomerAddressInput
     */
    public function setCustomerAddress(\CustomerManagement\StructType\Address $customerAddress = null)
    {
        $this->CustomerAddress = $customerAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\UpdateCustomerAddressInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
