<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvailableEnterpriseGroupsResults StructType
 * @subpackage Structs
 */
class AvailableEnterpriseGroupsResults extends AbstractStructBase
{
    /**
     * The GroupID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GroupID;
    /**
     * The GroupName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GroupName;
    /**
     * Constructor method for AvailableEnterpriseGroupsResults
     * @uses AvailableEnterpriseGroupsResults::setGroupID()
     * @uses AvailableEnterpriseGroupsResults::setGroupName()
     * @param int $groupID
     * @param string $groupName
     */
    public function __construct($groupID = null, $groupName = null)
    {
        $this
            ->setGroupID($groupID)
            ->setGroupName($groupName);
    }
    /**
     * Get GroupID value
     * @return int
     */
    public function getGroupID()
    {
        return $this->GroupID;
    }
    /**
     * Set GroupID value
     * @param int $groupID
     * @return \CustomerManagement\StructType\AvailableEnterpriseGroupsResults
     */
    public function setGroupID($groupID = null)
    {
        // validation for constraint: int
        if (!is_null($groupID) && !(is_int($groupID) || ctype_digit($groupID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($groupID, true), gettype($groupID)), __LINE__);
        }
        $this->GroupID = $groupID;
        return $this;
    }
    /**
     * Get GroupName value
     * @return string|null
     */
    public function getGroupName()
    {
        return $this->GroupName;
    }
    /**
     * Set GroupName value
     * @param string $groupName
     * @return \CustomerManagement\StructType\AvailableEnterpriseGroupsResults
     */
    public function setGroupName($groupName = null)
    {
        // validation for constraint: string
        if (!is_null($groupName) && !is_string($groupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupName, true), gettype($groupName)), __LINE__);
        }
        $this->GroupName = $groupName;
        return $this;
    }
}
