<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TenantTurnoverOutput StructType
 * @subpackage Structs
 */
class TenantTurnoverOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The RecycleDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RecycleDate;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The NewCustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NewCustomerId;
    /**
     * The RecycledCustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RecycledCustomerId;
    /**
     * Constructor method for TenantTurnoverOutput
     * @uses TenantTurnoverOutput::setSuccess()
     * @uses TenantTurnoverOutput::setRecycleDate()
     * @uses TenantTurnoverOutput::setErrorMessage()
     * @uses TenantTurnoverOutput::setNewCustomerId()
     * @uses TenantTurnoverOutput::setRecycledCustomerId()
     * @param bool $success
     * @param string $recycleDate
     * @param string $errorMessage
     * @param string $newCustomerId
     * @param string $recycledCustomerId
     */
    public function __construct($success = null, $recycleDate = null, $errorMessage = null, $newCustomerId = null, $recycledCustomerId = null)
    {
        $this
            ->setSuccess($success)
            ->setRecycleDate($recycleDate)
            ->setErrorMessage($errorMessage)
            ->setNewCustomerId($newCustomerId)
            ->setRecycledCustomerId($recycledCustomerId);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\TenantTurnoverOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get RecycleDate value
     * @return string
     */
    public function getRecycleDate()
    {
        return $this->RecycleDate;
    }
    /**
     * Set RecycleDate value
     * @param string $recycleDate
     * @return \CustomerManagement\StructType\TenantTurnoverOutput
     */
    public function setRecycleDate($recycleDate = null)
    {
        // validation for constraint: string
        if (!is_null($recycleDate) && !is_string($recycleDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recycleDate, true), gettype($recycleDate)), __LINE__);
        }
        $this->RecycleDate = $recycleDate;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\TenantTurnoverOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get NewCustomerId value
     * @return string|null
     */
    public function getNewCustomerId()
    {
        return $this->NewCustomerId;
    }
    /**
     * Set NewCustomerId value
     * @param string $newCustomerId
     * @return \CustomerManagement\StructType\TenantTurnoverOutput
     */
    public function setNewCustomerId($newCustomerId = null)
    {
        // validation for constraint: string
        if (!is_null($newCustomerId) && !is_string($newCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newCustomerId, true), gettype($newCustomerId)), __LINE__);
        }
        $this->NewCustomerId = $newCustomerId;
        return $this;
    }
    /**
     * Get RecycledCustomerId value
     * @return string|null
     */
    public function getRecycledCustomerId()
    {
        return $this->RecycledCustomerId;
    }
    /**
     * Set RecycledCustomerId value
     * @param string $recycledCustomerId
     * @return \CustomerManagement\StructType\TenantTurnoverOutput
     */
    public function setRecycledCustomerId($recycledCustomerId = null)
    {
        // validation for constraint: string
        if (!is_null($recycledCustomerId) && !is_string($recycledCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recycledCustomerId, true), gettype($recycledCustomerId)), __LINE__);
        }
        $this->RecycledCustomerId = $recycledCustomerId;
        return $this;
    }
}
