<?php

namespace CustomerManagement\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for AddOnFeatureEnum EnumType
 * @subpackage Enumerations
 */
class AddOnFeatureEnum extends AbstractStructEnumBase
{
    /**
     * Constant for value 'VoiceNotificationsForAlarms'
     * @return string 'VoiceNotificationsForAlarms'
     */
    const VALUE_VOICE_NOTIFICATIONS_FOR_ALARMS = 'VoiceNotificationsForAlarms';
    /**
     * Constant for value 'VoiceNotificationsForMonitoring'
     * @return string 'VoiceNotificationsForMonitoring'
     */
    const VALUE_VOICE_NOTIFICATIONS_FOR_MONITORING = 'VoiceNotificationsForMonitoring';
    /**
     * Constant for value 'LightAutomation'
     * @return string 'LightAutomation'
     */
    const VALUE_LIGHT_AUTOMATION = 'LightAutomation';
    /**
     * Constant for value 'UserCodeControl'
     * @return string 'UserCodeControl'
     */
    const VALUE_USER_CODE_CONTROL = 'UserCodeControl';
    /**
     * Constant for value 'RemoteArming'
     * @return string 'RemoteArming'
     */
    const VALUE_REMOTE_ARMING = 'RemoteArming';
    /**
     * Constant for value 'ThermostatControl'
     * @return string 'ThermostatControl'
     */
    const VALUE_THERMOSTAT_CONTROL = 'ThermostatControl';
    /**
     * Constant for value 'ArmingSupervision'
     * @return string 'ArmingSupervision'
     */
    const VALUE_ARMING_SUPERVISION = 'ArmingSupervision';
    /**
     * Constant for value 'NormalActivityReports'
     * @return string 'NormalActivityReports'
     */
    const VALUE_NORMAL_ACTIVITY_REPORTS = 'NormalActivityReports';
    /**
     * Constant for value 'ArmingReports'
     * @return string 'ArmingReports'
     */
    const VALUE_ARMING_REPORTS = 'ArmingReports';
    /**
     * Constant for value 'ArmingSchedules'
     * @return string 'ArmingSchedules'
     */
    const VALUE_ARMING_SCHEDULES = 'ArmingSchedules';
    /**
     * Constant for value 'Inactivity'
     * @return string 'Inactivity'
     */
    const VALUE_INACTIVITY = 'Inactivity';
    /**
     * Constant for value 'FiveNormalActivitySensors'
     * @return string 'FiveNormalActivitySensors'
     */
    const VALUE_FIVE_NORMAL_ACTIVITY_SENSORS = 'FiveNormalActivitySensors';
    /**
     * Constant for value 'ProVideo'
     * @return string 'ProVideo'
     */
    const VALUE_PRO_VIDEO = 'ProVideo';
    /**
     * Constant for value 'ProVideoPlus'
     * @return string 'ProVideoPlus'
     */
    const VALUE_PRO_VIDEO_PLUS = 'ProVideoPlus';
    /**
     * Constant for value 'TwoFiftyMBExtraVideoStorage'
     * @return string 'TwoFiftyMBExtraVideoStorage'
     */
    const VALUE_TWO_FIFTY_MBEXTRA_VIDEO_STORAGE = 'TwoFiftyMBExtraVideoStorage';
    /**
     * Constant for value 'TwoWayVoice'
     * @return string 'TwoWayVoice'
     */
    const VALUE_TWO_WAY_VOICE = 'TwoWayVoice';
    /**
     * Constant for value 'WeatherToPanel'
     * @return string 'WeatherToPanel'
     */
    const VALUE_WEATHER_TO_PANEL = 'WeatherToPanel';
    /**
     * Constant for value 'DigitalInputVideos'
     * @return string 'DigitalInputVideos'
     */
    const VALUE_DIGITAL_INPUT_VIDEOS = 'DigitalInputVideos';
    /**
     * Constant for value 'MedicationAlerts'
     * @return string 'MedicationAlerts'
     */
    const VALUE_MEDICATION_ALERTS = 'MedicationAlerts';
    /**
     * Constant for value 'ZWaveLights'
     * @return string 'ZWaveLights'
     */
    const VALUE_ZWAVE_LIGHTS = 'ZWaveLights';
    /**
     * Constant for value 'ZWaveThermostats'
     * @return string 'ZWaveThermostats'
     */
    const VALUE_ZWAVE_THERMOSTATS = 'ZWaveThermostats';
    /**
     * Constant for value 'ZWaveLocks'
     * @return string 'ZWaveLocks'
     */
    const VALUE_ZWAVE_LOCKS = 'ZWaveLocks';
    /**
     * Constant for value 'EnterpriseNotices'
     * @return string 'EnterpriseNotices'
     */
    const VALUE_ENTERPRISE_NOTICES = 'EnterpriseNotices';
    /**
     * Constant for value 'ZWaveEnergy'
     * @return string 'ZWaveEnergy'
     */
    const VALUE_ZWAVE_ENERGY = 'ZWaveEnergy';
    /**
     * Constant for value 'Reminders'
     * @return string 'Reminders'
     */
    const VALUE_REMINDERS = 'Reminders';
    /**
     * Constant for value 'SevereWeatherAlerts'
     * @return string 'SevereWeatherAlerts'
     */
    const VALUE_SEVERE_WEATHER_ALERTS = 'SevereWeatherAlerts';
    /**
     * Constant for value 'ImageSensorAlarms'
     * @return string 'ImageSensorAlarms'
     */
    const VALUE_IMAGE_SENSOR_ALARMS = 'ImageSensorAlarms';
    /**
     * Constant for value 'ImageSensorPlus'
     * @return string 'ImageSensorPlus'
     */
    const VALUE_IMAGE_SENSOR_PLUS = 'ImageSensorPlus';
    /**
     * Constant for value 'ImageSensorExtraUploads'
     * @return string 'ImageSensorExtraUploads'
     */
    const VALUE_IMAGE_SENSOR_EXTRA_UPLOADS = 'ImageSensorExtraUploads';
    /**
     * Constant for value 'EnterpriseSecurityConsole'
     * @return string 'EnterpriseSecurityConsole'
     */
    const VALUE_ENTERPRISE_SECURITY_CONSOLE = 'EnterpriseSecurityConsole';
    /**
     * Constant for value 'SmartEnergyPlus'
     * @return string 'SmartEnergyPlus'
     */
    const VALUE_SMART_ENERGY_PLUS = 'SmartEnergyPlus';
    /**
     * Constant for value 'Securus'
     * @return string 'Securus'
     */
    const VALUE_SECURUS = 'Securus';
    /**
     * Constant for value 'LutronRemoteAccess'
     * @return string 'LutronRemoteAccess'
     */
    const VALUE_LUTRON_REMOTE_ACCESS = 'LutronRemoteAccess';
    /**
     * Constant for value 'Obsolete_LutronLightsAndThermostats'
     * @return string 'Obsolete_LutronLightsAndThermostats'
     */
    const VALUE_OBSOLETE_LUTRON_LIGHTS_AND_THERMOSTATS = 'Obsolete_LutronLightsAndThermostats';
    /**
     * Constant for value 'IDProtection'
     * @return string 'IDProtection'
     */
    const VALUE_IDPROTECTION = 'IDProtection';
    /**
     * Constant for value 'GreenButton'
     * @return string 'GreenButton'
     */
    const VALUE_GREEN_BUTTON = 'GreenButton';
    /**
     * Constant for value 'GarageDoors'
     * @return string 'GarageDoors'
     */
    const VALUE_GARAGE_DOORS = 'GarageDoors';
    /**
     * Constant for value 'Wellness'
     * @return string 'Wellness'
     */
    const VALUE_WELLNESS = 'Wellness';
    /**
     * Constant for value 'AdvancedEnergy'
     * @return string 'AdvancedEnergy'
     */
    const VALUE_ADVANCED_ENERGY = 'AdvancedEnergy';
    /**
     * Constant for value 'AdvancedAutomation'
     * @return string 'AdvancedAutomation'
     */
    const VALUE_ADVANCED_AUTOMATION = 'AdvancedAutomation';
    /**
     * Constant for value 'LutronIntegration'
     * @return string 'LutronIntegration'
     */
    const VALUE_LUTRON_INTEGRATION = 'LutronIntegration';
    /**
     * Constant for value 'LiftMasterIntegration'
     * @return string 'LiftMasterIntegration'
     */
    const VALUE_LIFT_MASTER_INTEGRATION = 'LiftMasterIntegration';
    /**
     * Constant for value 'SchneiderIntegration'
     * @return string 'SchneiderIntegration'
     */
    const VALUE_SCHNEIDER_INTEGRATION = 'SchneiderIntegration';
    /**
     * Constant for value 'Video24x7PerSVR'
     * @return string 'Video24x7PerSVR'
     */
    const VALUE_VIDEO_24_X_7_PER_SVR = 'Video24x7PerSVR';
    /**
     * Constant for value 'TaggIntegration'
     * @return string 'TaggIntegration'
     */
    const VALUE_TAGG_INTEGRATION = 'TaggIntegration';
    /**
     * Constant for value 'WaterManagement'
     * @return string 'WaterManagement'
     */
    const VALUE_WATER_MANAGEMENT = 'WaterManagement';
    /**
     * Constant for value 'CommercialActivityReports'
     * @return string 'CommercialActivityReports'
     */
    const VALUE_COMMERCIAL_ACTIVITY_REPORTS = 'CommercialActivityReports';
    /**
     * Constant for value 'BeCloseCommunityView'
     * @return string 'BeCloseCommunityView'
     */
    const VALUE_BE_CLOSE_COMMUNITY_VIEW = 'BeCloseCommunityView';
    /**
     * Constant for value 'ULCommericial'
     * @return string 'ULCommericial'
     */
    const VALUE_ULCOMMERICIAL = 'ULCommericial';
    /**
     * Constant for value 'SolarMonitoring'
     * @return string 'SolarMonitoring'
     */
    const VALUE_SOLAR_MONITORING = 'SolarMonitoring';
    /**
     * Constant for value 'SolarEdgeIntegration'
     * @return string 'SolarEdgeIntegration'
     */
    const VALUE_SOLAR_EDGE_INTEGRATION = 'SolarEdgeIntegration';
    /**
     * Constant for value 'EnphaseIntegration'
     * @return string 'EnphaseIntegration'
     */
    const VALUE_ENPHASE_INTEGRATION = 'EnphaseIntegration';
    /**
     * Constant for value 'NESTIntegration'
     * @return string 'NESTIntegration'
     */
    const VALUE_NESTINTEGRATION = 'NESTIntegration';
    /**
     * Constant for value 'SMSAlarms'
     * @return string 'SMSAlarms'
     */
    const VALUE_SMSALARMS = 'SMSAlarms';
    /**
     * Constant for value 'SMSNotificationsMexico'
     * @return string 'SMSNotificationsMexico'
     */
    const VALUE_SMSNOTIFICATIONS_MEXICO = 'SMSNotificationsMexico';
    /**
     * Constant for value 'EnterpriseEnergy'
     * @return string 'EnterpriseEnergy'
     */
    const VALUE_ENTERPRISE_ENERGY = 'EnterpriseEnergy';
    /**
     * Constant for value 'EnterpriseWellness'
     * @return string 'EnterpriseWellness'
     */
    const VALUE_ENTERPRISE_WELLNESS = 'EnterpriseWellness';
    /**
     * Constant for value 'IrrigationControl'
     * @return string 'IrrigationControl'
     */
    const VALUE_IRRIGATION_CONTROL = 'IrrigationControl';
    /**
     * Constant for value 'RachioIntegration'
     * @return string 'RachioIntegration'
     */
    const VALUE_RACHIO_INTEGRATION = 'RachioIntegration';
    /**
     * Constant for value 'ConnectedCar'
     * @return string 'ConnectedCar'
     */
    const VALUE_CONNECTED_CAR = 'ConnectedCar';
    /**
     * Constant for value 'PropaneMonitoring'
     * @return string 'PropaneMonitoring'
     */
    const VALUE_PROPANE_MONITORING = 'PropaneMonitoring';
    /**
     * Constant for value 'SMSNotificationsChile'
     * @return string 'SMSNotificationsChile'
     */
    const VALUE_SMSNOTIFICATIONS_CHILE = 'SMSNotificationsChile';
    /**
     * Constant for value 'SMSNotificationsColombia'
     * @return string 'SMSNotificationsColombia'
     */
    const VALUE_SMSNOTIFICATIONS_COLOMBIA = 'SMSNotificationsColombia';
    /**
     * Constant for value 'SMSNotificationsNZ'
     * @return string 'SMSNotificationsNZ'
     */
    const VALUE_SMSNOTIFICATIONS_NZ = 'SMSNotificationsNZ';
    /**
     * Constant for value 'SMSNotificationsAustralia'
     * @return string 'SMSNotificationsAustralia'
     */
    const VALUE_SMSNOTIFICATIONS_AUSTRALIA = 'SMSNotificationsAustralia';
    /**
     * Constant for value 'SMSNotificationsBrazil'
     * @return string 'SMSNotificationsBrazil'
     */
    const VALUE_SMSNOTIFICATIONS_BRAZIL = 'SMSNotificationsBrazil';
    /**
     * Constant for value 'SMSNotificationsPanama'
     * @return string 'SMSNotificationsPanama'
     */
    const VALUE_SMSNOTIFICATIONS_PANAMA = 'SMSNotificationsPanama';
    /**
     * Constant for value 'CosaIntegration'
     * @return string 'CosaIntegration'
     */
    const VALUE_COSA_INTEGRATION = 'CosaIntegration';
    /**
     * Constant for value 'OSnappIntegration'
     * @return string 'OSnappIntegration'
     */
    const VALUE_OSNAPP_INTEGRATION = 'OSnappIntegration';
    /**
     * Constant for value 'ConnectedCarPlus'
     * @return string 'ConnectedCarPlus'
     */
    const VALUE_CONNECTED_CAR_PLUS = 'ConnectedCarPlus';
    /**
     * Constant for value 'DoorbellCameras'
     * @return string 'DoorbellCameras'
     */
    const VALUE_DOORBELL_CAMERAS = 'DoorbellCameras';
    /**
     * Constant for value 'UnexpectedActivityAlerts'
     * @return string 'UnexpectedActivityAlerts'
     */
    const VALUE_UNEXPECTED_ACTIVITY_ALERTS = 'UnexpectedActivityAlerts';
    /**
     * Constant for value 'AccessControl'
     * @return string 'AccessControl'
     */
    const VALUE_ACCESS_CONTROL = 'AccessControl';
    /**
     * Constant for value 'ZWaveCO'
     * @return string 'ZWaveCO'
     */
    const VALUE_ZWAVE_CO = 'ZWaveCO';
    /**
     * Constant for value 'HourlySupervision'
     * @return string 'HourlySupervision'
     */
    const VALUE_HOURLY_SUPERVISION = 'HourlySupervision';
    /**
     * Constant for value 'SixHourSupervision'
     * @return string 'SixHourSupervision'
     */
    const VALUE_SIX_HOUR_SUPERVISION = 'SixHourSupervision';
    /**
     * Constant for value 'BasicDoorbell'
     * @return string 'BasicDoorbell'
     */
    const VALUE_BASIC_DOORBELL = 'BasicDoorbell';
    /**
     * Constant for value 'AlarmVisualVerification'
     * @return string 'AlarmVisualVerification'
     */
    const VALUE_ALARM_VISUAL_VERIFICATION = 'AlarmVisualVerification';
    /**
     * Constant for value 'PanicButton'
     * @return string 'PanicButton'
     */
    const VALUE_PANIC_BUTTON = 'PanicButton';
    /**
     * Constant for value 'AudioIntegration'
     * @return string 'AudioIntegration'
     */
    const VALUE_AUDIO_INTEGRATION = 'AudioIntegration';
    /**
     * Constant for value 'KonaLabsWaterMetering'
     * @return string 'KonaLabsWaterMetering'
     */
    const VALUE_KONA_LABS_WATER_METERING = 'KonaLabsWaterMetering';
    /**
     * Constant for value 'VideoDeviceAudio'
     * @return string 'VideoDeviceAudio'
     */
    const VALUE_VIDEO_DEVICE_AUDIO = 'VideoDeviceAudio';
    /**
     * Constant for value 'CancelVerify'
     * @return string 'CancelVerify'
     */
    const VALUE_CANCEL_VERIFY = 'CancelVerify';
    /**
     * Constant for value 'SMSNotificationsBelgium'
     * @return string 'SMSNotificationsBelgium'
     */
    const VALUE_SMSNOTIFICATIONS_BELGIUM = 'SMSNotificationsBelgium';
    /**
     * Constant for value 'AccessControlDoors'
     * @return string 'AccessControlDoors'
     */
    const VALUE_ACCESS_CONTROL_DOORS = 'AccessControlDoors';
    /**
     * Constant for value 'RouterLimits'
     * @return string 'RouterLimits'
     */
    const VALUE_ROUTER_LIMITS = 'RouterLimits';
    /**
     * Constant for value 'HomeControllerIntegration'
     * @return string 'HomeControllerIntegration'
     */
    const VALUE_HOME_CONTROLLER_INTEGRATION = 'HomeControllerIntegration';
    /**
     * Constant for value 'FlexIO'
     * @return string 'FlexIO'
     */
    const VALUE_FLEX_IO = 'FlexIO';
    /**
     * Constant for value 'SMSNotificationsSweden'
     * @return string 'SMSNotificationsSweden'
     */
    const VALUE_SMSNOTIFICATIONS_SWEDEN = 'SMSNotificationsSweden';
    /**
     * Constant for value 'SMSNotificationsNetherlands'
     * @return string 'SMSNotificationsNetherlands'
     */
    const VALUE_SMSNOTIFICATIONS_NETHERLANDS = 'SMSNotificationsNetherlands';
    /**
     * Constant for value 'ProVideoWithAnalytics'
     * @return string 'ProVideoWithAnalytics'
     */
    const VALUE_PRO_VIDEO_WITH_ANALYTICS = 'ProVideoWithAnalytics';
    /**
     * Constant for value 'ConnectedCarCalAmp'
     * @return string 'ConnectedCarCalAmp'
     */
    const VALUE_CONNECTED_CAR_CAL_AMP = 'ConnectedCarCalAmp';
    /**
     * Constant for value 'SMSNotificationsNorway'
     * @return string 'SMSNotificationsNorway'
     */
    const VALUE_SMSNOTIFICATIONS_NORWAY = 'SMSNotificationsNorway';
    /**
     * Constant for value 'SMSNotificationsIreland'
     * @return string 'SMSNotificationsIreland'
     */
    const VALUE_SMSNOTIFICATIONS_IRELAND = 'SMSNotificationsIreland';
    /**
     * Constant for value 'CarrierCorIntegration'
     * @return string 'CarrierCorIntegration'
     */
    const VALUE_CARRIER_COR_INTEGRATION = 'CarrierCorIntegration';
    /**
     * Constant for value 'BuilderDoorbell'
     * @return string 'BuilderDoorbell'
     */
    const VALUE_BUILDER_DOORBELL = 'BuilderDoorbell';
    /**
     * Constant for value 'AccessPlanUserManagement'
     * @return string 'AccessPlanUserManagement'
     */
    const VALUE_ACCESS_PLAN_USER_MANAGEMENT = 'AccessPlanUserManagement';
    /**
     * Constant for value 'WaterManagementPlus'
     * @return string 'WaterManagementPlus'
     */
    const VALUE_WATER_MANAGEMENT_PLUS = 'WaterManagementPlus';
    /**
     * Constant for value 'SmarterBusinessTemperatureMonitoring'
     * @return string 'SmarterBusinessTemperatureMonitoring'
     */
    const VALUE_SMARTER_BUSINESS_TEMPERATURE_MONITORING = 'SmarterBusinessTemperatureMonitoring';
    /**
     * Constant for value 'CommercialVideo8'
     * @return string 'CommercialVideo8'
     */
    const VALUE_COMMERCIAL_VIDEO_8 = 'CommercialVideo8';
    /**
     * Constant for value 'CommercialVideo16'
     * @return string 'CommercialVideo16'
     */
    const VALUE_COMMERCIAL_VIDEO_16 = 'CommercialVideo16';
    /**
     * Constant for value 'CommercialVideo8Expansion'
     * @return string 'CommercialVideo8Expansion'
     */
    const VALUE_COMMERCIAL_VIDEO_8_EXPANSION = 'CommercialVideo8Expansion';
    /**
     * Constant for value 'CommercialVideo16Expansion'
     * @return string 'CommercialVideo16Expansion'
     */
    const VALUE_COMMERCIAL_VIDEO_16_EXPANSION = 'CommercialVideo16Expansion';
    /**
     * Constant for value 'LennoxIComfortIntegration'
     * @return string 'LennoxIComfortIntegration'
     */
    const VALUE_LENNOX_ICOMFORT_INTEGRATION = 'LennoxIComfortIntegration';
    /**
     * Constant for value 'AlarmLink'
     * @return string 'AlarmLink'
     */
    const VALUE_ALARM_LINK = 'AlarmLink';
    /**
     * Constant for value 'ImageSensorLimited'
     * @return string 'ImageSensorLimited'
     */
    const VALUE_IMAGE_SENSOR_LIMITED = 'ImageSensorLimited';
    /**
     * Constant for value 'SolarIntegration'
     * @return string 'SolarIntegration'
     */
    const VALUE_SOLAR_INTEGRATION = 'SolarIntegration';
    /**
     * Constant for value 'ZWaveShades'
     * @return string 'ZWaveShades'
     */
    const VALUE_ZWAVE_SHADES = 'ZWaveShades';
    /**
     * Constant for value 'UnattendedShowing'
     * @return string 'UnattendedShowing'
     */
    const VALUE_UNATTENDED_SHOWING = 'UnattendedShowing';
    /**
     * Constant for value 'AccessControl16'
     * @return string 'AccessControl16'
     */
    const VALUE_ACCESS_CONTROL_16 = 'AccessControl16';
    /**
     * Constant for value 'AccessControl32'
     * @return string 'AccessControl32'
     */
    const VALUE_ACCESS_CONTROL_32 = 'AccessControl32';
    /**
     * Constant for value 'AccessControl64'
     * @return string 'AccessControl64'
     */
    const VALUE_ACCESS_CONTROL_64 = 'AccessControl64';
    /**
     * Constant for value 'SmartViewForOnboardRecording'
     * @return string 'SmartViewForOnboardRecording'
     */
    const VALUE_SMART_VIEW_FOR_ONBOARD_RECORDING = 'SmartViewForOnboardRecording';
    /**
     * Constant for value 'OpenEyeCloudConnect'
     * @return string 'OpenEyeCloudConnect'
     */
    const VALUE_OPEN_EYE_CLOUD_CONNECT = 'OpenEyeCloudConnect';
    /**
     * Constant for value 'BusinessActivityAnalytics'
     * @return string 'BusinessActivityAnalytics'
     */
    const VALUE_BUSINESS_ACTIVITY_ANALYTICS = 'BusinessActivityAnalytics';
    /**
     * Constant for value 'PremiumVideo'
     * @return string 'PremiumVideo'
     */
    const VALUE_PREMIUM_VIDEO = 'PremiumVideo';
    /**
     * Constant for value 'ExtraSmarterBusinessTemperatureMonitoringSensors'
     * @return string 'ExtraSmarterBusinessTemperatureMonitoringSensors'
     */
    const VALUE_EXTRA_SMARTER_BUSINESS_TEMPERATURE_MONITORING_SENSORS = 'ExtraSmarterBusinessTemperatureMonitoringSensors';
    /**
     * Constant for value 'SmartViewForOnboardRecordingCV'
     * @return string 'SmartViewForOnboardRecordingCV'
     */
    const VALUE_SMART_VIEW_FOR_ONBOARD_RECORDING_CV = 'SmartViewForOnboardRecordingCV';
    /**
     * Constant for value 'VideoAnalyticsRuleCreated'
     * @return string 'VideoAnalyticsRuleCreated'
     */
    const VALUE_VIDEO_ANALYTICS_RULE_CREATED = 'VideoAnalyticsRuleCreated';
    /**
     * Constant for value 'ProVideoWithAnalytics1000'
     * @return string 'ProVideoWithAnalytics1000'
     */
    const VALUE_PRO_VIDEO_WITH_ANALYTICS_1000 = 'ProVideoWithAnalytics1000';
    /**
     * Constant for value 'AzureActiveDirectoryIntegration'
     * @return string 'AzureActiveDirectoryIntegration'
     */
    const VALUE_AZURE_ACTIVE_DIRECTORY_INTEGRATION = 'AzureActiveDirectoryIntegration';
    /**
     * Constant for value 'VideoAnalyticsRuleCreated2000'
     * @return string 'VideoAnalyticsRuleCreated2000'
     */
    const VALUE_VIDEO_ANALYTICS_RULE_CREATED_2000 = 'VideoAnalyticsRuleCreated2000';
    /**
     * Constant for value 'Ambient'
     * @return string 'Ambient'
     */
    const VALUE_AMBIENT = 'Ambient';
    /**
     * Constant for value 'UnattendedShowingSolution'
     * @return string 'UnattendedShowingSolution'
     */
    const VALUE_UNATTENDED_SHOWING_SOLUTION = 'UnattendedShowingSolution';
    /**
     * Constant for value 'SingleDoorbellWithAnalytics'
     * @return string 'SingleDoorbellWithAnalytics'
     */
    const VALUE_SINGLE_DOORBELL_WITH_ANALYTICS = 'SingleDoorbellWithAnalytics';
    /**
     * Constant for value 'CommercialVideo4'
     * @return string 'CommercialVideo4'
     */
    const VALUE_COMMERCIAL_VIDEO_4 = 'CommercialVideo4';
    /**
     * Constant for value 'CommercialVideo4Expansion'
     * @return string 'CommercialVideo4Expansion'
     */
    const VALUE_COMMERCIAL_VIDEO_4_EXPANSION = 'CommercialVideo4Expansion';
    /**
     * Constant for value 'VideoBasic'
     * @return string 'VideoBasic'
     */
    const VALUE_VIDEO_BASIC = 'VideoBasic';
    /**
     * Constant for value 'VideoBasicWithAnalytics'
     * @return string 'VideoBasicWithAnalytics'
     */
    const VALUE_VIDEO_BASIC_WITH_ANALYTICS = 'VideoBasicWithAnalytics';
    /**
     * Constant for value 'VideoAwareness'
     * @return string 'VideoAwareness'
     */
    const VALUE_VIDEO_AWARENESS = 'VideoAwareness';
    /**
     * Constant for value 'VideoComplete'
     * @return string 'VideoComplete'
     */
    const VALUE_VIDEO_COMPLETE = 'VideoComplete';
    /**
     * Constant for value 'VideoOneCameraAddOn'
     * @return string 'VideoOneCameraAddOn'
     */
    const VALUE_VIDEO_ONE_CAMERA_ADD_ON = 'VideoOneCameraAddOn';
    /**
     * Constant for value 'BaseCallTime'
     * @return string 'BaseCallTime'
     */
    const VALUE_BASE_CALL_TIME = 'BaseCallTime';
    /**
     * Constant for value 'ImageUploadCount'
     * @return string 'ImageUploadCount'
     */
    const VALUE_IMAGE_UPLOAD_COUNT = 'ImageUploadCount';
    /**
     * Constant for value 'IOLights'
     * @return string 'IOLights'
     */
    const VALUE_IOLIGHTS = 'IOLights';
    /**
     * Constant for value 'IOLocks'
     * @return string 'IOLocks'
     */
    const VALUE_IOLOCKS = 'IOLocks';
    /**
     * Constant for value 'IOGarageDoorsAndGates'
     * @return string 'IOGarageDoorsAndGates'
     */
    const VALUE_IOGARAGE_DOORS_AND_GATES = 'IOGarageDoorsAndGates';
    /**
     * Constant for value 'NestVideoIntegration'
     * @return string 'NestVideoIntegration'
     */
    const VALUE_NEST_VIDEO_INTEGRATION = 'NestVideoIntegration';
    /**
     * Constant for value 'EssenceMPERS'
     * @return string 'EssenceMPERS'
     */
    const VALUE_ESSENCE_MPERS = 'EssenceMPERS';
    /**
     * Constant for value 'Builder770BasicDoorbell'
     * @return string 'Builder770BasicDoorbell'
     */
    const VALUE_BUILDER_770_BASIC_DOORBELL = 'Builder770BasicDoorbell';
    /**
     * Constant for value 'Builder770PremiumDoorbell'
     * @return string 'Builder770PremiumDoorbell'
     */
    const VALUE_BUILDER_770_PREMIUM_DOORBELL = 'Builder770PremiumDoorbell';
    /**
     * Constant for value 'ThirtyMinuteSupervision'
     * @return string 'ThirtyMinuteSupervision'
     */
    const VALUE_THIRTY_MINUTE_SUPERVISION = 'ThirtyMinuteSupervision';
    /**
     * Constant for value 'NestAwareResale'
     * @return string 'NestAwareResale'
     */
    const VALUE_NEST_AWARE_RESALE = 'NestAwareResale';
    /**
     * Constant for value 'SmarterAccessControlPlus'
     * @return string 'SmarterAccessControlPlus'
     */
    const VALUE_SMARTER_ACCESS_CONTROL_PLUS = 'SmarterAccessControlPlus';
    /**
     * Constant for value 'AccessControlPlus16'
     * @return string 'AccessControlPlus16'
     */
    const VALUE_ACCESS_CONTROL_PLUS_16 = 'AccessControlPlus16';
    /**
     * Constant for value 'AccessControlPlus32'
     * @return string 'AccessControlPlus32'
     */
    const VALUE_ACCESS_CONTROL_PLUS_32 = 'AccessControlPlus32';
    /**
     * Constant for value 'AccessControlPlus64'
     * @return string 'AccessControlPlus64'
     */
    const VALUE_ACCESS_CONTROL_PLUS_64 = 'AccessControlPlus64';
    /**
     * Constant for value 'AccessControlPlusDoors'
     * @return string 'AccessControlPlusDoors'
     */
    const VALUE_ACCESS_CONTROL_PLUS_DOORS = 'AccessControlPlusDoors';
    /**
     * Constant for value 'MobileCredentials'
     * @return string 'MobileCredentials'
     */
    const VALUE_MOBILE_CREDENTIALS = 'MobileCredentials';
    /**
     * Constant for value 'LiftMasterSurcharge'
     * @return string 'LiftMasterSurcharge'
     */
    const VALUE_LIFT_MASTER_SURCHARGE = 'LiftMasterSurcharge';
    /**
     * Constant for value 'FreeMobileCredentials'
     * @return string 'FreeMobileCredentials'
     */
    const VALUE_FREE_MOBILE_CREDENTIALS = 'FreeMobileCredentials';
    /**
     * Constant for value 'VideoPropertyPanic'
     * @return string 'VideoPropertyPanic'
     */
    const VALUE_VIDEO_PROPERTY_PANIC = 'VideoPropertyPanic';
    /**
     * Constant for value 'SmartArming'
     * @return string 'SmartArming'
     */
    const VALUE_SMART_ARMING = 'SmartArming';
    /**
     * Constant for value 'CommercialVideo2Basic'
     * @return string 'CommercialVideo2Basic'
     */
    const VALUE_COMMERCIAL_VIDEO_2_BASIC = 'CommercialVideo2Basic';
    /**
     * Constant for value 'CommercialVideo2BasicExpansion'
     * @return string 'CommercialVideo2BasicExpansion'
     */
    const VALUE_COMMERCIAL_VIDEO_2_BASIC_EXPANSION = 'CommercialVideo2BasicExpansion';
    /**
     * Constant for value 'WaterCloudDevices'
     * @return string 'WaterCloudDevices'
     */
    const VALUE_WATER_CLOUD_DEVICES = 'WaterCloudDevices';
    /**
     * Constant for value 'ElevatedEventsMonitoring'
     * @return string 'ElevatedEventsMonitoring'
     */
    const VALUE_ELEVATED_EVENTS_MONITORING = 'ElevatedEventsMonitoring';
    /**
     * Constant for value 'ZWaveNoiseSensors'
     * @return string 'ZWaveNoiseSensors'
     */
    const VALUE_ZWAVE_NOISE_SENSORS = 'ZWaveNoiseSensors';
    /**
     * Constant for value 'ThirdPartyCameras'
     * @return string 'ThirdPartyCameras'
     */
    const VALUE_THIRD_PARTY_CAMERAS = 'ThirdPartyCameras';
    /**
     * Constant for value 'CellRouter'
     * @return string 'CellRouter'
     */
    const VALUE_CELL_ROUTER = 'CellRouter';
    /**
     * Constant for value 'ConnectedFleet'
     * @return string 'ConnectedFleet'
     */
    const VALUE_CONNECTED_FLEET = 'ConnectedFleet';
    /**
     * Constant for value 'AmbientVoice'
     * @return string 'AmbientVoice'
     */
    const VALUE_AMBIENT_VOICE = 'AmbientVoice';
    /**
     * Constant for value 'WifiAwareness'
     * @return string 'WifiAwareness'
     */
    const VALUE_WIFI_AWARENESS = 'WifiAwareness';
    /**
     * Constant for value 'MobileCredentials2500'
     * @return string 'MobileCredentials2500'
     */
    const VALUE_MOBILE_CREDENTIALS_2500 = 'MobileCredentials2500';
    /**
     * Constant for value 'MobileCredentials5000'
     * @return string 'MobileCredentials5000'
     */
    const VALUE_MOBILE_CREDENTIALS_5000 = 'MobileCredentials5000';
    /**
     * Constant for value 'MobileCredentials7500'
     * @return string 'MobileCredentials7500'
     */
    const VALUE_MOBILE_CREDENTIALS_7500 = 'MobileCredentials7500';
    /**
     * Constant for value 'LocalMalfunctionSignalingAndSecondaryReaderSupport'
     * @return string 'LocalMalfunctionSignalingAndSecondaryReaderSupport'
     */
    const VALUE_LOCAL_MALFUNCTION_SIGNALING_AND_SECONDARY_READER_SUPPORT = 'LocalMalfunctionSignalingAndSecondaryReaderSupport';
    /**
     * Constant for value 'PropertyActions'
     * @return string 'PropertyActions'
     */
    const VALUE_PROPERTY_ACTIONS = 'PropertyActions';
    /**
     * Constant for value 'GunshotDetectionSDS'
     * @return string 'GunshotDetectionSDS'
     */
    const VALUE_GUNSHOT_DETECTION_SDS = 'GunshotDetectionSDS';
    /**
     * Constant for value 'GunshotDetectionPlusSDS'
     * @return string 'GunshotDetectionPlusSDS'
     */
    const VALUE_GUNSHOT_DETECTION_PLUS_SDS = 'GunshotDetectionPlusSDS';
    /**
     * Constant for value 'MultiLevelEnterpriseSecurityConsole'
     * @return string 'MultiLevelEnterpriseSecurityConsole'
     */
    const VALUE_MULTI_LEVEL_ENTERPRISE_SECURITY_CONSOLE = 'MultiLevelEnterpriseSecurityConsole';
    /**
     * Constant for value 'CameraTwoWayAudioforMonitoringResponse'
     * @return string 'CameraTwoWayAudioforMonitoringResponse'
     */
    const VALUE_CAMERA_TWO_WAY_AUDIOFOR_MONITORING_RESPONSE = 'CameraTwoWayAudioforMonitoringResponse';
    /**
     * Constant for value 'Noonlight'
     * @return string 'Noonlight'
     */
    const VALUE_NOONLIGHT = 'Noonlight';
    /**
     * Constant for value 'ProactiveVideoEscalatedEventMonitoring'
     * @return string 'ProactiveVideoEscalatedEventMonitoring'
     */
    const VALUE_PROACTIVE_VIDEO_ESCALATED_EVENT_MONITORING = 'ProactiveVideoEscalatedEventMonitoring';
    /**
     * Constant for value 'AccessControlEscalatedEventMonitoring'
     * @return string 'AccessControlEscalatedEventMonitoring'
     */
    const VALUE_ACCESS_CONTROL_ESCALATED_EVENT_MONITORING = 'AccessControlEscalatedEventMonitoring';
    /**
     * Constant for value 'ContinuousAudioRecordingSvr'
     * @return string 'ContinuousAudioRecordingSvr'
     */
    const VALUE_CONTINUOUS_AUDIO_RECORDING_SVR = 'ContinuousAudioRecordingSvr';
    /**
     * Return allowed values
     * @uses self::VALUE_VOICE_NOTIFICATIONS_FOR_ALARMS
     * @uses self::VALUE_VOICE_NOTIFICATIONS_FOR_MONITORING
     * @uses self::VALUE_LIGHT_AUTOMATION
     * @uses self::VALUE_USER_CODE_CONTROL
     * @uses self::VALUE_REMOTE_ARMING
     * @uses self::VALUE_THERMOSTAT_CONTROL
     * @uses self::VALUE_ARMING_SUPERVISION
     * @uses self::VALUE_NORMAL_ACTIVITY_REPORTS
     * @uses self::VALUE_ARMING_REPORTS
     * @uses self::VALUE_ARMING_SCHEDULES
     * @uses self::VALUE_INACTIVITY
     * @uses self::VALUE_FIVE_NORMAL_ACTIVITY_SENSORS
     * @uses self::VALUE_PRO_VIDEO
     * @uses self::VALUE_PRO_VIDEO_PLUS
     * @uses self::VALUE_TWO_FIFTY_MBEXTRA_VIDEO_STORAGE
     * @uses self::VALUE_TWO_WAY_VOICE
     * @uses self::VALUE_WEATHER_TO_PANEL
     * @uses self::VALUE_DIGITAL_INPUT_VIDEOS
     * @uses self::VALUE_MEDICATION_ALERTS
     * @uses self::VALUE_ZWAVE_LIGHTS
     * @uses self::VALUE_ZWAVE_THERMOSTATS
     * @uses self::VALUE_ZWAVE_LOCKS
     * @uses self::VALUE_ENTERPRISE_NOTICES
     * @uses self::VALUE_ZWAVE_ENERGY
     * @uses self::VALUE_REMINDERS
     * @uses self::VALUE_SEVERE_WEATHER_ALERTS
     * @uses self::VALUE_IMAGE_SENSOR_ALARMS
     * @uses self::VALUE_IMAGE_SENSOR_PLUS
     * @uses self::VALUE_IMAGE_SENSOR_EXTRA_UPLOADS
     * @uses self::VALUE_ENTERPRISE_SECURITY_CONSOLE
     * @uses self::VALUE_SMART_ENERGY_PLUS
     * @uses self::VALUE_SECURUS
     * @uses self::VALUE_LUTRON_REMOTE_ACCESS
     * @uses self::VALUE_OBSOLETE_LUTRON_LIGHTS_AND_THERMOSTATS
     * @uses self::VALUE_IDPROTECTION
     * @uses self::VALUE_GREEN_BUTTON
     * @uses self::VALUE_GARAGE_DOORS
     * @uses self::VALUE_WELLNESS
     * @uses self::VALUE_ADVANCED_ENERGY
     * @uses self::VALUE_ADVANCED_AUTOMATION
     * @uses self::VALUE_LUTRON_INTEGRATION
     * @uses self::VALUE_LIFT_MASTER_INTEGRATION
     * @uses self::VALUE_SCHNEIDER_INTEGRATION
     * @uses self::VALUE_VIDEO_24_X_7_PER_SVR
     * @uses self::VALUE_TAGG_INTEGRATION
     * @uses self::VALUE_WATER_MANAGEMENT
     * @uses self::VALUE_COMMERCIAL_ACTIVITY_REPORTS
     * @uses self::VALUE_BE_CLOSE_COMMUNITY_VIEW
     * @uses self::VALUE_ULCOMMERICIAL
     * @uses self::VALUE_SOLAR_MONITORING
     * @uses self::VALUE_SOLAR_EDGE_INTEGRATION
     * @uses self::VALUE_ENPHASE_INTEGRATION
     * @uses self::VALUE_NESTINTEGRATION
     * @uses self::VALUE_SMSALARMS
     * @uses self::VALUE_SMSNOTIFICATIONS_MEXICO
     * @uses self::VALUE_ENTERPRISE_ENERGY
     * @uses self::VALUE_ENTERPRISE_WELLNESS
     * @uses self::VALUE_IRRIGATION_CONTROL
     * @uses self::VALUE_RACHIO_INTEGRATION
     * @uses self::VALUE_CONNECTED_CAR
     * @uses self::VALUE_PROPANE_MONITORING
     * @uses self::VALUE_SMSNOTIFICATIONS_CHILE
     * @uses self::VALUE_SMSNOTIFICATIONS_COLOMBIA
     * @uses self::VALUE_SMSNOTIFICATIONS_NZ
     * @uses self::VALUE_SMSNOTIFICATIONS_AUSTRALIA
     * @uses self::VALUE_SMSNOTIFICATIONS_BRAZIL
     * @uses self::VALUE_SMSNOTIFICATIONS_PANAMA
     * @uses self::VALUE_COSA_INTEGRATION
     * @uses self::VALUE_OSNAPP_INTEGRATION
     * @uses self::VALUE_CONNECTED_CAR_PLUS
     * @uses self::VALUE_DOORBELL_CAMERAS
     * @uses self::VALUE_UNEXPECTED_ACTIVITY_ALERTS
     * @uses self::VALUE_ACCESS_CONTROL
     * @uses self::VALUE_ZWAVE_CO
     * @uses self::VALUE_HOURLY_SUPERVISION
     * @uses self::VALUE_SIX_HOUR_SUPERVISION
     * @uses self::VALUE_BASIC_DOORBELL
     * @uses self::VALUE_ALARM_VISUAL_VERIFICATION
     * @uses self::VALUE_PANIC_BUTTON
     * @uses self::VALUE_AUDIO_INTEGRATION
     * @uses self::VALUE_KONA_LABS_WATER_METERING
     * @uses self::VALUE_VIDEO_DEVICE_AUDIO
     * @uses self::VALUE_CANCEL_VERIFY
     * @uses self::VALUE_SMSNOTIFICATIONS_BELGIUM
     * @uses self::VALUE_ACCESS_CONTROL_DOORS
     * @uses self::VALUE_ROUTER_LIMITS
     * @uses self::VALUE_HOME_CONTROLLER_INTEGRATION
     * @uses self::VALUE_FLEX_IO
     * @uses self::VALUE_SMSNOTIFICATIONS_SWEDEN
     * @uses self::VALUE_SMSNOTIFICATIONS_NETHERLANDS
     * @uses self::VALUE_PRO_VIDEO_WITH_ANALYTICS
     * @uses self::VALUE_CONNECTED_CAR_CAL_AMP
     * @uses self::VALUE_SMSNOTIFICATIONS_NORWAY
     * @uses self::VALUE_SMSNOTIFICATIONS_IRELAND
     * @uses self::VALUE_CARRIER_COR_INTEGRATION
     * @uses self::VALUE_BUILDER_DOORBELL
     * @uses self::VALUE_ACCESS_PLAN_USER_MANAGEMENT
     * @uses self::VALUE_WATER_MANAGEMENT_PLUS
     * @uses self::VALUE_SMARTER_BUSINESS_TEMPERATURE_MONITORING
     * @uses self::VALUE_COMMERCIAL_VIDEO_8
     * @uses self::VALUE_COMMERCIAL_VIDEO_16
     * @uses self::VALUE_COMMERCIAL_VIDEO_8_EXPANSION
     * @uses self::VALUE_COMMERCIAL_VIDEO_16_EXPANSION
     * @uses self::VALUE_LENNOX_ICOMFORT_INTEGRATION
     * @uses self::VALUE_ALARM_LINK
     * @uses self::VALUE_IMAGE_SENSOR_LIMITED
     * @uses self::VALUE_SOLAR_INTEGRATION
     * @uses self::VALUE_ZWAVE_SHADES
     * @uses self::VALUE_UNATTENDED_SHOWING
     * @uses self::VALUE_ACCESS_CONTROL_16
     * @uses self::VALUE_ACCESS_CONTROL_32
     * @uses self::VALUE_ACCESS_CONTROL_64
     * @uses self::VALUE_SMART_VIEW_FOR_ONBOARD_RECORDING
     * @uses self::VALUE_OPEN_EYE_CLOUD_CONNECT
     * @uses self::VALUE_BUSINESS_ACTIVITY_ANALYTICS
     * @uses self::VALUE_PREMIUM_VIDEO
     * @uses self::VALUE_EXTRA_SMARTER_BUSINESS_TEMPERATURE_MONITORING_SENSORS
     * @uses self::VALUE_SMART_VIEW_FOR_ONBOARD_RECORDING_CV
     * @uses self::VALUE_VIDEO_ANALYTICS_RULE_CREATED
     * @uses self::VALUE_PRO_VIDEO_WITH_ANALYTICS_1000
     * @uses self::VALUE_AZURE_ACTIVE_DIRECTORY_INTEGRATION
     * @uses self::VALUE_VIDEO_ANALYTICS_RULE_CREATED_2000
     * @uses self::VALUE_AMBIENT
     * @uses self::VALUE_UNATTENDED_SHOWING_SOLUTION
     * @uses self::VALUE_SINGLE_DOORBELL_WITH_ANALYTICS
     * @uses self::VALUE_COMMERCIAL_VIDEO_4
     * @uses self::VALUE_COMMERCIAL_VIDEO_4_EXPANSION
     * @uses self::VALUE_VIDEO_BASIC
     * @uses self::VALUE_VIDEO_BASIC_WITH_ANALYTICS
     * @uses self::VALUE_VIDEO_AWARENESS
     * @uses self::VALUE_VIDEO_COMPLETE
     * @uses self::VALUE_VIDEO_ONE_CAMERA_ADD_ON
     * @uses self::VALUE_BASE_CALL_TIME
     * @uses self::VALUE_IMAGE_UPLOAD_COUNT
     * @uses self::VALUE_IOLIGHTS
     * @uses self::VALUE_IOLOCKS
     * @uses self::VALUE_IOGARAGE_DOORS_AND_GATES
     * @uses self::VALUE_NEST_VIDEO_INTEGRATION
     * @uses self::VALUE_ESSENCE_MPERS
     * @uses self::VALUE_BUILDER_770_BASIC_DOORBELL
     * @uses self::VALUE_BUILDER_770_PREMIUM_DOORBELL
     * @uses self::VALUE_THIRTY_MINUTE_SUPERVISION
     * @uses self::VALUE_NEST_AWARE_RESALE
     * @uses self::VALUE_SMARTER_ACCESS_CONTROL_PLUS
     * @uses self::VALUE_ACCESS_CONTROL_PLUS_16
     * @uses self::VALUE_ACCESS_CONTROL_PLUS_32
     * @uses self::VALUE_ACCESS_CONTROL_PLUS_64
     * @uses self::VALUE_ACCESS_CONTROL_PLUS_DOORS
     * @uses self::VALUE_MOBILE_CREDENTIALS
     * @uses self::VALUE_LIFT_MASTER_SURCHARGE
     * @uses self::VALUE_FREE_MOBILE_CREDENTIALS
     * @uses self::VALUE_VIDEO_PROPERTY_PANIC
     * @uses self::VALUE_SMART_ARMING
     * @uses self::VALUE_COMMERCIAL_VIDEO_2_BASIC
     * @uses self::VALUE_COMMERCIAL_VIDEO_2_BASIC_EXPANSION
     * @uses self::VALUE_WATER_CLOUD_DEVICES
     * @uses self::VALUE_ELEVATED_EVENTS_MONITORING
     * @uses self::VALUE_ZWAVE_NOISE_SENSORS
     * @uses self::VALUE_THIRD_PARTY_CAMERAS
     * @uses self::VALUE_CELL_ROUTER
     * @uses self::VALUE_CONNECTED_FLEET
     * @uses self::VALUE_AMBIENT_VOICE
     * @uses self::VALUE_WIFI_AWARENESS
     * @uses self::VALUE_MOBILE_CREDENTIALS_2500
     * @uses self::VALUE_MOBILE_CREDENTIALS_5000
     * @uses self::VALUE_MOBILE_CREDENTIALS_7500
     * @uses self::VALUE_LOCAL_MALFUNCTION_SIGNALING_AND_SECONDARY_READER_SUPPORT
     * @uses self::VALUE_PROPERTY_ACTIONS
     * @uses self::VALUE_GUNSHOT_DETECTION_SDS
     * @uses self::VALUE_GUNSHOT_DETECTION_PLUS_SDS
     * @uses self::VALUE_MULTI_LEVEL_ENTERPRISE_SECURITY_CONSOLE
     * @uses self::VALUE_CAMERA_TWO_WAY_AUDIOFOR_MONITORING_RESPONSE
     * @uses self::VALUE_NOONLIGHT
     * @uses self::VALUE_PROACTIVE_VIDEO_ESCALATED_EVENT_MONITORING
     * @uses self::VALUE_ACCESS_CONTROL_ESCALATED_EVENT_MONITORING
     * @uses self::VALUE_CONTINUOUS_AUDIO_RECORDING_SVR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_VOICE_NOTIFICATIONS_FOR_ALARMS,
            self::VALUE_VOICE_NOTIFICATIONS_FOR_MONITORING,
            self::VALUE_LIGHT_AUTOMATION,
            self::VALUE_USER_CODE_CONTROL,
            self::VALUE_REMOTE_ARMING,
            self::VALUE_THERMOSTAT_CONTROL,
            self::VALUE_ARMING_SUPERVISION,
            self::VALUE_NORMAL_ACTIVITY_REPORTS,
            self::VALUE_ARMING_REPORTS,
            self::VALUE_ARMING_SCHEDULES,
            self::VALUE_INACTIVITY,
            self::VALUE_FIVE_NORMAL_ACTIVITY_SENSORS,
            self::VALUE_PRO_VIDEO,
            self::VALUE_PRO_VIDEO_PLUS,
            self::VALUE_TWO_FIFTY_MBEXTRA_VIDEO_STORAGE,
            self::VALUE_TWO_WAY_VOICE,
            self::VALUE_WEATHER_TO_PANEL,
            self::VALUE_DIGITAL_INPUT_VIDEOS,
            self::VALUE_MEDICATION_ALERTS,
            self::VALUE_ZWAVE_LIGHTS,
            self::VALUE_ZWAVE_THERMOSTATS,
            self::VALUE_ZWAVE_LOCKS,
            self::VALUE_ENTERPRISE_NOTICES,
            self::VALUE_ZWAVE_ENERGY,
            self::VALUE_REMINDERS,
            self::VALUE_SEVERE_WEATHER_ALERTS,
            self::VALUE_IMAGE_SENSOR_ALARMS,
            self::VALUE_IMAGE_SENSOR_PLUS,
            self::VALUE_IMAGE_SENSOR_EXTRA_UPLOADS,
            self::VALUE_ENTERPRISE_SECURITY_CONSOLE,
            self::VALUE_SMART_ENERGY_PLUS,
            self::VALUE_SECURUS,
            self::VALUE_LUTRON_REMOTE_ACCESS,
            self::VALUE_OBSOLETE_LUTRON_LIGHTS_AND_THERMOSTATS,
            self::VALUE_IDPROTECTION,
            self::VALUE_GREEN_BUTTON,
            self::VALUE_GARAGE_DOORS,
            self::VALUE_WELLNESS,
            self::VALUE_ADVANCED_ENERGY,
            self::VALUE_ADVANCED_AUTOMATION,
            self::VALUE_LUTRON_INTEGRATION,
            self::VALUE_LIFT_MASTER_INTEGRATION,
            self::VALUE_SCHNEIDER_INTEGRATION,
            self::VALUE_VIDEO_24_X_7_PER_SVR,
            self::VALUE_TAGG_INTEGRATION,
            self::VALUE_WATER_MANAGEMENT,
            self::VALUE_COMMERCIAL_ACTIVITY_REPORTS,
            self::VALUE_BE_CLOSE_COMMUNITY_VIEW,
            self::VALUE_ULCOMMERICIAL,
            self::VALUE_SOLAR_MONITORING,
            self::VALUE_SOLAR_EDGE_INTEGRATION,
            self::VALUE_ENPHASE_INTEGRATION,
            self::VALUE_NESTINTEGRATION,
            self::VALUE_SMSALARMS,
            self::VALUE_SMSNOTIFICATIONS_MEXICO,
            self::VALUE_ENTERPRISE_ENERGY,
            self::VALUE_ENTERPRISE_WELLNESS,
            self::VALUE_IRRIGATION_CONTROL,
            self::VALUE_RACHIO_INTEGRATION,
            self::VALUE_CONNECTED_CAR,
            self::VALUE_PROPANE_MONITORING,
            self::VALUE_SMSNOTIFICATIONS_CHILE,
            self::VALUE_SMSNOTIFICATIONS_COLOMBIA,
            self::VALUE_SMSNOTIFICATIONS_NZ,
            self::VALUE_SMSNOTIFICATIONS_AUSTRALIA,
            self::VALUE_SMSNOTIFICATIONS_BRAZIL,
            self::VALUE_SMSNOTIFICATIONS_PANAMA,
            self::VALUE_COSA_INTEGRATION,
            self::VALUE_OSNAPP_INTEGRATION,
            self::VALUE_CONNECTED_CAR_PLUS,
            self::VALUE_DOORBELL_CAMERAS,
            self::VALUE_UNEXPECTED_ACTIVITY_ALERTS,
            self::VALUE_ACCESS_CONTROL,
            self::VALUE_ZWAVE_CO,
            self::VALUE_HOURLY_SUPERVISION,
            self::VALUE_SIX_HOUR_SUPERVISION,
            self::VALUE_BASIC_DOORBELL,
            self::VALUE_ALARM_VISUAL_VERIFICATION,
            self::VALUE_PANIC_BUTTON,
            self::VALUE_AUDIO_INTEGRATION,
            self::VALUE_KONA_LABS_WATER_METERING,
            self::VALUE_VIDEO_DEVICE_AUDIO,
            self::VALUE_CANCEL_VERIFY,
            self::VALUE_SMSNOTIFICATIONS_BELGIUM,
            self::VALUE_ACCESS_CONTROL_DOORS,
            self::VALUE_ROUTER_LIMITS,
            self::VALUE_HOME_CONTROLLER_INTEGRATION,
            self::VALUE_FLEX_IO,
            self::VALUE_SMSNOTIFICATIONS_SWEDEN,
            self::VALUE_SMSNOTIFICATIONS_NETHERLANDS,
            self::VALUE_PRO_VIDEO_WITH_ANALYTICS,
            self::VALUE_CONNECTED_CAR_CAL_AMP,
            self::VALUE_SMSNOTIFICATIONS_NORWAY,
            self::VALUE_SMSNOTIFICATIONS_IRELAND,
            self::VALUE_CARRIER_COR_INTEGRATION,
            self::VALUE_BUILDER_DOORBELL,
            self::VALUE_ACCESS_PLAN_USER_MANAGEMENT,
            self::VALUE_WATER_MANAGEMENT_PLUS,
            self::VALUE_SMARTER_BUSINESS_TEMPERATURE_MONITORING,
            self::VALUE_COMMERCIAL_VIDEO_8,
            self::VALUE_COMMERCIAL_VIDEO_16,
            self::VALUE_COMMERCIAL_VIDEO_8_EXPANSION,
            self::VALUE_COMMERCIAL_VIDEO_16_EXPANSION,
            self::VALUE_LENNOX_ICOMFORT_INTEGRATION,
            self::VALUE_ALARM_LINK,
            self::VALUE_IMAGE_SENSOR_LIMITED,
            self::VALUE_SOLAR_INTEGRATION,
            self::VALUE_ZWAVE_SHADES,
            self::VALUE_UNATTENDED_SHOWING,
            self::VALUE_ACCESS_CONTROL_16,
            self::VALUE_ACCESS_CONTROL_32,
            self::VALUE_ACCESS_CONTROL_64,
            self::VALUE_SMART_VIEW_FOR_ONBOARD_RECORDING,
            self::VALUE_OPEN_EYE_CLOUD_CONNECT,
            self::VALUE_BUSINESS_ACTIVITY_ANALYTICS,
            self::VALUE_PREMIUM_VIDEO,
            self::VALUE_EXTRA_SMARTER_BUSINESS_TEMPERATURE_MONITORING_SENSORS,
            self::VALUE_SMART_VIEW_FOR_ONBOARD_RECORDING_CV,
            self::VALUE_VIDEO_ANALYTICS_RULE_CREATED,
            self::VALUE_PRO_VIDEO_WITH_ANALYTICS_1000,
            self::VALUE_AZURE_ACTIVE_DIRECTORY_INTEGRATION,
            self::VALUE_VIDEO_ANALYTICS_RULE_CREATED_2000,
            self::VALUE_AMBIENT,
            self::VALUE_UNATTENDED_SHOWING_SOLUTION,
            self::VALUE_SINGLE_DOORBELL_WITH_ANALYTICS,
            self::VALUE_COMMERCIAL_VIDEO_4,
            self::VALUE_COMMERCIAL_VIDEO_4_EXPANSION,
            self::VALUE_VIDEO_BASIC,
            self::VALUE_VIDEO_BASIC_WITH_ANALYTICS,
            self::VALUE_VIDEO_AWARENESS,
            self::VALUE_VIDEO_COMPLETE,
            self::VALUE_VIDEO_ONE_CAMERA_ADD_ON,
            self::VALUE_BASE_CALL_TIME,
            self::VALUE_IMAGE_UPLOAD_COUNT,
            self::VALUE_IOLIGHTS,
            self::VALUE_IOLOCKS,
            self::VALUE_IOGARAGE_DOORS_AND_GATES,
            self::VALUE_NEST_VIDEO_INTEGRATION,
            self::VALUE_ESSENCE_MPERS,
            self::VALUE_BUILDER_770_BASIC_DOORBELL,
            self::VALUE_BUILDER_770_PREMIUM_DOORBELL,
            self::VALUE_THIRTY_MINUTE_SUPERVISION,
            self::VALUE_NEST_AWARE_RESALE,
            self::VALUE_SMARTER_ACCESS_CONTROL_PLUS,
            self::VALUE_ACCESS_CONTROL_PLUS_16,
            self::VALUE_ACCESS_CONTROL_PLUS_32,
            self::VALUE_ACCESS_CONTROL_PLUS_64,
            self::VALUE_ACCESS_CONTROL_PLUS_DOORS,
            self::VALUE_MOBILE_CREDENTIALS,
            self::VALUE_LIFT_MASTER_SURCHARGE,
            self::VALUE_FREE_MOBILE_CREDENTIALS,
            self::VALUE_VIDEO_PROPERTY_PANIC,
            self::VALUE_SMART_ARMING,
            self::VALUE_COMMERCIAL_VIDEO_2_BASIC,
            self::VALUE_COMMERCIAL_VIDEO_2_BASIC_EXPANSION,
            self::VALUE_WATER_CLOUD_DEVICES,
            self::VALUE_ELEVATED_EVENTS_MONITORING,
            self::VALUE_ZWAVE_NOISE_SENSORS,
            self::VALUE_THIRD_PARTY_CAMERAS,
            self::VALUE_CELL_ROUTER,
            self::VALUE_CONNECTED_FLEET,
            self::VALUE_AMBIENT_VOICE,
            self::VALUE_WIFI_AWARENESS,
            self::VALUE_MOBILE_CREDENTIALS_2500,
            self::VALUE_MOBILE_CREDENTIALS_5000,
            self::VALUE_MOBILE_CREDENTIALS_7500,
            self::VALUE_LOCAL_MALFUNCTION_SIGNALING_AND_SECONDARY_READER_SUPPORT,
            self::VALUE_PROPERTY_ACTIONS,
            self::VALUE_GUNSHOT_DETECTION_SDS,
            self::VALUE_GUNSHOT_DETECTION_PLUS_SDS,
            self::VALUE_MULTI_LEVEL_ENTERPRISE_SECURITY_CONSOLE,
            self::VALUE_CAMERA_TWO_WAY_AUDIOFOR_MONITORING_RESPONSE,
            self::VALUE_NOONLIGHT,
            self::VALUE_PROACTIVE_VIDEO_ESCALATED_EVENT_MONITORING,
            self::VALUE_ACCESS_CONTROL_ESCALATED_EVENT_MONITORING,
            self::VALUE_CONTINUOUS_AUDIO_RECORDING_SVR,
        );
    }
}
