<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VideoRecordingRule StructType
 * @subpackage Structs
 */
class VideoRecordingRule extends AbstractStructBase
{
    /**
     * The CameraDeviceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CameraDeviceId;
    /**
     * The PausedByUser
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $PausedByUser;
    /**
     * The RuleId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RuleId;
    /**
     * The SupportsRecordingExceptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SupportsRecordingExceptions;
    /**
     * The CurrentlyInException
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CurrentlyInException;
    /**
     * The CameraDeviceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CameraDeviceName;
    /**
     * The RuleName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RuleName;
    /**
     * Constructor method for VideoRecordingRule
     * @uses VideoRecordingRule::setCameraDeviceId()
     * @uses VideoRecordingRule::setPausedByUser()
     * @uses VideoRecordingRule::setRuleId()
     * @uses VideoRecordingRule::setSupportsRecordingExceptions()
     * @uses VideoRecordingRule::setCurrentlyInException()
     * @uses VideoRecordingRule::setCameraDeviceName()
     * @uses VideoRecordingRule::setRuleName()
     * @param int $cameraDeviceId
     * @param bool $pausedByUser
     * @param int $ruleId
     * @param bool $supportsRecordingExceptions
     * @param bool $currentlyInException
     * @param string $cameraDeviceName
     * @param string $ruleName
     */
    public function __construct($cameraDeviceId = null, $pausedByUser = null, $ruleId = null, $supportsRecordingExceptions = null, $currentlyInException = null, $cameraDeviceName = null, $ruleName = null)
    {
        $this
            ->setCameraDeviceId($cameraDeviceId)
            ->setPausedByUser($pausedByUser)
            ->setRuleId($ruleId)
            ->setSupportsRecordingExceptions($supportsRecordingExceptions)
            ->setCurrentlyInException($currentlyInException)
            ->setCameraDeviceName($cameraDeviceName)
            ->setRuleName($ruleName);
    }
    /**
     * Get CameraDeviceId value
     * @return int
     */
    public function getCameraDeviceId()
    {
        return $this->CameraDeviceId;
    }
    /**
     * Set CameraDeviceId value
     * @param int $cameraDeviceId
     * @return \CustomerManagement\StructType\VideoRecordingRule
     */
    public function setCameraDeviceId($cameraDeviceId = null)
    {
        // validation for constraint: int
        if (!is_null($cameraDeviceId) && !(is_int($cameraDeviceId) || ctype_digit($cameraDeviceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cameraDeviceId, true), gettype($cameraDeviceId)), __LINE__);
        }
        $this->CameraDeviceId = $cameraDeviceId;
        return $this;
    }
    /**
     * Get PausedByUser value
     * @return bool
     */
    public function getPausedByUser()
    {
        return $this->PausedByUser;
    }
    /**
     * Set PausedByUser value
     * @param bool $pausedByUser
     * @return \CustomerManagement\StructType\VideoRecordingRule
     */
    public function setPausedByUser($pausedByUser = null)
    {
        // validation for constraint: boolean
        if (!is_null($pausedByUser) && !is_bool($pausedByUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pausedByUser, true), gettype($pausedByUser)), __LINE__);
        }
        $this->PausedByUser = $pausedByUser;
        return $this;
    }
    /**
     * Get RuleId value
     * @return int
     */
    public function getRuleId()
    {
        return $this->RuleId;
    }
    /**
     * Set RuleId value
     * @param int $ruleId
     * @return \CustomerManagement\StructType\VideoRecordingRule
     */
    public function setRuleId($ruleId = null)
    {
        // validation for constraint: int
        if (!is_null($ruleId) && !(is_int($ruleId) || ctype_digit($ruleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ruleId, true), gettype($ruleId)), __LINE__);
        }
        $this->RuleId = $ruleId;
        return $this;
    }
    /**
     * Get SupportsRecordingExceptions value
     * @return bool
     */
    public function getSupportsRecordingExceptions()
    {
        return $this->SupportsRecordingExceptions;
    }
    /**
     * Set SupportsRecordingExceptions value
     * @param bool $supportsRecordingExceptions
     * @return \CustomerManagement\StructType\VideoRecordingRule
     */
    public function setSupportsRecordingExceptions($supportsRecordingExceptions = null)
    {
        // validation for constraint: boolean
        if (!is_null($supportsRecordingExceptions) && !is_bool($supportsRecordingExceptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($supportsRecordingExceptions, true), gettype($supportsRecordingExceptions)), __LINE__);
        }
        $this->SupportsRecordingExceptions = $supportsRecordingExceptions;
        return $this;
    }
    /**
     * Get CurrentlyInException value
     * @return bool
     */
    public function getCurrentlyInException()
    {
        return $this->CurrentlyInException;
    }
    /**
     * Set CurrentlyInException value
     * @param bool $currentlyInException
     * @return \CustomerManagement\StructType\VideoRecordingRule
     */
    public function setCurrentlyInException($currentlyInException = null)
    {
        // validation for constraint: boolean
        if (!is_null($currentlyInException) && !is_bool($currentlyInException)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($currentlyInException, true), gettype($currentlyInException)), __LINE__);
        }
        $this->CurrentlyInException = $currentlyInException;
        return $this;
    }
    /**
     * Get CameraDeviceName value
     * @return string|null
     */
    public function getCameraDeviceName()
    {
        return $this->CameraDeviceName;
    }
    /**
     * Set CameraDeviceName value
     * @param string $cameraDeviceName
     * @return \CustomerManagement\StructType\VideoRecordingRule
     */
    public function setCameraDeviceName($cameraDeviceName = null)
    {
        // validation for constraint: string
        if (!is_null($cameraDeviceName) && !is_string($cameraDeviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cameraDeviceName, true), gettype($cameraDeviceName)), __LINE__);
        }
        $this->CameraDeviceName = $cameraDeviceName;
        return $this;
    }
    /**
     * Get RuleName value
     * @return string|null
     */
    public function getRuleName()
    {
        return $this->RuleName;
    }
    /**
     * Set RuleName value
     * @param string $ruleName
     * @return \CustomerManagement\StructType\VideoRecordingRule
     */
    public function setRuleName($ruleName = null)
    {
        // validation for constraint: string
        if (!is_null($ruleName) && !is_string($ruleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleName, true), gettype($ruleName)), __LINE__);
        }
        $this->RuleName = $ruleName;
        return $this;
    }
}
