<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateEBSFireDeviceInput StructType
 * @subpackage Structs
 */
class UpdateEBSFireDeviceInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The Manufacturer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Manufacturer;
    /**
     * The ManufacturerOther
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ManufacturerOther;
    /**
     * The ModelOther
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ModelOther;
    /**
     * The FirmwareVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirmwareVersion;
    /**
     * Constructor method for UpdateEBSFireDeviceInput
     * @uses UpdateEBSFireDeviceInput::setCustomerId()
     * @uses UpdateEBSFireDeviceInput::setManufacturer()
     * @uses UpdateEBSFireDeviceInput::setManufacturerOther()
     * @uses UpdateEBSFireDeviceInput::setModelOther()
     * @uses UpdateEBSFireDeviceInput::setFirmwareVersion()
     * @param int $customerId
     * @param string $manufacturer
     * @param string $manufacturerOther
     * @param string $modelOther
     * @param string $firmwareVersion
     */
    public function __construct($customerId = null, $manufacturer = null, $manufacturerOther = null, $modelOther = null, $firmwareVersion = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setManufacturer($manufacturer)
            ->setManufacturerOther($manufacturerOther)
            ->setModelOther($modelOther)
            ->setFirmwareVersion($firmwareVersion);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateEBSFireDeviceInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get Manufacturer value
     * @return string
     */
    public function getManufacturer()
    {
        return $this->Manufacturer;
    }
    /**
     * Set Manufacturer value
     * @uses \CustomerManagement\EnumType\EBSFireManufacturerEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\EBSFireManufacturerEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $manufacturer
     * @return \CustomerManagement\StructType\UpdateEBSFireDeviceInput
     */
    public function setManufacturer($manufacturer = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\EBSFireManufacturerEnum::valueIsValid($manufacturer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\EBSFireManufacturerEnum', is_array($manufacturer) ? implode(', ', $manufacturer) : var_export($manufacturer, true), implode(', ', \CustomerManagement\EnumType\EBSFireManufacturerEnum::getValidValues())), __LINE__);
        }
        $this->Manufacturer = $manufacturer;
        return $this;
    }
    /**
     * Get ManufacturerOther value
     * @return string|null
     */
    public function getManufacturerOther()
    {
        return $this->ManufacturerOther;
    }
    /**
     * Set ManufacturerOther value
     * @param string $manufacturerOther
     * @return \CustomerManagement\StructType\UpdateEBSFireDeviceInput
     */
    public function setManufacturerOther($manufacturerOther = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturerOther) && !is_string($manufacturerOther)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacturerOther, true), gettype($manufacturerOther)), __LINE__);
        }
        $this->ManufacturerOther = $manufacturerOther;
        return $this;
    }
    /**
     * Get ModelOther value
     * @return string|null
     */
    public function getModelOther()
    {
        return $this->ModelOther;
    }
    /**
     * Set ModelOther value
     * @param string $modelOther
     * @return \CustomerManagement\StructType\UpdateEBSFireDeviceInput
     */
    public function setModelOther($modelOther = null)
    {
        // validation for constraint: string
        if (!is_null($modelOther) && !is_string($modelOther)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modelOther, true), gettype($modelOther)), __LINE__);
        }
        $this->ModelOther = $modelOther;
        return $this;
    }
    /**
     * Get FirmwareVersion value
     * @return string|null
     */
    public function getFirmwareVersion()
    {
        return $this->FirmwareVersion;
    }
    /**
     * Set FirmwareVersion value
     * @param string $firmwareVersion
     * @return \CustomerManagement\StructType\UpdateEBSFireDeviceInput
     */
    public function setFirmwareVersion($firmwareVersion = null)
    {
        // validation for constraint: string
        if (!is_null($firmwareVersion) && !is_string($firmwareVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firmwareVersion, true), gettype($firmwareVersion)), __LINE__);
        }
        $this->FirmwareVersion = $firmwareVersion;
        return $this;
    }
}
