<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerBillingIssue StructType
 * @subpackage Structs
 */
class CustomerBillingIssue extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The DueAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DueAmount;
    /**
     * The DueDateUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $DueDateUtc;
    /**
     * The ShutOffDateUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ShutOffDateUtc;
    /**
     * The BillingIssues
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfCustomerBillingIssueTypeEnum
     */
    public $BillingIssues;
    /**
     * The CCLastFour
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CCLastFour;
    /**
     * Constructor method for CustomerBillingIssue
     * @uses CustomerBillingIssue::setCustomerId()
     * @uses CustomerBillingIssue::setDueAmount()
     * @uses CustomerBillingIssue::setDueDateUtc()
     * @uses CustomerBillingIssue::setShutOffDateUtc()
     * @uses CustomerBillingIssue::setBillingIssues()
     * @uses CustomerBillingIssue::setCCLastFour()
     * @param int $customerId
     * @param float $dueAmount
     * @param string $dueDateUtc
     * @param string $shutOffDateUtc
     * @param \CustomerManagement\ArrayType\ArrayOfCustomerBillingIssueTypeEnum $billingIssues
     * @param string $cCLastFour
     */
    public function __construct($customerId = null, $dueAmount = null, $dueDateUtc = null, $shutOffDateUtc = null, \CustomerManagement\ArrayType\ArrayOfCustomerBillingIssueTypeEnum $billingIssues = null, $cCLastFour = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setDueAmount($dueAmount)
            ->setDueDateUtc($dueDateUtc)
            ->setShutOffDateUtc($shutOffDateUtc)
            ->setBillingIssues($billingIssues)
            ->setCCLastFour($cCLastFour);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\CustomerBillingIssue
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get DueAmount value
     * @return float
     */
    public function getDueAmount()
    {
        return $this->DueAmount;
    }
    /**
     * Set DueAmount value
     * @param float $dueAmount
     * @return \CustomerManagement\StructType\CustomerBillingIssue
     */
    public function setDueAmount($dueAmount = null)
    {
        // validation for constraint: float
        if (!is_null($dueAmount) && !(is_float($dueAmount) || is_numeric($dueAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dueAmount, true), gettype($dueAmount)), __LINE__);
        }
        $this->DueAmount = $dueAmount;
        return $this;
    }
    /**
     * Get DueDateUtc value
     * @return string
     */
    public function getDueDateUtc()
    {
        return $this->DueDateUtc;
    }
    /**
     * Set DueDateUtc value
     * @param string $dueDateUtc
     * @return \CustomerManagement\StructType\CustomerBillingIssue
     */
    public function setDueDateUtc($dueDateUtc = null)
    {
        // validation for constraint: string
        if (!is_null($dueDateUtc) && !is_string($dueDateUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDateUtc, true), gettype($dueDateUtc)), __LINE__);
        }
        $this->DueDateUtc = $dueDateUtc;
        return $this;
    }
    /**
     * Get ShutOffDateUtc value
     * @return string
     */
    public function getShutOffDateUtc()
    {
        return $this->ShutOffDateUtc;
    }
    /**
     * Set ShutOffDateUtc value
     * @param string $shutOffDateUtc
     * @return \CustomerManagement\StructType\CustomerBillingIssue
     */
    public function setShutOffDateUtc($shutOffDateUtc = null)
    {
        // validation for constraint: string
        if (!is_null($shutOffDateUtc) && !is_string($shutOffDateUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shutOffDateUtc, true), gettype($shutOffDateUtc)), __LINE__);
        }
        $this->ShutOffDateUtc = $shutOffDateUtc;
        return $this;
    }
    /**
     * Get BillingIssues value
     * @return \CustomerManagement\ArrayType\ArrayOfCustomerBillingIssueTypeEnum|null
     */
    public function getBillingIssues()
    {
        return $this->BillingIssues;
    }
    /**
     * Set BillingIssues value
     * @param \CustomerManagement\ArrayType\ArrayOfCustomerBillingIssueTypeEnum $billingIssues
     * @return \CustomerManagement\StructType\CustomerBillingIssue
     */
    public function setBillingIssues(\CustomerManagement\ArrayType\ArrayOfCustomerBillingIssueTypeEnum $billingIssues = null)
    {
        $this->BillingIssues = $billingIssues;
        return $this;
    }
    /**
     * Get CCLastFour value
     * @return string|null
     */
    public function getCCLastFour()
    {
        return $this->CCLastFour;
    }
    /**
     * Set CCLastFour value
     * @param string $cCLastFour
     * @return \CustomerManagement\StructType\CustomerBillingIssue
     */
    public function setCCLastFour($cCLastFour = null)
    {
        // validation for constraint: string
        if (!is_null($cCLastFour) && !is_string($cCLastFour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cCLastFour, true), gettype($cCLastFour)), __LINE__);
        }
        $this->CCLastFour = $cCLastFour;
        return $this;
    }
}
