<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommitmentRelatedInfo StructType
 * @subpackage Structs
 */
class CommitmentRelatedInfo extends AbstractStructBase
{
    /**
     * The ExpectedInstallDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExpectedInstallDate;
    /**
     * The ExpectedPanelType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ExpectedPanelType;
    /**
     * The ExpectedNetwork
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ExpectedNetwork;
    /**
     * The ExpectedInstallerLogin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExpectedInstallerLogin;
    /**
     * The ModemSerialNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ModemSerialNumber;
    /**
     * Constructor method for CommitmentRelatedInfo
     * @uses CommitmentRelatedInfo::setExpectedInstallDate()
     * @uses CommitmentRelatedInfo::setExpectedPanelType()
     * @uses CommitmentRelatedInfo::setExpectedNetwork()
     * @uses CommitmentRelatedInfo::setExpectedInstallerLogin()
     * @uses CommitmentRelatedInfo::setModemSerialNumber()
     * @param string $expectedInstallDate
     * @param string $expectedPanelType
     * @param string $expectedNetwork
     * @param string $expectedInstallerLogin
     * @param string $modemSerialNumber
     */
    public function __construct($expectedInstallDate = null, $expectedPanelType = null, $expectedNetwork = null, $expectedInstallerLogin = null, $modemSerialNumber = null)
    {
        $this
            ->setExpectedInstallDate($expectedInstallDate)
            ->setExpectedPanelType($expectedPanelType)
            ->setExpectedNetwork($expectedNetwork)
            ->setExpectedInstallerLogin($expectedInstallerLogin)
            ->setModemSerialNumber($modemSerialNumber);
    }
    /**
     * Get ExpectedInstallDate value
     * @return string
     */
    public function getExpectedInstallDate()
    {
        return $this->ExpectedInstallDate;
    }
    /**
     * Set ExpectedInstallDate value
     * @param string $expectedInstallDate
     * @return \CustomerManagement\StructType\CommitmentRelatedInfo
     */
    public function setExpectedInstallDate($expectedInstallDate = null)
    {
        // validation for constraint: string
        if (!is_null($expectedInstallDate) && !is_string($expectedInstallDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expectedInstallDate)), __LINE__);
        }
        $this->ExpectedInstallDate = $expectedInstallDate;
        return $this;
    }
    /**
     * Get ExpectedPanelType value
     * @return string
     */
    public function getExpectedPanelType()
    {
        return $this->ExpectedPanelType;
    }
    /**
     * Set ExpectedPanelType value
     * @uses \CustomerManagement\EnumType\PanelTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\PanelTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $expectedPanelType
     * @return \CustomerManagement\StructType\CommitmentRelatedInfo
     */
    public function setExpectedPanelType($expectedPanelType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\PanelTypeEnum::valueIsValid($expectedPanelType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $expectedPanelType, implode(', ', \CustomerManagement\EnumType\PanelTypeEnum::getValidValues())), __LINE__);
        }
        $this->ExpectedPanelType = $expectedPanelType;
        return $this;
    }
    /**
     * Get ExpectedNetwork value
     * @return string
     */
    public function getExpectedNetwork()
    {
        return $this->ExpectedNetwork;
    }
    /**
     * Set ExpectedNetwork value
     * @uses \CustomerManagement\EnumType\NetworkEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\NetworkEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $expectedNetwork
     * @return \CustomerManagement\StructType\CommitmentRelatedInfo
     */
    public function setExpectedNetwork($expectedNetwork = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\NetworkEnum::valueIsValid($expectedNetwork)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $expectedNetwork, implode(', ', \CustomerManagement\EnumType\NetworkEnum::getValidValues())), __LINE__);
        }
        $this->ExpectedNetwork = $expectedNetwork;
        return $this;
    }
    /**
     * Get ExpectedInstallerLogin value
     * @return string|null
     */
    public function getExpectedInstallerLogin()
    {
        return $this->ExpectedInstallerLogin;
    }
    /**
     * Set ExpectedInstallerLogin value
     * @param string $expectedInstallerLogin
     * @return \CustomerManagement\StructType\CommitmentRelatedInfo
     */
    public function setExpectedInstallerLogin($expectedInstallerLogin = null)
    {
        // validation for constraint: string
        if (!is_null($expectedInstallerLogin) && !is_string($expectedInstallerLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expectedInstallerLogin)), __LINE__);
        }
        $this->ExpectedInstallerLogin = $expectedInstallerLogin;
        return $this;
    }
    /**
     * Get ModemSerialNumber value
     * @return string|null
     */
    public function getModemSerialNumber()
    {
        return $this->ModemSerialNumber;
    }
    /**
     * Set ModemSerialNumber value
     * @param string $modemSerialNumber
     * @return \CustomerManagement\StructType\CommitmentRelatedInfo
     */
    public function setModemSerialNumber($modemSerialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($modemSerialNumber) && !is_string($modemSerialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modemSerialNumber)), __LINE__);
        }
        $this->ModemSerialNumber = $modemSerialNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\CommitmentRelatedInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
