<?php

namespace CustomerManagement\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Terminate ServiceType
 * @subpackage Services
 */
class Terminate extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \CustomerManagement\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\CustomerManagement\StructType\Authentication $authentication, $nameSpace = 'http://www.alarm.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named TerminateCustomer
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Terminate an Alarm.com customer account. The serial number will no longer be associated to an account.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\TerminateCustomer $parameters
     * @return \CustomerManagement\StructType\TerminateCustomerResponse|bool
     */
    public function TerminateCustomer(\CustomerManagement\StructType\TerminateCustomer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TerminateCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TerminateCustomer_V2
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Terminate an Alarm.com customer account and optionally set a termination reason and/or send a termination message to the panel and/or master reset the panel (IQ only). The termination message contains contact information to easily
     * reactivate the account. The serial number will no longer be associated to an account.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\TerminateCustomer_V2 $parameters
     * @return \CustomerManagement\StructType\TerminateCustomer_V2Response|bool
     */
    public function TerminateCustomer_V2(\CustomerManagement\StructType\TerminateCustomer_V2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TerminateCustomer_V2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CustomerManagement\StructType\TerminateCustomerResponse|\CustomerManagement\StructType\TerminateCustomer_V2Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
