<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetImageSensorSettingsInput StructType
 * @subpackage Structs
 */
class SetImageSensorSettingsInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The DeviceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeviceId;
    /**
     * The Sensitivity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Sensitivity;
    /**
     * The EnableAutoZoom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $EnableAutoZoom;
    /**
     * The EnableLEDMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $EnableLEDMode;
    /**
     * The EnableExtendedRangeOnDaughterboard
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $EnableExtendedRangeOnDaughterboard;
    /**
     * Constructor method for SetImageSensorSettingsInput
     * @uses SetImageSensorSettingsInput::setCustomerId()
     * @uses SetImageSensorSettingsInput::setDeviceId()
     * @uses SetImageSensorSettingsInput::setSensitivity()
     * @uses SetImageSensorSettingsInput::setEnableAutoZoom()
     * @uses SetImageSensorSettingsInput::setEnableLEDMode()
     * @uses SetImageSensorSettingsInput::setEnableExtendedRangeOnDaughterboard()
     * @param int $customerId
     * @param int $deviceId
     * @param string $sensitivity
     * @param bool $enableAutoZoom
     * @param bool $enableLEDMode
     * @param bool $enableExtendedRangeOnDaughterboard
     */
    public function __construct($customerId = null, $deviceId = null, $sensitivity = null, $enableAutoZoom = null, $enableLEDMode = null, $enableExtendedRangeOnDaughterboard = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setDeviceId($deviceId)
            ->setSensitivity($sensitivity)
            ->setEnableAutoZoom($enableAutoZoom)
            ->setEnableLEDMode($enableLEDMode)
            ->setEnableExtendedRangeOnDaughterboard($enableExtendedRangeOnDaughterboard);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\SetImageSensorSettingsInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get DeviceId value
     * @return int
     */
    public function getDeviceId()
    {
        return $this->DeviceId;
    }
    /**
     * Set DeviceId value
     * @param int $deviceId
     * @return \CustomerManagement\StructType\SetImageSensorSettingsInput
     */
    public function setDeviceId($deviceId = null)
    {
        // validation for constraint: int
        if (!is_null($deviceId) && !is_numeric($deviceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($deviceId)), __LINE__);
        }
        $this->DeviceId = $deviceId;
        return $this;
    }
    /**
     * Get Sensitivity value
     * @return string
     */
    public function getSensitivity()
    {
        return $this->Sensitivity;
    }
    /**
     * Set Sensitivity value
     * @uses \CustomerManagement\EnumType\PirModeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\PirModeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sensitivity
     * @return \CustomerManagement\StructType\SetImageSensorSettingsInput
     */
    public function setSensitivity($sensitivity = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\PirModeEnum::valueIsValid($sensitivity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sensitivity, implode(', ', \CustomerManagement\EnumType\PirModeEnum::getValidValues())), __LINE__);
        }
        $this->Sensitivity = $sensitivity;
        return $this;
    }
    /**
     * Get EnableAutoZoom value
     * @return bool
     */
    public function getEnableAutoZoom()
    {
        return $this->EnableAutoZoom;
    }
    /**
     * Set EnableAutoZoom value
     * @param bool $enableAutoZoom
     * @return \CustomerManagement\StructType\SetImageSensorSettingsInput
     */
    public function setEnableAutoZoom($enableAutoZoom = null)
    {
        $this->EnableAutoZoom = $enableAutoZoom;
        return $this;
    }
    /**
     * Get EnableLEDMode value
     * @return bool
     */
    public function getEnableLEDMode()
    {
        return $this->EnableLEDMode;
    }
    /**
     * Set EnableLEDMode value
     * @param bool $enableLEDMode
     * @return \CustomerManagement\StructType\SetImageSensorSettingsInput
     */
    public function setEnableLEDMode($enableLEDMode = null)
    {
        $this->EnableLEDMode = $enableLEDMode;
        return $this;
    }
    /**
     * Get EnableExtendedRangeOnDaughterboard value
     * @return bool
     */
    public function getEnableExtendedRangeOnDaughterboard()
    {
        return $this->EnableExtendedRangeOnDaughterboard;
    }
    /**
     * Set EnableExtendedRangeOnDaughterboard value
     * @param bool $enableExtendedRangeOnDaughterboard
     * @return \CustomerManagement\StructType\SetImageSensorSettingsInput
     */
    public function setEnableExtendedRangeOnDaughterboard($enableExtendedRangeOnDaughterboard = null)
    {
        $this->EnableExtendedRangeOnDaughterboard = $enableExtendedRangeOnDaughterboard;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\SetImageSensorSettingsInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
