<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddFobFor2GigInput StructType
 * @subpackage Structs
 */
class AddFobFor2GigInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The FobId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FobId;
    /**
     * The FobUsed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $FobUsed;
    /**
     * The KeyTwoCanDisarm
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $KeyTwoCanDisarm;
    /**
     * The ArmNoDelay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ArmNoDelay;
    /**
     * The EquipmentCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EquipmentCode;
    /**
     * The SerialNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SerialNumber;
    /**
     * The EquipmentAge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EquipmentAge;
    /**
     * The EmergencyKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmergencyKey;
    /**
     * The VoiceDescriptors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfString
     */
    public $VoiceDescriptors;
    /**
     * The KeyFourOutput
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KeyFourOutput;
    /**
     * Constructor method for AddFobFor2GigInput
     * @uses AddFobFor2GigInput::setCustomerId()
     * @uses AddFobFor2GigInput::setFobId()
     * @uses AddFobFor2GigInput::setFobUsed()
     * @uses AddFobFor2GigInput::setKeyTwoCanDisarm()
     * @uses AddFobFor2GigInput::setArmNoDelay()
     * @uses AddFobFor2GigInput::setEquipmentCode()
     * @uses AddFobFor2GigInput::setSerialNumber()
     * @uses AddFobFor2GigInput::setEquipmentAge()
     * @uses AddFobFor2GigInput::setEmergencyKey()
     * @uses AddFobFor2GigInput::setVoiceDescriptors()
     * @uses AddFobFor2GigInput::setKeyFourOutput()
     * @param int $customerId
     * @param int $fobId
     * @param bool $fobUsed
     * @param bool $keyTwoCanDisarm
     * @param bool $armNoDelay
     * @param string $equipmentCode
     * @param string $serialNumber
     * @param string $equipmentAge
     * @param string $emergencyKey
     * @param \CustomerManagement\ArrayType\ArrayOfString $voiceDescriptors
     * @param string $keyFourOutput
     */
    public function __construct($customerId = null, $fobId = null, $fobUsed = null, $keyTwoCanDisarm = null, $armNoDelay = null, $equipmentCode = null, $serialNumber = null, $equipmentAge = null, $emergencyKey = null, \CustomerManagement\ArrayType\ArrayOfString $voiceDescriptors = null, $keyFourOutput = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setFobId($fobId)
            ->setFobUsed($fobUsed)
            ->setKeyTwoCanDisarm($keyTwoCanDisarm)
            ->setArmNoDelay($armNoDelay)
            ->setEquipmentCode($equipmentCode)
            ->setSerialNumber($serialNumber)
            ->setEquipmentAge($equipmentAge)
            ->setEmergencyKey($emergencyKey)
            ->setVoiceDescriptors($voiceDescriptors)
            ->setKeyFourOutput($keyFourOutput);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\AddFobFor2GigInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !is_numeric($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get FobId value
     * @return int
     */
    public function getFobId()
    {
        return $this->FobId;
    }
    /**
     * Set FobId value
     * @param int $fobId
     * @return \CustomerManagement\StructType\AddFobFor2GigInput
     */
    public function setFobId($fobId = null)
    {
        // validation for constraint: int
        if (!is_null($fobId) && !is_numeric($fobId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fobId)), __LINE__);
        }
        $this->FobId = $fobId;
        return $this;
    }
    /**
     * Get FobUsed value
     * @return bool
     */
    public function getFobUsed()
    {
        return $this->FobUsed;
    }
    /**
     * Set FobUsed value
     * @param bool $fobUsed
     * @return \CustomerManagement\StructType\AddFobFor2GigInput
     */
    public function setFobUsed($fobUsed = null)
    {
        $this->FobUsed = $fobUsed;
        return $this;
    }
    /**
     * Get KeyTwoCanDisarm value
     * @return bool
     */
    public function getKeyTwoCanDisarm()
    {
        return $this->KeyTwoCanDisarm;
    }
    /**
     * Set KeyTwoCanDisarm value
     * @param bool $keyTwoCanDisarm
     * @return \CustomerManagement\StructType\AddFobFor2GigInput
     */
    public function setKeyTwoCanDisarm($keyTwoCanDisarm = null)
    {
        $this->KeyTwoCanDisarm = $keyTwoCanDisarm;
        return $this;
    }
    /**
     * Get ArmNoDelay value
     * @return bool
     */
    public function getArmNoDelay()
    {
        return $this->ArmNoDelay;
    }
    /**
     * Set ArmNoDelay value
     * @param bool $armNoDelay
     * @return \CustomerManagement\StructType\AddFobFor2GigInput
     */
    public function setArmNoDelay($armNoDelay = null)
    {
        $this->ArmNoDelay = $armNoDelay;
        return $this;
    }
    /**
     * Get EquipmentCode value
     * @return string|null
     */
    public function getEquipmentCode()
    {
        return $this->EquipmentCode;
    }
    /**
     * Set EquipmentCode value
     * @param string $equipmentCode
     * @return \CustomerManagement\StructType\AddFobFor2GigInput
     */
    public function setEquipmentCode($equipmentCode = null)
    {
        // validation for constraint: string
        if (!is_null($equipmentCode) && !is_string($equipmentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($equipmentCode)), __LINE__);
        }
        $this->EquipmentCode = $equipmentCode;
        return $this;
    }
    /**
     * Get SerialNumber value
     * @return string|null
     */
    public function getSerialNumber()
    {
        return $this->SerialNumber;
    }
    /**
     * Set SerialNumber value
     * @param string $serialNumber
     * @return \CustomerManagement\StructType\AddFobFor2GigInput
     */
    public function setSerialNumber($serialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumber) && !is_string($serialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serialNumber)), __LINE__);
        }
        $this->SerialNumber = $serialNumber;
        return $this;
    }
    /**
     * Get EquipmentAge value
     * @return string|null
     */
    public function getEquipmentAge()
    {
        return $this->EquipmentAge;
    }
    /**
     * Set EquipmentAge value
     * @param string $equipmentAge
     * @return \CustomerManagement\StructType\AddFobFor2GigInput
     */
    public function setEquipmentAge($equipmentAge = null)
    {
        // validation for constraint: string
        if (!is_null($equipmentAge) && !is_string($equipmentAge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($equipmentAge)), __LINE__);
        }
        $this->EquipmentAge = $equipmentAge;
        return $this;
    }
    /**
     * Get EmergencyKey value
     * @return string|null
     */
    public function getEmergencyKey()
    {
        return $this->EmergencyKey;
    }
    /**
     * Set EmergencyKey value
     * @param string $emergencyKey
     * @return \CustomerManagement\StructType\AddFobFor2GigInput
     */
    public function setEmergencyKey($emergencyKey = null)
    {
        // validation for constraint: string
        if (!is_null($emergencyKey) && !is_string($emergencyKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emergencyKey)), __LINE__);
        }
        $this->EmergencyKey = $emergencyKey;
        return $this;
    }
    /**
     * Get VoiceDescriptors value
     * @return \CustomerManagement\ArrayType\ArrayOfString|null
     */
    public function getVoiceDescriptors()
    {
        return $this->VoiceDescriptors;
    }
    /**
     * Set VoiceDescriptors value
     * @param \CustomerManagement\ArrayType\ArrayOfString $voiceDescriptors
     * @return \CustomerManagement\StructType\AddFobFor2GigInput
     */
    public function setVoiceDescriptors(\CustomerManagement\ArrayType\ArrayOfString $voiceDescriptors = null)
    {
        $this->VoiceDescriptors = $voiceDescriptors;
        return $this;
    }
    /**
     * Get KeyFourOutput value
     * @return string|null
     */
    public function getKeyFourOutput()
    {
        return $this->KeyFourOutput;
    }
    /**
     * Set KeyFourOutput value
     * @param string $keyFourOutput
     * @return \CustomerManagement\StructType\AddFobFor2GigInput
     */
    public function setKeyFourOutput($keyFourOutput = null)
    {
        // validation for constraint: string
        if (!is_null($keyFourOutput) && !is_string($keyFourOutput)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($keyFourOutput)), __LINE__);
        }
        $this->KeyFourOutput = $keyFourOutput;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CustomerManagement\StructType\AddFobFor2GigInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
