<?php

namespace CustomerManagement\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \CustomerManagement\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\CustomerManagement\StructType\Authentication $authentication, $nameSpace = 'http://www.alarm.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named UpdateSensorDevice
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Only use this method to update the Sensor ID or the Sensor Name. To update sensor name: use SensorNamePrefix for the NX panel; SensorName for Qolsys; and Base, Suffix, Token3, and Token4 for XT/XTi. Please call GetEligibleSensorNames
     * to get the valid descriptors for XT/XTi. This method will update the name in the control panel and on the website.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateSensorDevice $parameters
     * @return \CustomerManagement\StructType\UpdateSensorDeviceResponse|bool
     */
    public function UpdateSensorDevice(\CustomerManagement\StructType\UpdateSensorDevice $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateSensorDevice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateSensorTypeIDQolsys
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Update sensor type for Qolsys Panel. You may wish to call GetDeviceList or GetFullEquipmentList first to get the current settings.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateSensorTypeIDQolsys $parameters
     * @return \CustomerManagement\StructType\UpdateSensorTypeIDQolsysResponse|bool
     */
    public function UpdateSensorTypeIDQolsys(\CustomerManagement\StructType\UpdateSensorTypeIDQolsys $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateSensorTypeIDQolsys($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateSensorGroup
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Update sensor group. You may wish to call GetDeviceList or GetFullEquipmentList first to get the current settings.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateSensorGroup $parameters
     * @return \CustomerManagement\StructType\UpdateSensorGroupResponse|bool
     */
    public function UpdateSensorGroup(\CustomerManagement\StructType\UpdateSensorGroup $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateSensorGroup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateSensorVoiceDescriptors2Gig
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: This will update 2Gig sensornames in the control panel and website. Please call AddSensorGetSensorVoiceDescriptors to get the valid VoiceDescriptors for this method.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateSensorVoiceDescriptors2Gig $parameters
     * @return \CustomerManagement\StructType\UpdateSensorVoiceDescriptors2GigResponse|bool
     */
    public function UpdateSensorVoiceDescriptors2Gig(\CustomerManagement\StructType\UpdateSensorVoiceDescriptors2Gig $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateSensorVoiceDescriptors2Gig($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdatePanelCommunicationSetting
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Change panel communication setting.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdatePanelCommunicationSetting $parameters
     * @return \CustomerManagement\StructType\UpdatePanelCommunicationSettingResponse|bool
     */
    public function UpdatePanelCommunicationSetting(\CustomerManagement\StructType\UpdatePanelCommunicationSetting $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdatePanelCommunicationSetting($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateRoles
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Update a login's roles.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateRoles $parameters
     * @return \CustomerManagement\StructType\UpdateRolesResponse|bool
     */
    public function UpdateRoles(\CustomerManagement\StructType\UpdateRoles $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateRoles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCustomerAddress
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateCustomerAddress $parameters
     * @return \CustomerManagement\StructType\UpdateCustomerAddressResponse|bool
     */
    public function UpdateCustomerAddress(\CustomerManagement\StructType\UpdateCustomerAddress $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateCustomerAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCustomerPassword
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateCustomerPassword $parameters
     * @return \CustomerManagement\StructType\UpdateCustomerPasswordResponse|bool
     */
    public function UpdateCustomerPassword(\CustomerManagement\StructType\UpdateCustomerPassword $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateCustomerPassword($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCustomerLogin
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateCustomerLogin $parameters
     * @return \CustomerManagement\StructType\UpdateCustomerLoginResponse|bool
     */
    public function UpdateCustomerLogin(\CustomerManagement\StructType\UpdateCustomerLogin $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateCustomerLogin($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * UpdateAuthenticationProviderLoginName
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateAuthenticationProviderLoginName $parameters
     * @return \CustomerManagement\StructType\UpdateAuthenticationProviderLoginNameResponse|bool
     */
    public function UpdateAuthenticationProviderLoginName(\CustomerManagement\StructType\UpdateAuthenticationProviderLoginName $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateAuthenticationProviderLoginName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateLoginPassword
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Change the password for a login.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateLoginPassword $parameters
     * @return \CustomerManagement\StructType\UpdateLoginPasswordResponse|bool
     */
    public function UpdateLoginPassword(\CustomerManagement\StructType\UpdateLoginPassword $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateLoginPassword($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateLoginPasswordWithoutPassword
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Change the password for a login without the old password. Prior to calling this method you will need to validate the customers security question. Please contact your sales rep before implementing this method.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateLoginPasswordWithoutPassword $parameters
     * @return \CustomerManagement\StructType\UpdateLoginPasswordWithoutPasswordResponse|bool
     */
    public function UpdateLoginPasswordWithoutPassword(\CustomerManagement\StructType\UpdateLoginPasswordWithoutPassword $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateLoginPasswordWithoutPassword($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCustomerBranch
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Move a customer to a different branch.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateCustomerBranch $parameters
     * @return \CustomerManagement\StructType\UpdateCustomerBranchResponse|bool
     */
    public function UpdateCustomerBranch(\CustomerManagement\StructType\UpdateCustomerBranch $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateCustomerBranch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateDealerCustomerId
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Update the dealer customer id for a customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateDealerCustomerId $parameters
     * @return \CustomerManagement\StructType\UpdateDealerCustomerIdResponse|bool
     */
    public function UpdateDealerCustomerId(\CustomerManagement\StructType\UpdateDealerCustomerId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateDealerCustomerId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateEnrolledInMaintenance
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Update whether the customer is enrolled in a maintenance plan.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateEnrolledInMaintenance $parameters
     * @return \CustomerManagement\StructType\UpdateEnrolledInMaintenanceResponse|bool
     */
    public function UpdateEnrolledInMaintenance(\CustomerManagement\StructType\UpdateEnrolledInMaintenance $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateEnrolledInMaintenance($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCentralStationInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Updates the central station info for a customer. You may wish to call GetCustomerInfo first to get the current settings.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateCentralStationInfo $parameters
     * @return \CustomerManagement\StructType\UpdateCentralStationInfoResponse|bool
     */
    public function UpdateCentralStationInfo(\CustomerManagement\StructType\UpdateCentralStationInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateCentralStationInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdatePrimaryEmail
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Updates the primary email address for the customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdatePrimaryEmail $parameters
     * @return \CustomerManagement\StructType\UpdatePrimaryEmailResponse|bool
     */
    public function UpdatePrimaryEmail(\CustomerManagement\StructType\UpdatePrimaryEmail $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdatePrimaryEmail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdatePrimaryPhone
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Updates the primary phone number for the customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdatePrimaryPhone $parameters
     * @return \CustomerManagement\StructType\UpdatePrimaryPhoneResponse|bool
     */
    public function UpdatePrimaryPhone(\CustomerManagement\StructType\UpdatePrimaryPhone $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdatePrimaryPhone($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCameraSettings
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Updates the wireless settings for a camera.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateCameraSettings $parameters
     * @return \CustomerManagement\StructType\UpdateCameraSettingsResponse|bool
     */
    public function UpdateCameraSettings(\CustomerManagement\StructType\UpdateCameraSettings $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateCameraSettings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateNotifications
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Updates the recipients for image sensor notifications. Note: if there are existing subscriptions, this adds to them.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateNotifications $parameters
     * @return \CustomerManagement\StructType\UpdateNotificationsResponse|bool
     */
    public function UpdateNotifications(\CustomerManagement\StructType\UpdateNotifications $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateNotifications($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCustomerSecurityQuestion
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Updates the security question for a customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateCustomerSecurityQuestion $parameters
     * @return \CustomerManagement\StructType\UpdateCustomerSecurityQuestionResponse|bool
     */
    public function UpdateCustomerSecurityQuestion(\CustomerManagement\StructType\UpdateCustomerSecurityQuestion $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateCustomerSecurityQuestion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCustomDevices
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Add or update custom devices for a customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateCustomDevices $parameters
     * @return \CustomerManagement\StructType\UpdateCustomDevicesResponse|bool
     */
    public function UpdateCustomDevices(\CustomerManagement\StructType\UpdateCustomDevices $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateCustomDevices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * UpdateCustomerEnergyProgramEnrollment
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Enroll or deenroll a customer from an energy saving/demand response program.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateCustomerEnergyProgramEnrollment $parameters
     * @return \CustomerManagement\StructType\UpdateCustomerEnergyProgramEnrollmentResponse|bool
     */
    public function UpdateCustomerEnergyProgramEnrollment(\CustomerManagement\StructType\UpdateCustomerEnergyProgramEnrollment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateCustomerEnergyProgramEnrollment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateUnitDescription
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Update customer unit description.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateUnitDescription $parameters
     * @return \CustomerManagement\StructType\UpdateUnitDescriptionResponse|bool
     */
    public function UpdateUnitDescription(\CustomerManagement\StructType\UpdateUnitDescription $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateUnitDescription($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CustomerManagement\StructType\UpdateAuthenticationProviderLoginNameResponse|\CustomerManagement\StructType\UpdateCameraSettingsResponse|\CustomerManagement\StructType\UpdateCentralStationInfoResponse|\CustomerManagement\StructType\UpdateCustomDevicesResponse|\CustomerManagement\StructType\UpdateCustomerAddressResponse|\CustomerManagement\StructType\UpdateCustomerBranchResponse|\CustomerManagement\StructType\UpdateCustomerEnergyProgramEnrollmentResponse|\CustomerManagement\StructType\UpdateCustomerLoginResponse|\CustomerManagement\StructType\UpdateCustomerPasswordResponse|\CustomerManagement\StructType\UpdateCustomerSecurityQuestionResponse|\CustomerManagement\StructType\UpdateDealerCustomerIdResponse|\CustomerManagement\StructType\UpdateEnrolledInMaintenanceResponse|\CustomerManagement\StructType\UpdateLoginPasswordResponse|\CustomerManagement\StructType\UpdateLoginPasswordWithoutPasswordResponse|\CustomerManagement\StructType\UpdateNotificationsResponse|\CustomerManagement\StructType\UpdatePanelCommunicationSettingResponse|\CustomerManagement\StructType\UpdatePrimaryEmailResponse|\CustomerManagement\StructType\UpdatePrimaryPhoneResponse|\CustomerManagement\StructType\UpdateRolesResponse|\CustomerManagement\StructType\UpdateSensorDeviceResponse|\CustomerManagement\StructType\UpdateSensorGroupResponse|\CustomerManagement\StructType\UpdateSensorTypeIDQolsysResponse|\CustomerManagement\StructType\UpdateSensorVoiceDescriptors2GigResponse|\CustomerManagement\StructType\UpdateUnitDescriptionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
