<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for CultureEnum EnumType
 * @subpackage Enumerations
 */
class CultureEnum
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'English_US'
     * @return string 'English_US'
     */
    const VALUE_ENGLISH_US = 'English_US';
    /**
     * Constant for value 'French_Canada'
     * @return string 'French_Canada'
     */
    const VALUE_FRENCH_CANADA = 'French_Canada';
    /**
     * Constant for value 'Spanish_US'
     * @return string 'Spanish_US'
     */
    const VALUE_SPANISH_US = 'Spanish_US';
    /**
     * Constant for value 'Portuguese_Brazil'
     * @return string 'Portuguese_Brazil'
     */
    const VALUE_PORTUGUESE_BRAZIL = 'Portuguese_Brazil';
    /**
     * Constant for value 'Spanish_Mexico'
     * @return string 'Spanish_Mexico'
     */
    const VALUE_SPANISH_MEXICO = 'Spanish_Mexico';
    /**
     * Constant for value 'English_SouthAfrica'
     * @return string 'English_SouthAfrica'
     */
    const VALUE_ENGLISH_SOUTH_AFRICA = 'English_SouthAfrica';
    /**
     * Constant for value 'Spanish_Chile'
     * @return string 'Spanish_Chile'
     */
    const VALUE_SPANISH_CHILE = 'Spanish_Chile';
    /**
     * Constant for value 'Spanish_Argentina'
     * @return string 'Spanish_Argentina'
     */
    const VALUE_SPANISH_ARGENTINA = 'Spanish_Argentina';
    /**
     * Constant for value 'Spanish_Colombia'
     * @return string 'Spanish_Colombia'
     */
    const VALUE_SPANISH_COLOMBIA = 'Spanish_Colombia';
    /**
     * Constant for value 'English_NewZealand'
     * @return string 'English_NewZealand'
     */
    const VALUE_ENGLISH_NEW_ZEALAND = 'English_NewZealand';
    /**
     * Constant for value 'Spanish_Panama'
     * @return string 'Spanish_Panama'
     */
    const VALUE_SPANISH_PANAMA = 'Spanish_Panama';
    /**
     * Constant for value 'Spanish_CostaRica'
     * @return string 'Spanish_CostaRica'
     */
    const VALUE_SPANISH_COSTA_RICA = 'Spanish_CostaRica';
    /**
     * Constant for value 'Spanish_Venezuela'
     * @return string 'Spanish_Venezuela'
     */
    const VALUE_SPANISH_VENEZUELA = 'Spanish_Venezuela';
    /**
     * Constant for value 'English_TrinidadTobago'
     * @return string 'English_TrinidadTobago'
     */
    const VALUE_ENGLISH_TRINIDAD_TOBAGO = 'English_TrinidadTobago';
    /**
     * Constant for value 'Spanish_Ecuador'
     * @return string 'Spanish_Ecuador'
     */
    const VALUE_SPANISH_ECUADOR = 'Spanish_Ecuador';
    /**
     * Constant for value 'Turkish_Turkey'
     * @return string 'Turkish_Turkey'
     */
    const VALUE_TURKISH_TURKEY = 'Turkish_Turkey';
    /**
     * Constant for value 'English_Jamaica'
     * @return string 'English_Jamaica'
     */
    const VALUE_ENGLISH_JAMAICA = 'English_Jamaica';
    /**
     * Constant for value 'English_Caribbean'
     * @return string 'English_Caribbean'
     */
    const VALUE_ENGLISH_CARIBBEAN = 'English_Caribbean';
    /**
     * Constant for value 'English_UK'
     * @return string 'English_UK'
     */
    const VALUE_ENGLISH_UK = 'English_UK';
    /**
     * Constant for value 'SpanishSpain'
     * @return string 'SpanishSpain'
     */
    const VALUE_SPANISH_SPAIN = 'SpanishSpain';
    /**
     * Constant for value 'DutchNetherlands'
     * @return string 'DutchNetherlands'
     */
    const VALUE_DUTCH_NETHERLANDS = 'DutchNetherlands';
    /**
     * Constant for value 'FrenchFrance'
     * @return string 'FrenchFrance'
     */
    const VALUE_FRENCH_FRANCE = 'FrenchFrance';
    /**
     * Constant for value 'NorwegianBokmalNorway'
     * @return string 'NorwegianBokmalNorway'
     */
    const VALUE_NORWEGIAN_BOKMAL_NORWAY = 'NorwegianBokmalNorway';
    /**
     * Constant for value 'PortuguesePortugal'
     * @return string 'PortuguesePortugal'
     */
    const VALUE_PORTUGUESE_PORTUGAL = 'PortuguesePortugal';
    /**
     * Constant for value 'SwedishSweden'
     * @return string 'SwedishSweden'
     */
    const VALUE_SWEDISH_SWEDEN = 'SwedishSweden';
    /**
     * Constant for value 'EnglishCanada'
     * @return string 'EnglishCanada'
     */
    const VALUE_ENGLISH_CANADA = 'EnglishCanada';
    /**
     * Constant for value 'TestNumeric'
     * @return string 'TestNumeric'
     */
    const VALUE_TEST_NUMERIC = 'TestNumeric';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_ENGLISH_US
     * @uses self::VALUE_FRENCH_CANADA
     * @uses self::VALUE_SPANISH_US
     * @uses self::VALUE_PORTUGUESE_BRAZIL
     * @uses self::VALUE_SPANISH_MEXICO
     * @uses self::VALUE_ENGLISH_SOUTH_AFRICA
     * @uses self::VALUE_SPANISH_CHILE
     * @uses self::VALUE_SPANISH_ARGENTINA
     * @uses self::VALUE_SPANISH_COLOMBIA
     * @uses self::VALUE_ENGLISH_NEW_ZEALAND
     * @uses self::VALUE_SPANISH_PANAMA
     * @uses self::VALUE_SPANISH_COSTA_RICA
     * @uses self::VALUE_SPANISH_VENEZUELA
     * @uses self::VALUE_ENGLISH_TRINIDAD_TOBAGO
     * @uses self::VALUE_SPANISH_ECUADOR
     * @uses self::VALUE_TURKISH_TURKEY
     * @uses self::VALUE_ENGLISH_JAMAICA
     * @uses self::VALUE_ENGLISH_CARIBBEAN
     * @uses self::VALUE_ENGLISH_UK
     * @uses self::VALUE_SPANISH_SPAIN
     * @uses self::VALUE_DUTCH_NETHERLANDS
     * @uses self::VALUE_FRENCH_FRANCE
     * @uses self::VALUE_NORWEGIAN_BOKMAL_NORWAY
     * @uses self::VALUE_PORTUGUESE_PORTUGAL
     * @uses self::VALUE_SWEDISH_SWEDEN
     * @uses self::VALUE_ENGLISH_CANADA
     * @uses self::VALUE_TEST_NUMERIC
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_ENGLISH_US,
            self::VALUE_FRENCH_CANADA,
            self::VALUE_SPANISH_US,
            self::VALUE_PORTUGUESE_BRAZIL,
            self::VALUE_SPANISH_MEXICO,
            self::VALUE_ENGLISH_SOUTH_AFRICA,
            self::VALUE_SPANISH_CHILE,
            self::VALUE_SPANISH_ARGENTINA,
            self::VALUE_SPANISH_COLOMBIA,
            self::VALUE_ENGLISH_NEW_ZEALAND,
            self::VALUE_SPANISH_PANAMA,
            self::VALUE_SPANISH_COSTA_RICA,
            self::VALUE_SPANISH_VENEZUELA,
            self::VALUE_ENGLISH_TRINIDAD_TOBAGO,
            self::VALUE_SPANISH_ECUADOR,
            self::VALUE_TURKISH_TURKEY,
            self::VALUE_ENGLISH_JAMAICA,
            self::VALUE_ENGLISH_CARIBBEAN,
            self::VALUE_ENGLISH_UK,
            self::VALUE_SPANISH_SPAIN,
            self::VALUE_DUTCH_NETHERLANDS,
            self::VALUE_FRENCH_FRANCE,
            self::VALUE_NORWEGIAN_BOKMAL_NORWAY,
            self::VALUE_PORTUGUESE_PORTUGAL,
            self::VALUE_SWEDISH_SWEDEN,
            self::VALUE_ENGLISH_CANADA,
            self::VALUE_TEST_NUMERIC,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
