<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LookupCustomerId StructType
 * @subpackage Structs
 */
class LookupCustomerId extends AbstractStructBase
{
    /**
     * The receiverPhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $receiverPhoneNumber;
    /**
     * The acctNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $acctNumber;
    /**
     * Constructor method for LookupCustomerId
     * @uses LookupCustomerId::setReceiverPhoneNumber()
     * @uses LookupCustomerId::setAcctNumber()
     * @param string $receiverPhoneNumber
     * @param string $acctNumber
     */
    public function __construct($receiverPhoneNumber = null, $acctNumber = null)
    {
        $this
            ->setReceiverPhoneNumber($receiverPhoneNumber)
            ->setAcctNumber($acctNumber);
    }
    /**
     * Get receiverPhoneNumber value
     * @return string|null
     */
    public function getReceiverPhoneNumber()
    {
        return $this->receiverPhoneNumber;
    }
    /**
     * Set receiverPhoneNumber value
     * @param string $receiverPhoneNumber
     * @return \CustomerManagement\StructType\LookupCustomerId
     */
    public function setReceiverPhoneNumber($receiverPhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($receiverPhoneNumber) && !is_string($receiverPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiverPhoneNumber, true), gettype($receiverPhoneNumber)), __LINE__);
        }
        $this->receiverPhoneNumber = $receiverPhoneNumber;
        return $this;
    }
    /**
     * Get acctNumber value
     * @return string|null
     */
    public function getAcctNumber()
    {
        return $this->acctNumber;
    }
    /**
     * Set acctNumber value
     * @param string $acctNumber
     * @return \CustomerManagement\StructType\LookupCustomerId
     */
    public function setAcctNumber($acctNumber = null)
    {
        // validation for constraint: string
        if (!is_null($acctNumber) && !is_string($acctNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acctNumber, true), gettype($acctNumber)), __LINE__);
        }
        $this->acctNumber = $acctNumber;
        return $this;
    }
}
