<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestSensorNames StructType
 * @subpackage Structs
 */
class RequestSensorNames extends AbstractStructBase
{
    /**
     * The customerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The waitUntilPanelConnects
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $waitUntilPanelConnects;
    /**
     * Constructor method for RequestSensorNames
     * @uses RequestSensorNames::setCustomerId()
     * @uses RequestSensorNames::setWaitUntilPanelConnects()
     * @param int $customerId
     * @param bool $waitUntilPanelConnects
     */
    public function __construct($customerId = null, $waitUntilPanelConnects = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setWaitUntilPanelConnects($waitUntilPanelConnects);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\RequestSensorNames
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get waitUntilPanelConnects value
     * @return bool
     */
    public function getWaitUntilPanelConnects()
    {
        return $this->waitUntilPanelConnects;
    }
    /**
     * Set waitUntilPanelConnects value
     * @param bool $waitUntilPanelConnects
     * @return \CustomerManagement\StructType\RequestSensorNames
     */
    public function setWaitUntilPanelConnects($waitUntilPanelConnects = null)
    {
        // validation for constraint: boolean
        if (!is_null($waitUntilPanelConnects) && !is_bool($waitUntilPanelConnects)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($waitUntilPanelConnects, true), gettype($waitUntilPanelConnects)), __LINE__);
        }
        $this->waitUntilPanelConnects = $waitUntilPanelConnects;
        return $this;
    }
}
