<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestRemoteRoutineInspectionOutput StructType
 * @subpackage Structs
 */
class RequestRemoteRoutineInspectionOutput extends AbstractStructBase
{
    /**
     * The RRIInstanceCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RRIInstanceCode;
    /**
     * The ResultCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ResultCode;
    /**
     * The RequestsRemaining
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RequestsRemaining;
    /**
     * Constructor method for RequestRemoteRoutineInspectionOutput
     * @uses RequestRemoteRoutineInspectionOutput::setRRIInstanceCode()
     * @uses RequestRemoteRoutineInspectionOutput::setResultCode()
     * @uses RequestRemoteRoutineInspectionOutput::setRequestsRemaining()
     * @param int $rRIInstanceCode
     * @param string $resultCode
     * @param int $requestsRemaining
     */
    public function __construct($rRIInstanceCode = null, $resultCode = null, $requestsRemaining = null)
    {
        $this
            ->setRRIInstanceCode($rRIInstanceCode)
            ->setResultCode($resultCode)
            ->setRequestsRemaining($requestsRemaining);
    }
    /**
     * Get RRIInstanceCode value
     * @return int
     */
    public function getRRIInstanceCode()
    {
        return $this->RRIInstanceCode;
    }
    /**
     * Set RRIInstanceCode value
     * @param int $rRIInstanceCode
     * @return \CustomerManagement\StructType\RequestRemoteRoutineInspectionOutput
     */
    public function setRRIInstanceCode($rRIInstanceCode = null)
    {
        // validation for constraint: int
        if (!is_null($rRIInstanceCode) && !(is_int($rRIInstanceCode) || ctype_digit($rRIInstanceCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rRIInstanceCode, true), gettype($rRIInstanceCode)), __LINE__);
        }
        $this->RRIInstanceCode = $rRIInstanceCode;
        return $this;
    }
    /**
     * Get ResultCode value
     * @return string
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @uses \CustomerManagement\EnumType\RRIRequestResultEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\RRIRequestResultEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resultCode
     * @return \CustomerManagement\StructType\RequestRemoteRoutineInspectionOutput
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\RRIRequestResultEnum::valueIsValid($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\RRIRequestResultEnum', is_array($resultCode) ? implode(', ', $resultCode) : var_export($resultCode, true), implode(', ', \CustomerManagement\EnumType\RRIRequestResultEnum::getValidValues())), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get RequestsRemaining value
     * @return int
     */
    public function getRequestsRemaining()
    {
        return $this->RequestsRemaining;
    }
    /**
     * Set RequestsRemaining value
     * @param int $requestsRemaining
     * @return \CustomerManagement\StructType\RequestRemoteRoutineInspectionOutput
     */
    public function setRequestsRemaining($requestsRemaining = null)
    {
        // validation for constraint: int
        if (!is_null($requestsRemaining) && !(is_int($requestsRemaining) || ctype_digit($requestsRemaining))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestsRemaining, true), gettype($requestsRemaining)), __LINE__);
        }
        $this->RequestsRemaining = $requestsRemaining;
        return $this;
    }
}
