<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoginInfoOutput StructType
 * @subpackage Structs
 */
class LoginInfoOutput extends AbstractStructBase
{
    /**
     * The LoginId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LoginId;
    /**
     * The Culture
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Culture;
    /**
     * The IsLoginManagedByADC
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsLoginManagedByADC;
    /**
     * The LastLogin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $LastLogin;
    /**
     * The IsTwoFactorAuthenticationEnabled
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsTwoFactorAuthenticationEnabled;
    /**
     * The LoginName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoginName;
    /**
     * The LoginNameAtAuthenticationProvider
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoginNameAtAuthenticationProvider;
    /**
     * The EmailAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailAddress;
    /**
     * The AssociatedCustomers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfCustomerSummary
     */
    public $AssociatedCustomers;
    /**
     * Constructor method for LoginInfoOutput
     * @uses LoginInfoOutput::setLoginId()
     * @uses LoginInfoOutput::setCulture()
     * @uses LoginInfoOutput::setIsLoginManagedByADC()
     * @uses LoginInfoOutput::setLastLogin()
     * @uses LoginInfoOutput::setIsTwoFactorAuthenticationEnabled()
     * @uses LoginInfoOutput::setLoginName()
     * @uses LoginInfoOutput::setLoginNameAtAuthenticationProvider()
     * @uses LoginInfoOutput::setEmailAddress()
     * @uses LoginInfoOutput::setAssociatedCustomers()
     * @param int $loginId
     * @param string $culture
     * @param bool $isLoginManagedByADC
     * @param string $lastLogin
     * @param bool $isTwoFactorAuthenticationEnabled
     * @param string $loginName
     * @param string $loginNameAtAuthenticationProvider
     * @param string $emailAddress
     * @param \CustomerManagement\ArrayType\ArrayOfCustomerSummary $associatedCustomers
     */
    public function __construct($loginId = null, $culture = null, $isLoginManagedByADC = null, $lastLogin = null, $isTwoFactorAuthenticationEnabled = null, $loginName = null, $loginNameAtAuthenticationProvider = null, $emailAddress = null, \CustomerManagement\ArrayType\ArrayOfCustomerSummary $associatedCustomers = null)
    {
        $this
            ->setLoginId($loginId)
            ->setCulture($culture)
            ->setIsLoginManagedByADC($isLoginManagedByADC)
            ->setLastLogin($lastLogin)
            ->setIsTwoFactorAuthenticationEnabled($isTwoFactorAuthenticationEnabled)
            ->setLoginName($loginName)
            ->setLoginNameAtAuthenticationProvider($loginNameAtAuthenticationProvider)
            ->setEmailAddress($emailAddress)
            ->setAssociatedCustomers($associatedCustomers);
    }
    /**
     * Get LoginId value
     * @return int
     */
    public function getLoginId()
    {
        return $this->LoginId;
    }
    /**
     * Set LoginId value
     * @param int $loginId
     * @return \CustomerManagement\StructType\LoginInfoOutput
     */
    public function setLoginId($loginId = null)
    {
        // validation for constraint: int
        if (!is_null($loginId) && !(is_int($loginId) || ctype_digit($loginId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($loginId, true), gettype($loginId)), __LINE__);
        }
        $this->LoginId = $loginId;
        return $this;
    }
    /**
     * Get Culture value
     * @return string
     */
    public function getCulture()
    {
        return $this->Culture;
    }
    /**
     * Set Culture value
     * @uses \CustomerManagement\EnumType\CultureEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\CultureEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $culture
     * @return \CustomerManagement\StructType\LoginInfoOutput
     */
    public function setCulture($culture = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\CultureEnum::valueIsValid($culture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\CultureEnum', is_array($culture) ? implode(', ', $culture) : var_export($culture, true), implode(', ', \CustomerManagement\EnumType\CultureEnum::getValidValues())), __LINE__);
        }
        $this->Culture = $culture;
        return $this;
    }
    /**
     * Get IsLoginManagedByADC value
     * @return bool
     */
    public function getIsLoginManagedByADC()
    {
        return $this->IsLoginManagedByADC;
    }
    /**
     * Set IsLoginManagedByADC value
     * @param bool $isLoginManagedByADC
     * @return \CustomerManagement\StructType\LoginInfoOutput
     */
    public function setIsLoginManagedByADC($isLoginManagedByADC = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLoginManagedByADC) && !is_bool($isLoginManagedByADC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isLoginManagedByADC, true), gettype($isLoginManagedByADC)), __LINE__);
        }
        $this->IsLoginManagedByADC = $isLoginManagedByADC;
        return $this;
    }
    /**
     * Get LastLogin value
     * @return string
     */
    public function getLastLogin()
    {
        return $this->LastLogin;
    }
    /**
     * Set LastLogin value
     * @param string $lastLogin
     * @return \CustomerManagement\StructType\LoginInfoOutput
     */
    public function setLastLogin($lastLogin = null)
    {
        // validation for constraint: string
        if (!is_null($lastLogin) && !is_string($lastLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastLogin, true), gettype($lastLogin)), __LINE__);
        }
        $this->LastLogin = $lastLogin;
        return $this;
    }
    /**
     * Get IsTwoFactorAuthenticationEnabled value
     * @return bool
     */
    public function getIsTwoFactorAuthenticationEnabled()
    {
        return $this->IsTwoFactorAuthenticationEnabled;
    }
    /**
     * Set IsTwoFactorAuthenticationEnabled value
     * @param bool $isTwoFactorAuthenticationEnabled
     * @return \CustomerManagement\StructType\LoginInfoOutput
     */
    public function setIsTwoFactorAuthenticationEnabled($isTwoFactorAuthenticationEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTwoFactorAuthenticationEnabled) && !is_bool($isTwoFactorAuthenticationEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTwoFactorAuthenticationEnabled, true), gettype($isTwoFactorAuthenticationEnabled)), __LINE__);
        }
        $this->IsTwoFactorAuthenticationEnabled = $isTwoFactorAuthenticationEnabled;
        return $this;
    }
    /**
     * Get LoginName value
     * @return string|null
     */
    public function getLoginName()
    {
        return $this->LoginName;
    }
    /**
     * Set LoginName value
     * @param string $loginName
     * @return \CustomerManagement\StructType\LoginInfoOutput
     */
    public function setLoginName($loginName = null)
    {
        // validation for constraint: string
        if (!is_null($loginName) && !is_string($loginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginName, true), gettype($loginName)), __LINE__);
        }
        $this->LoginName = $loginName;
        return $this;
    }
    /**
     * Get LoginNameAtAuthenticationProvider value
     * @return string|null
     */
    public function getLoginNameAtAuthenticationProvider()
    {
        return $this->LoginNameAtAuthenticationProvider;
    }
    /**
     * Set LoginNameAtAuthenticationProvider value
     * @param string $loginNameAtAuthenticationProvider
     * @return \CustomerManagement\StructType\LoginInfoOutput
     */
    public function setLoginNameAtAuthenticationProvider($loginNameAtAuthenticationProvider = null)
    {
        // validation for constraint: string
        if (!is_null($loginNameAtAuthenticationProvider) && !is_string($loginNameAtAuthenticationProvider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginNameAtAuthenticationProvider, true), gettype($loginNameAtAuthenticationProvider)), __LINE__);
        }
        $this->LoginNameAtAuthenticationProvider = $loginNameAtAuthenticationProvider;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \CustomerManagement\StructType\LoginInfoOutput
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAddress, true), gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get AssociatedCustomers value
     * @return \CustomerManagement\ArrayType\ArrayOfCustomerSummary|null
     */
    public function getAssociatedCustomers()
    {
        return $this->AssociatedCustomers;
    }
    /**
     * Set AssociatedCustomers value
     * @param \CustomerManagement\ArrayType\ArrayOfCustomerSummary $associatedCustomers
     * @return \CustomerManagement\StructType\LoginInfoOutput
     */
    public function setAssociatedCustomers(\CustomerManagement\ArrayType\ArrayOfCustomerSummary $associatedCustomers = null)
    {
        $this->AssociatedCustomers = $associatedCustomers;
        return $this;
    }
}
