<?php

namespace CustomerManagement\EnumType;

/**
 * This class stands for ProgramEnrollmentStatusEnum EnumType
 * @subpackage Enumerations
 */
class ProgramEnrollmentStatusEnum
{
    /**
     * Constant for value 'NotEligible'
     * @return string 'NotEligible'
     */
    const VALUE_NOT_ELIGIBLE = 'NotEligible';
    /**
     * Constant for value 'Eligible'
     * @return string 'Eligible'
     */
    const VALUE_ELIGIBLE = 'Eligible';
    /**
     * Constant for value 'Invited'
     * @return string 'Invited'
     */
    const VALUE_INVITED = 'Invited';
    /**
     * Constant for value 'Declined'
     * @return string 'Declined'
     */
    const VALUE_DECLINED = 'Declined';
    /**
     * Constant for value 'Enrolled'
     * @return string 'Enrolled'
     */
    const VALUE_ENROLLED = 'Enrolled';
    /**
     * Constant for value 'Cancelled'
     * @return string 'Cancelled'
     */
    const VALUE_CANCELLED = 'Cancelled';
    /**
     * Constant for value 'ProgramFinished'
     * @return string 'ProgramFinished'
     */
    const VALUE_PROGRAM_FINISHED = 'ProgramFinished';
    /**
     * Constant for value 'EnrolledNoControl'
     * @return string 'EnrolledNoControl'
     */
    const VALUE_ENROLLED_NO_CONTROL = 'EnrolledNoControl';
    /**
     * Constant for value 'AgreedPendingConfirmation'
     * @return string 'AgreedPendingConfirmation'
     */
    const VALUE_AGREED_PENDING_CONFIRMATION = 'AgreedPendingConfirmation';
    /**
     * Constant for value 'AgreedPendingCompleteData'
     * @return string 'AgreedPendingCompleteData'
     */
    const VALUE_AGREED_PENDING_COMPLETE_DATA = 'AgreedPendingCompleteData';
    /**
     * Constant for value 'Denied'
     * @return string 'Denied'
     */
    const VALUE_DENIED = 'Denied';
    /**
     * Constant for value 'Unenrolled'
     * @return string 'Unenrolled'
     */
    const VALUE_UNENROLLED = 'Unenrolled';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_ELIGIBLE
     * @uses self::VALUE_ELIGIBLE
     * @uses self::VALUE_INVITED
     * @uses self::VALUE_DECLINED
     * @uses self::VALUE_ENROLLED
     * @uses self::VALUE_CANCELLED
     * @uses self::VALUE_PROGRAM_FINISHED
     * @uses self::VALUE_ENROLLED_NO_CONTROL
     * @uses self::VALUE_AGREED_PENDING_CONFIRMATION
     * @uses self::VALUE_AGREED_PENDING_COMPLETE_DATA
     * @uses self::VALUE_DENIED
     * @uses self::VALUE_UNENROLLED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_ELIGIBLE,
            self::VALUE_ELIGIBLE,
            self::VALUE_INVITED,
            self::VALUE_DECLINED,
            self::VALUE_ENROLLED,
            self::VALUE_CANCELLED,
            self::VALUE_PROGRAM_FINISHED,
            self::VALUE_ENROLLED_NO_CONTROL,
            self::VALUE_AGREED_PENDING_CONFIRMATION,
            self::VALUE_AGREED_PENDING_COMPLETE_DATA,
            self::VALUE_DENIED,
            self::VALUE_UNENROLLED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
