<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TerminateCustomerInput StructType
 * @subpackage Structs
 */
class TerminateCustomerInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The AccountTerminateReason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $AccountTerminateReason;
    /**
     * The SendTerminationMessageToPanel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $SendTerminationMessageToPanel;
    /**
     * The TerminationDelayDays
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TerminationDelayDays;
    /**
     * The MasterReset
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $MasterReset;
    /**
     * Constructor method for TerminateCustomerInput
     * @uses TerminateCustomerInput::setCustomerId()
     * @uses TerminateCustomerInput::setAccountTerminateReason()
     * @uses TerminateCustomerInput::setSendTerminationMessageToPanel()
     * @uses TerminateCustomerInput::setTerminationDelayDays()
     * @uses TerminateCustomerInput::setMasterReset()
     * @param int $customerId
     * @param string $accountTerminateReason
     * @param bool $sendTerminationMessageToPanel
     * @param int $terminationDelayDays
     * @param bool $masterReset
     */
    public function __construct($customerId = null, $accountTerminateReason = null, $sendTerminationMessageToPanel = null, $terminationDelayDays = null, $masterReset = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setAccountTerminateReason($accountTerminateReason)
            ->setSendTerminationMessageToPanel($sendTerminationMessageToPanel)
            ->setTerminationDelayDays($terminationDelayDays)
            ->setMasterReset($masterReset);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\TerminateCustomerInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get AccountTerminateReason value
     * @return string
     */
    public function getAccountTerminateReason()
    {
        return $this->AccountTerminateReason;
    }
    /**
     * Set AccountTerminateReason value
     * @uses \CustomerManagement\EnumType\CustomerTerminateReasonEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\CustomerTerminateReasonEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accountTerminateReason
     * @return \CustomerManagement\StructType\TerminateCustomerInput
     */
    public function setAccountTerminateReason($accountTerminateReason = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\CustomerTerminateReasonEnum::valueIsValid($accountTerminateReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\CustomerTerminateReasonEnum', is_array($accountTerminateReason) ? implode(', ', $accountTerminateReason) : var_export($accountTerminateReason, true), implode(', ', \CustomerManagement\EnumType\CustomerTerminateReasonEnum::getValidValues())), __LINE__);
        }
        $this->AccountTerminateReason = $accountTerminateReason;
        return $this;
    }
    /**
     * Get SendTerminationMessageToPanel value
     * @return bool
     */
    public function getSendTerminationMessageToPanel()
    {
        return $this->SendTerminationMessageToPanel;
    }
    /**
     * Set SendTerminationMessageToPanel value
     * @param bool $sendTerminationMessageToPanel
     * @return \CustomerManagement\StructType\TerminateCustomerInput
     */
    public function setSendTerminationMessageToPanel($sendTerminationMessageToPanel = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendTerminationMessageToPanel) && !is_bool($sendTerminationMessageToPanel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendTerminationMessageToPanel, true), gettype($sendTerminationMessageToPanel)), __LINE__);
        }
        $this->SendTerminationMessageToPanel = $sendTerminationMessageToPanel;
        return $this;
    }
    /**
     * Get TerminationDelayDays value
     * @return int
     */
    public function getTerminationDelayDays()
    {
        return $this->TerminationDelayDays;
    }
    /**
     * Set TerminationDelayDays value
     * @param int $terminationDelayDays
     * @return \CustomerManagement\StructType\TerminateCustomerInput
     */
    public function setTerminationDelayDays($terminationDelayDays = null)
    {
        // validation for constraint: int
        if (!is_null($terminationDelayDays) && !(is_int($terminationDelayDays) || ctype_digit($terminationDelayDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($terminationDelayDays, true), gettype($terminationDelayDays)), __LINE__);
        }
        $this->TerminationDelayDays = $terminationDelayDays;
        return $this;
    }
    /**
     * Get MasterReset value
     * @return bool
     */
    public function getMasterReset()
    {
        return $this->MasterReset;
    }
    /**
     * Set MasterReset value
     * @param bool $masterReset
     * @return \CustomerManagement\StructType\TerminateCustomerInput
     */
    public function setMasterReset($masterReset = null)
    {
        // validation for constraint: boolean
        if (!is_null($masterReset) && !is_bool($masterReset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($masterReset, true), gettype($masterReset)), __LINE__);
        }
        $this->MasterReset = $masterReset;
        return $this;
    }
}
