<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddUpdateZwaveDeviceSpecificKeyInput StructType
 * @subpackage Structs
 */
class AddUpdateZwaveDeviceSpecificKeyInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The UsingQrCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $UsingQrCode;
    /**
     * The DskId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $DskId;
    /**
     * The DeviceDesc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeviceDesc;
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Key;
    /**
     * Constructor method for AddUpdateZwaveDeviceSpecificKeyInput
     * @uses AddUpdateZwaveDeviceSpecificKeyInput::setCustomerId()
     * @uses AddUpdateZwaveDeviceSpecificKeyInput::setUsingQrCode()
     * @uses AddUpdateZwaveDeviceSpecificKeyInput::setDskId()
     * @uses AddUpdateZwaveDeviceSpecificKeyInput::setDeviceDesc()
     * @uses AddUpdateZwaveDeviceSpecificKeyInput::setKey()
     * @param int $customerId
     * @param bool $usingQrCode
     * @param int $dskId
     * @param string $deviceDesc
     * @param string $key
     */
    public function __construct($customerId = null, $usingQrCode = null, $dskId = null, $deviceDesc = null, $key = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setUsingQrCode($usingQrCode)
            ->setDskId($dskId)
            ->setDeviceDesc($deviceDesc)
            ->setKey($key);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\AddUpdateZwaveDeviceSpecificKeyInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get UsingQrCode value
     * @return bool
     */
    public function getUsingQrCode()
    {
        return $this->UsingQrCode;
    }
    /**
     * Set UsingQrCode value
     * @param bool $usingQrCode
     * @return \CustomerManagement\StructType\AddUpdateZwaveDeviceSpecificKeyInput
     */
    public function setUsingQrCode($usingQrCode = null)
    {
        // validation for constraint: boolean
        if (!is_null($usingQrCode) && !is_bool($usingQrCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($usingQrCode, true), gettype($usingQrCode)), __LINE__);
        }
        $this->UsingQrCode = $usingQrCode;
        return $this;
    }
    /**
     * Get DskId value
     * @return int
     */
    public function getDskId()
    {
        return $this->DskId;
    }
    /**
     * Set DskId value
     * @param int $dskId
     * @return \CustomerManagement\StructType\AddUpdateZwaveDeviceSpecificKeyInput
     */
    public function setDskId($dskId = null)
    {
        // validation for constraint: int
        if (!is_null($dskId) && !(is_int($dskId) || ctype_digit($dskId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dskId, true), gettype($dskId)), __LINE__);
        }
        $this->DskId = $dskId;
        return $this;
    }
    /**
     * Get DeviceDesc value
     * @return string|null
     */
    public function getDeviceDesc()
    {
        return $this->DeviceDesc;
    }
    /**
     * Set DeviceDesc value
     * @param string $deviceDesc
     * @return \CustomerManagement\StructType\AddUpdateZwaveDeviceSpecificKeyInput
     */
    public function setDeviceDesc($deviceDesc = null)
    {
        // validation for constraint: string
        if (!is_null($deviceDesc) && !is_string($deviceDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceDesc, true), gettype($deviceDesc)), __LINE__);
        }
        $this->DeviceDesc = $deviceDesc;
        return $this;
    }
    /**
     * Get Key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->Key;
    }
    /**
     * Set Key value
     * @param string $key
     * @return \CustomerManagement\StructType\AddUpdateZwaveDeviceSpecificKeyInput
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        $this->Key = $key;
        return $this;
    }
}
