<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEventHistoryItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfEventHistoryItem extends AbstractStructArrayBase
{
    /**
     * The EventHistoryItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CustomerManagement\StructType\EventHistoryItem[]
     */
    public $EventHistoryItem;
    /**
     * Constructor method for ArrayOfEventHistoryItem
     * @uses ArrayOfEventHistoryItem::setEventHistoryItem()
     * @param \CustomerManagement\StructType\EventHistoryItem[] $eventHistoryItem
     */
    public function __construct(array $eventHistoryItem = array())
    {
        $this
            ->setEventHistoryItem($eventHistoryItem);
    }
    /**
     * Get EventHistoryItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CustomerManagement\StructType\EventHistoryItem[]|null
     */
    public function getEventHistoryItem()
    {
        return isset($this->EventHistoryItem) ? $this->EventHistoryItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEventHistoryItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEventHistoryItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEventHistoryItemForArrayConstraintsFromSetEventHistoryItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfEventHistoryItemEventHistoryItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfEventHistoryItemEventHistoryItemItem instanceof \CustomerManagement\StructType\EventHistoryItem) {
                $invalidValues[] = is_object($arrayOfEventHistoryItemEventHistoryItemItem) ? get_class($arrayOfEventHistoryItemEventHistoryItemItem) : sprintf('%s(%s)', gettype($arrayOfEventHistoryItemEventHistoryItemItem), var_export($arrayOfEventHistoryItemEventHistoryItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EventHistoryItem property can only contain items of type \CustomerManagement\StructType\EventHistoryItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EventHistoryItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\EventHistoryItem[] $eventHistoryItem
     * @return \CustomerManagement\ArrayType\ArrayOfEventHistoryItem
     */
    public function setEventHistoryItem(array $eventHistoryItem = array())
    {
        // validation for constraint: array
        if ('' !== ($eventHistoryItemArrayErrorMessage = self::validateEventHistoryItemForArrayConstraintsFromSetEventHistoryItem($eventHistoryItem))) {
            throw new \InvalidArgumentException($eventHistoryItemArrayErrorMessage, __LINE__);
        }
        if (is_null($eventHistoryItem) || (is_array($eventHistoryItem) && empty($eventHistoryItem))) {
            unset($this->EventHistoryItem);
        } else {
            $this->EventHistoryItem = $eventHistoryItem;
        }
        return $this;
    }
    /**
     * Add item to EventHistoryItem value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\EventHistoryItem $item
     * @return \CustomerManagement\ArrayType\ArrayOfEventHistoryItem
     */
    public function addToEventHistoryItem(\CustomerManagement\StructType\EventHistoryItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CustomerManagement\StructType\EventHistoryItem) {
            throw new \InvalidArgumentException(sprintf('The EventHistoryItem property can only contain items of type \CustomerManagement\StructType\EventHistoryItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EventHistoryItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CustomerManagement\StructType\EventHistoryItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CustomerManagement\StructType\EventHistoryItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CustomerManagement\StructType\EventHistoryItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CustomerManagement\StructType\EventHistoryItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CustomerManagement\StructType\EventHistoryItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EventHistoryItem
     */
    public function getAttributeName()
    {
        return 'EventHistoryItem';
    }
}
