<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomerListWithTroubleConditionsInput StructType
 * @subpackage Structs
 */
class GetCustomerListWithTroubleConditionsInput extends AbstractStructBase
{
    /**
     * The CallerVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CallerVersion;
    /**
     * The IncludeDeviceDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IncludeDeviceDetails;
    /**
     * The Conditions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfTroubleConditionTypeEnum
     */
    public $Conditions;
    /**
     * Constructor method for GetCustomerListWithTroubleConditionsInput
     * @uses GetCustomerListWithTroubleConditionsInput::setCallerVersion()
     * @uses GetCustomerListWithTroubleConditionsInput::setIncludeDeviceDetails()
     * @uses GetCustomerListWithTroubleConditionsInput::setConditions()
     * @param int $callerVersion
     * @param bool $includeDeviceDetails
     * @param \CustomerManagement\ArrayType\ArrayOfTroubleConditionTypeEnum $conditions
     */
    public function __construct($callerVersion = null, $includeDeviceDetails = null, \CustomerManagement\ArrayType\ArrayOfTroubleConditionTypeEnum $conditions = null)
    {
        $this
            ->setCallerVersion($callerVersion)
            ->setIncludeDeviceDetails($includeDeviceDetails)
            ->setConditions($conditions);
    }
    /**
     * Get CallerVersion value
     * @return int
     */
    public function getCallerVersion()
    {
        return $this->CallerVersion;
    }
    /**
     * Set CallerVersion value
     * @param int $callerVersion
     * @return \CustomerManagement\StructType\GetCustomerListWithTroubleConditionsInput
     */
    public function setCallerVersion($callerVersion = null)
    {
        // validation for constraint: int
        if (!is_null($callerVersion) && !(is_int($callerVersion) || ctype_digit($callerVersion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($callerVersion, true), gettype($callerVersion)), __LINE__);
        }
        $this->CallerVersion = $callerVersion;
        return $this;
    }
    /**
     * Get IncludeDeviceDetails value
     * @return bool
     */
    public function getIncludeDeviceDetails()
    {
        return $this->IncludeDeviceDetails;
    }
    /**
     * Set IncludeDeviceDetails value
     * @param bool $includeDeviceDetails
     * @return \CustomerManagement\StructType\GetCustomerListWithTroubleConditionsInput
     */
    public function setIncludeDeviceDetails($includeDeviceDetails = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeDeviceDetails) && !is_bool($includeDeviceDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeDeviceDetails, true), gettype($includeDeviceDetails)), __LINE__);
        }
        $this->IncludeDeviceDetails = $includeDeviceDetails;
        return $this;
    }
    /**
     * Get Conditions value
     * @return \CustomerManagement\ArrayType\ArrayOfTroubleConditionTypeEnum|null
     */
    public function getConditions()
    {
        return $this->Conditions;
    }
    /**
     * Set Conditions value
     * @param \CustomerManagement\ArrayType\ArrayOfTroubleConditionTypeEnum $conditions
     * @return \CustomerManagement\StructType\GetCustomerListWithTroubleConditionsInput
     */
    public function setConditions(\CustomerManagement\ArrayType\ArrayOfTroubleConditionTypeEnum $conditions = null)
    {
        $this->Conditions = $conditions;
        return $this;
    }
}
