<?php

namespace CustomerManagement\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for LoginResult EnumType
 * @subpackage Enumerations
 */
class LoginResult extends AbstractStructEnumBase
{
    /**
     * Constant for value 'UnknownError'
     * @return string 'UnknownError'
     */
    const VALUE_UNKNOWN_ERROR = 'UnknownError';
    /**
     * Constant for value 'Success'
     * @return string 'Success'
     */
    const VALUE_SUCCESS = 'Success';
    /**
     * Constant for value 'BadCredentials'
     * @return string 'BadCredentials'
     */
    const VALUE_BAD_CREDENTIALS = 'BadCredentials';
    /**
     * Constant for value 'LockedOut'
     * @return string 'LockedOut'
     */
    const VALUE_LOCKED_OUT = 'LockedOut';
    /**
     * Constant for value 'NoAccessToCustomersForYourDealer'
     * @return string 'NoAccessToCustomersForYourDealer'
     */
    const VALUE_NO_ACCESS_TO_CUSTOMERS_FOR_YOUR_DEALER = 'NoAccessToCustomersForYourDealer';
    /**
     * Constant for value 'NoActiveUnits'
     * @return string 'NoActiveUnits'
     */
    const VALUE_NO_ACTIVE_UNITS = 'NoActiveUnits';
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN_ERROR
     * @uses self::VALUE_SUCCESS
     * @uses self::VALUE_BAD_CREDENTIALS
     * @uses self::VALUE_LOCKED_OUT
     * @uses self::VALUE_NO_ACCESS_TO_CUSTOMERS_FOR_YOUR_DEALER
     * @uses self::VALUE_NO_ACTIVE_UNITS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN_ERROR,
            self::VALUE_SUCCESS,
            self::VALUE_BAD_CREDENTIALS,
            self::VALUE_LOCKED_OUT,
            self::VALUE_NO_ACCESS_TO_CUSTOMERS_FOR_YOUR_DEALER,
            self::VALUE_NO_ACTIVE_UNITS,
        );
    }
}
