<?php

namespace CustomerManagement\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for DeviceInstallerEnum EnumType
 * @subpackage Enumerations
 */
class DeviceInstallerEnum extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'DealerRep'
     * @return string 'DealerRep'
     */
    const VALUE_DEALER_REP = 'DealerRep';
    /**
     * Constant for value 'Customer'
     * @return string 'Customer'
     */
    const VALUE_CUSTOMER = 'Customer';
    /**
     * Constant for value 'Builder'
     * @return string 'Builder'
     */
    const VALUE_BUILDER = 'Builder';
    /**
     * Constant for value 'Other'
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_DEALER_REP
     * @uses self::VALUE_CUSTOMER
     * @uses self::VALUE_BUILDER
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_DEALER_REP,
            self::VALUE_CUSTOMER,
            self::VALUE_BUILDER,
            self::VALUE_OTHER,
        );
    }
}
