<?php

namespace CustomerManagement\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \CustomerManagement\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\CustomerManagement\StructType\Authentication $authentication, $nameSpace = 'http://www.alarm.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named UpdatePropertyType
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Updates the property type for the customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdatePropertyType $parameters
     * @return \CustomerManagement\StructType\UpdatePropertyTypeResponse|bool
     */
    public function UpdatePropertyType(\CustomerManagement\StructType\UpdatePropertyType $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdatePropertyType($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdatePrimaryPhone
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Updates the primary phone number for the customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdatePrimaryPhone $parameters
     * @return \CustomerManagement\StructType\UpdatePrimaryPhoneResponse|bool
     */
    public function UpdatePrimaryPhone(\CustomerManagement\StructType\UpdatePrimaryPhone $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdatePrimaryPhone($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCameraSettings
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Updates the wireless settings for a camera.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateCameraSettings $parameters
     * @return \CustomerManagement\StructType\UpdateCameraSettingsResponse|bool
     */
    public function UpdateCameraSettings(\CustomerManagement\StructType\UpdateCameraSettings $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateCameraSettings($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCustomerSecurityQuestion
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Updates the security question for a customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateCustomerSecurityQuestion $parameters
     * @return \CustomerManagement\StructType\UpdateCustomerSecurityQuestionResponse|bool
     */
    public function UpdateCustomerSecurityQuestion(\CustomerManagement\StructType\UpdateCustomerSecurityQuestion $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateCustomerSecurityQuestion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCustomDevices
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Add or update custom devices for a customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateCustomDevices $parameters
     * @return \CustomerManagement\StructType\UpdateCustomDevicesResponse|bool
     */
    public function UpdateCustomDevices(\CustomerManagement\StructType\UpdateCustomDevices $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateCustomDevices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateUnitDescription
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Update customer unit description.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateUnitDescription $parameters
     * @return \CustomerManagement\StructType\UpdateUnitDescriptionResponse|bool
     */
    public function UpdateUnitDescription(\CustomerManagement\StructType\UpdateUnitDescription $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateUnitDescription($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * UpdateBusinessActivityAnalyticsMetricInfo
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Updates the latest metric and traffic info for a business activity analytics schedule
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateBusinessActivityAnalyticsMetricInfo $parameters
     * @return \CustomerManagement\StructType\UpdateBusinessActivityAnalyticsMetricInfoResponse|bool
     */
    public function UpdateBusinessActivityAnalyticsMetricInfo(\CustomerManagement\StructType\UpdateBusinessActivityAnalyticsMetricInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateBusinessActivityAnalyticsMetricInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateDeviceName
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: This method updates the backend name of a given device.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateDeviceName $parameters
     * @return \CustomerManagement\StructType\UpdateDeviceNameResponse|bool
     */
    public function UpdateDeviceName(\CustomerManagement\StructType\UpdateDeviceName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateDeviceName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateSensorDevice
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Only use this method to update the Sensor ID or the Sensor Name. To update sensor name: use SensorNamePrefix for the NX panel; SensorName for Qolsys; and Base, Suffix, Token3, and Token4 for XT/XTi. Please call GetEligibleSensorNames
     * to get the valid descriptors for XT/XTi. This method will update the name in the control panel and on the website.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateSensorDevice $parameters
     * @return \CustomerManagement\StructType\UpdateSensorDeviceResponse|bool
     */
    public function UpdateSensorDevice(\CustomerManagement\StructType\UpdateSensorDevice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateSensorDevice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateSensorTypeIDQolsys
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Update sensor type for Qolsys Panel. You may wish to call GetDeviceList or GetFullEquipmentList first to get the current settings.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateSensorTypeIDQolsys $parameters
     * @return \CustomerManagement\StructType\UpdateSensorTypeIDQolsysResponse|bool
     */
    public function UpdateSensorTypeIDQolsys(\CustomerManagement\StructType\UpdateSensorTypeIDQolsys $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateSensorTypeIDQolsys($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateSensorGroup
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Update sensor group. You may wish to call GetDeviceList or GetFullEquipmentList first to get the current settings.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateSensorGroup $parameters
     * @return \CustomerManagement\StructType\UpdateSensorGroupResponse|bool
     */
    public function UpdateSensorGroup(\CustomerManagement\StructType\UpdateSensorGroup $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateSensorGroup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateNxSensorType
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Update NX sensor type. You may wish to call GetDeviceList or GetFullEquipmentList first to get the current settings.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateNxSensorType $parameters
     * @return \CustomerManagement\StructType\UpdateNxSensorTypeResponse|bool
     */
    public function UpdateNxSensorType(\CustomerManagement\StructType\UpdateNxSensorType $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateNxSensorType($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdatePanelCommunicationSetting
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Change panel communication setting.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdatePanelCommunicationSetting $parameters
     * @return \CustomerManagement\StructType\UpdatePanelCommunicationSettingResponse|bool
     */
    public function UpdatePanelCommunicationSetting(\CustomerManagement\StructType\UpdatePanelCommunicationSetting $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdatePanelCommunicationSetting($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateLoginEmailPreferences
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Update a login's email preferences.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateLoginEmailPreferences $parameters
     * @return \CustomerManagement\StructType\UpdateLoginEmailPreferencesResponse|bool
     */
    public function UpdateLoginEmailPreferences(\CustomerManagement\StructType\UpdateLoginEmailPreferences $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateLoginEmailPreferences($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateEnterpriseGroup
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Change a customer's enterprise group to the given input enterprise group. If NewSystemGroupId is not provided, removes customer from their current enterprise group.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateEnterpriseGroup $parameters
     * @return \CustomerManagement\StructType\UpdateEnterpriseGroupResponse|bool
     */
    public function UpdateEnterpriseGroup(\CustomerManagement\StructType\UpdateEnterpriseGroup $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateEnterpriseGroup($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCustomerInstallType
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Updates the install type for a customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateCustomerInstallType $parameters
     * @return \CustomerManagement\StructType\UpdateCustomerInstallTypeResponse|bool
     */
    public function UpdateCustomerInstallType(\CustomerManagement\StructType\UpdateCustomerInstallType $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateCustomerInstallType($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateInAppBillingMessage
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Updates billing issues mapped to a customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateInAppBillingMessage $parameters
     * @return \CustomerManagement\StructType\UpdateInAppBillingMessageResponse|bool
     */
    public function UpdateInAppBillingMessage(\CustomerManagement\StructType\UpdateInAppBillingMessage $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateInAppBillingMessage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * UpdateEBSIntrusionDeviceInformation
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Records an EBS Intrusion customer's third party device information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateEBSIntrusionDeviceInformation $parameters
     * @return \CustomerManagement\StructType\UpdateEBSIntrusionDeviceInformationResponse|bool
     */
    public function UpdateEBSIntrusionDeviceInformation(\CustomerManagement\StructType\UpdateEBSIntrusionDeviceInformation $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateEBSIntrusionDeviceInformation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateEBSFireDeviceInformation
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Records an EBS Fire customer's third party device information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateEBSFireDeviceInformation $parameters
     * @return \CustomerManagement\StructType\UpdateEBSFireDeviceInformationResponse|bool
     */
    public function UpdateEBSFireDeviceInformation(\CustomerManagement\StructType\UpdateEBSFireDeviceInformation $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateEBSFireDeviceInformation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCommitment
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateCommitment $parameters
     * @return \CustomerManagement\StructType\UpdateCommitmentResponse|bool
     */
    public function UpdateCommitment(\CustomerManagement\StructType\UpdateCommitment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateCommitment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateEnterpriseRoles
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateEnterpriseRoles $parameters
     * @return \CustomerManagement\StructType\UpdateEnterpriseRolesResponse|bool
     */
    public function UpdateEnterpriseRoles(\CustomerManagement\StructType\UpdateEnterpriseRoles $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateEnterpriseRoles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateRoles
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Update a login's roles.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateRoles $parameters
     * @return \CustomerManagement\StructType\UpdateRolesResponse|bool
     */
    public function UpdateRoles(\CustomerManagement\StructType\UpdateRoles $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateRoles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCustomerAddress
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateCustomerAddress $parameters
     * @return \CustomerManagement\StructType\UpdateCustomerAddressResponse|bool
     */
    public function UpdateCustomerAddress(\CustomerManagement\StructType\UpdateCustomerAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateCustomerAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCustomerTimeZone
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateCustomerTimeZone $parameters
     * @return \CustomerManagement\StructType\UpdateCustomerTimeZoneResponse|bool
     */
    public function UpdateCustomerTimeZone(\CustomerManagement\StructType\UpdateCustomerTimeZone $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateCustomerTimeZone($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCustomerPassword
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateCustomerPassword $parameters
     * @return \CustomerManagement\StructType\UpdateCustomerPasswordResponse|bool
     */
    public function UpdateCustomerPassword(\CustomerManagement\StructType\UpdateCustomerPassword $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateCustomerPassword($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCustomerLogin
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateCustomerLogin $parameters
     * @return \CustomerManagement\StructType\UpdateCustomerLoginResponse|bool
     */
    public function UpdateCustomerLogin(\CustomerManagement\StructType\UpdateCustomerLogin $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateCustomerLogin($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCustomerLoginInfo
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Update login name, login name at authentication provider, email address and culture for a customer login.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateCustomerLoginInfo $parameters
     * @return \CustomerManagement\StructType\UpdateCustomerLoginInfoResponse|bool
     */
    public function UpdateCustomerLoginInfo(\CustomerManagement\StructType\UpdateCustomerLoginInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateCustomerLoginInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCustomerName
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateCustomerName $parameters
     * @return \CustomerManagement\StructType\UpdateCustomerNameResponse|bool
     */
    public function UpdateCustomerName(\CustomerManagement\StructType\UpdateCustomerName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateCustomerName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCustomerReadyDate
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Update ready date (in UTC) for a customer login.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateCustomerReadyDate $parameters
     * @return \CustomerManagement\StructType\UpdateCustomerReadyDateResponse|bool
     */
    public function UpdateCustomerReadyDate(\CustomerManagement\StructType\UpdateCustomerReadyDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateCustomerReadyDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * UpdateAuthenticationProviderLoginName
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateAuthenticationProviderLoginName $parameters
     * @return \CustomerManagement\StructType\UpdateAuthenticationProviderLoginNameResponse|bool
     */
    public function UpdateAuthenticationProviderLoginName(\CustomerManagement\StructType\UpdateAuthenticationProviderLoginName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateAuthenticationProviderLoginName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateLoginPasswordWithoutPassword
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Change the password for a login without the old password. Prior to calling this method you will need to validate the customers security question. Please contact your sales rep before implementing this method.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateLoginPasswordWithoutPassword $parameters
     * @return \CustomerManagement\StructType\UpdateLoginPasswordWithoutPasswordResponse|bool
     */
    public function UpdateLoginPasswordWithoutPassword(\CustomerManagement\StructType\UpdateLoginPasswordWithoutPassword $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateLoginPasswordWithoutPassword($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCustomerBranch
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Move a customer to a different branch.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateCustomerBranch $parameters
     * @return \CustomerManagement\StructType\UpdateCustomerBranchResponse|bool
     */
    public function UpdateCustomerBranch(\CustomerManagement\StructType\UpdateCustomerBranch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateCustomerBranch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateDealerCustomerId
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Update the dealer customer id for a customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateDealerCustomerId $parameters
     * @return \CustomerManagement\StructType\UpdateDealerCustomerIdResponse|bool
     */
    public function UpdateDealerCustomerId(\CustomerManagement\StructType\UpdateDealerCustomerId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateDealerCustomerId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateInstallerSalesRep
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Update the customer's installer and sales rep info
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateInstallerSalesRep $parameters
     * @return \CustomerManagement\StructType\UpdateInstallerSalesRepResponse|bool
     */
    public function UpdateInstallerSalesRep(\CustomerManagement\StructType\UpdateInstallerSalesRep $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateInstallerSalesRep($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateContractInformation
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Update the Customer's Contract Information. Passing null will clear the existing value.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateContractInformation $parameters
     * @return \CustomerManagement\StructType\UpdateContractInformationResponse|bool
     */
    public function UpdateContractInformation(\CustomerManagement\StructType\UpdateContractInformation $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateContractInformation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateDealerCustomerSource
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Update whether the customer is enrolled in a maintenance plan.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateDealerCustomerSource $parameters
     * @return \CustomerManagement\StructType\UpdateDealerCustomerSourceResponse|bool
     */
    public function UpdateDealerCustomerSource(\CustomerManagement\StructType\UpdateDealerCustomerSource $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateDealerCustomerSource($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCentralStationInfo
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Deprecated. Please use UpdateCentralStationInfo_V2. Updates the central station info for a customer. You may wish to call GetCustomerInfo first to get the current settings.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateCentralStationInfo $parameters
     * @return \CustomerManagement\StructType\UpdateCentralStationInfoResponse|bool
     */
    public function UpdateCentralStationInfo(\CustomerManagement\StructType\UpdateCentralStationInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateCentralStationInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCentralStationInfo_V2
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Updates the central station info for a customer. You may wish to call GetCustomerInfo first to get the current settings.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdateCentralStationInfo_V2 $parameters
     * @return \CustomerManagement\StructType\UpdateCentralStationInfo_V2Response|bool
     */
    public function UpdateCentralStationInfo_V2(\CustomerManagement\StructType\UpdateCentralStationInfo_V2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateCentralStationInfo_V2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdatePrimaryEmail
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Updates the primary email address for the customer.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\UpdatePrimaryEmail $parameters
     * @return \CustomerManagement\StructType\UpdatePrimaryEmailResponse|bool
     */
    public function UpdatePrimaryEmail(\CustomerManagement\StructType\UpdatePrimaryEmail $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdatePrimaryEmail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CustomerManagement\StructType\UpdateAuthenticationProviderLoginNameResponse|\CustomerManagement\StructType\UpdateBusinessActivityAnalyticsMetricInfoResponse|\CustomerManagement\StructType\UpdateCameraSettingsResponse|\CustomerManagement\StructType\UpdateCentralStationInfoResponse|\CustomerManagement\StructType\UpdateCentralStationInfo_V2Response|\CustomerManagement\StructType\UpdateCommitmentResponse|\CustomerManagement\StructType\UpdateContractInformationResponse|\CustomerManagement\StructType\UpdateCustomDevicesResponse|\CustomerManagement\StructType\UpdateCustomerAddressResponse|\CustomerManagement\StructType\UpdateCustomerBranchResponse|\CustomerManagement\StructType\UpdateCustomerInstallTypeResponse|\CustomerManagement\StructType\UpdateCustomerLoginInfoResponse|\CustomerManagement\StructType\UpdateCustomerLoginResponse|\CustomerManagement\StructType\UpdateCustomerNameResponse|\CustomerManagement\StructType\UpdateCustomerPasswordResponse|\CustomerManagement\StructType\UpdateCustomerReadyDateResponse|\CustomerManagement\StructType\UpdateCustomerSecurityQuestionResponse|\CustomerManagement\StructType\UpdateCustomerTimeZoneResponse|\CustomerManagement\StructType\UpdateDealerCustomerIdResponse|\CustomerManagement\StructType\UpdateDealerCustomerSourceResponse|\CustomerManagement\StructType\UpdateDeviceNameResponse|\CustomerManagement\StructType\UpdateEBSFireDeviceInformationResponse|\CustomerManagement\StructType\UpdateEBSIntrusionDeviceInformationResponse|\CustomerManagement\StructType\UpdateEnterpriseGroupResponse|\CustomerManagement\StructType\UpdateEnterpriseRolesResponse|\CustomerManagement\StructType\UpdateInAppBillingMessageResponse|\CustomerManagement\StructType\UpdateInstallerSalesRepResponse|\CustomerManagement\StructType\UpdateLoginEmailPreferencesResponse|\CustomerManagement\StructType\UpdateLoginPasswordWithoutPasswordResponse|\CustomerManagement\StructType\UpdateNxSensorTypeResponse|\CustomerManagement\StructType\UpdatePanelCommunicationSettingResponse|\CustomerManagement\StructType\UpdatePrimaryEmailResponse|\CustomerManagement\StructType\UpdatePrimaryPhoneResponse|\CustomerManagement\StructType\UpdatePropertyTypeResponse|\CustomerManagement\StructType\UpdateRolesResponse|\CustomerManagement\StructType\UpdateSensorDeviceResponse|\CustomerManagement\StructType\UpdateSensorGroupResponse|\CustomerManagement\StructType\UpdateSensorTypeIDQolsysResponse|\CustomerManagement\StructType\UpdateUnitDescriptionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
