<?php

namespace CustomerManagement\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for WiFiEncryptionTypeEnum EnumType
 * @subpackage Enumerations
 */
class WiFiEncryptionTypeEnum extends AbstractStructEnumBase
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Wep'
     * @return string 'Wep'
     */
    const VALUE_WEP = 'Wep';
    /**
     * Constant for value 'Wpa'
     * @return string 'Wpa'
     */
    const VALUE_WPA = 'Wpa';
    /**
     * Constant for value 'Wpa2'
     * @return string 'Wpa2'
     */
    const VALUE_WPA_2_1 = 'Wpa2';
    /**
     * Constant for value 'Wpa2Enterprise'
     * @return string 'Wpa2Enterprise'
     */
    const VALUE_WPA_2_ENTERPRISE = 'Wpa2Enterprise';
    /**
     * Constant for value 'Wps'
     * @return string 'Wps'
     */
    const VALUE_WPS = 'Wps';
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'WpaWPa2'
     * @return string 'WpaWPa2'
     */
    const VALUE_WPA_WPA_2 = 'WpaWPa2';
    /**
     * Constant for value 'Eap'
     * @return string 'Eap'
     */
    const VALUE_EAP = 'Eap';
    /**
     * Constant for value 'Wpa2Wpa3'
     * @return string 'Wpa2Wpa3'
     */
    const VALUE_WPA_2_WPA_3 = 'Wpa2Wpa3';
    /**
     * Constant for value 'Wpa3'
     * @return string 'Wpa3'
     */
    const VALUE_WPA_3 = 'Wpa3';
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_WEP
     * @uses self::VALUE_WPA_1
     * @uses self::VALUE_WPA_2_1
     * @uses self::VALUE_WPA_2_ENTERPRISE
     * @uses self::VALUE_WPS
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_WPA_WPA_2
     * @uses self::VALUE_EAP
     * @uses self::VALUE_WPA_2_WPA_3
     * @uses self::VALUE_WPA_3
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_WEP,
            self::VALUE_WPA_1,
            self::VALUE_WPA_2_1,
            self::VALUE_WPA_2_ENTERPRISE,
            self::VALUE_WPS,
            self::VALUE_UNKNOWN,
            self::VALUE_WPA_WPA_2,
            self::VALUE_EAP,
            self::VALUE_WPA_2_WPA_3,
            self::VALUE_WPA_3,
        );
    }
}
