<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestFirmwareUpgradeNonPanel StructType
 * @subpackage Structs
 */
class RequestFirmwareUpgradeNonPanel extends AbstractStructBase
{
    /**
     * The customerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The newVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $newVersion;
    /**
     * The desiredUpgradeMode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $desiredUpgradeMode;
    /**
     * The deviceId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $deviceId;
    /**
     * Constructor method for RequestFirmwareUpgradeNonPanel
     * @uses RequestFirmwareUpgradeNonPanel::setCustomerId()
     * @uses RequestFirmwareUpgradeNonPanel::setNewVersion()
     * @uses RequestFirmwareUpgradeNonPanel::setDesiredUpgradeMode()
     * @uses RequestFirmwareUpgradeNonPanel::setDeviceId()
     * @param int $customerId
     * @param string $newVersion
     * @param string $desiredUpgradeMode
     * @param int $deviceId
     */
    public function __construct($customerId = null, $newVersion = null, $desiredUpgradeMode = null, $deviceId = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setNewVersion($newVersion)
            ->setDesiredUpgradeMode($desiredUpgradeMode)
            ->setDeviceId($deviceId);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\RequestFirmwareUpgradeNonPanel
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get newVersion value
     * @return string
     */
    public function getNewVersion()
    {
        return $this->newVersion;
    }
    /**
     * Set newVersion value
     * @uses \CustomerManagement\EnumType\FirmwareUpgradeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\FirmwareUpgradeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $newVersion
     * @return \CustomerManagement\StructType\RequestFirmwareUpgradeNonPanel
     */
    public function setNewVersion($newVersion = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\FirmwareUpgradeEnum::valueIsValid($newVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\FirmwareUpgradeEnum', is_array($newVersion) ? implode(', ', $newVersion) : var_export($newVersion, true), implode(', ', \CustomerManagement\EnumType\FirmwareUpgradeEnum::getValidValues())), __LINE__);
        }
        $this->newVersion = $newVersion;
        return $this;
    }
    /**
     * Get desiredUpgradeMode value
     * @return string
     */
    public function getDesiredUpgradeMode()
    {
        return $this->desiredUpgradeMode;
    }
    /**
     * Set desiredUpgradeMode value
     * @uses \CustomerManagement\EnumType\FirmwareUpgradeModeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\FirmwareUpgradeModeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $desiredUpgradeMode
     * @return \CustomerManagement\StructType\RequestFirmwareUpgradeNonPanel
     */
    public function setDesiredUpgradeMode($desiredUpgradeMode = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\FirmwareUpgradeModeEnum::valueIsValid($desiredUpgradeMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\FirmwareUpgradeModeEnum', is_array($desiredUpgradeMode) ? implode(', ', $desiredUpgradeMode) : var_export($desiredUpgradeMode, true), implode(', ', \CustomerManagement\EnumType\FirmwareUpgradeModeEnum::getValidValues())), __LINE__);
        }
        $this->desiredUpgradeMode = $desiredUpgradeMode;
        return $this;
    }
    /**
     * Get deviceId value
     * @return int
     */
    public function getDeviceId()
    {
        return $this->deviceId;
    }
    /**
     * Set deviceId value
     * @param int $deviceId
     * @return \CustomerManagement\StructType\RequestFirmwareUpgradeNonPanel
     */
    public function setDeviceId($deviceId = null)
    {
        // validation for constraint: int
        if (!is_null($deviceId) && !(is_int($deviceId) || ctype_digit($deviceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deviceId, true), gettype($deviceId)), __LINE__);
        }
        $this->deviceId = $deviceId;
        return $this;
    }
}
