<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomerNotificationEnum ArrayType
 * @subpackage Arrays
 */
class ArrayOfCustomerNotificationEnum extends AbstractStructArrayBase
{
    /**
     * The CustomerNotificationEnum
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $CustomerNotificationEnum;
    /**
     * Constructor method for ArrayOfCustomerNotificationEnum
     * @uses ArrayOfCustomerNotificationEnum::setCustomerNotificationEnum()
     * @param string[] $customerNotificationEnum
     */
    public function __construct(array $customerNotificationEnum = array())
    {
        $this
            ->setCustomerNotificationEnum($customerNotificationEnum);
    }
    /**
     * Get CustomerNotificationEnum value
     * @return string[]|null
     */
    public function getCustomerNotificationEnum()
    {
        return $this->CustomerNotificationEnum;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomerNotificationEnum method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomerNotificationEnum method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerNotificationEnumForArrayConstraintsFromSetCustomerNotificationEnum(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCustomerNotificationEnumCustomerNotificationEnumItem) {
            // validation for constraint: enumeration
            if (!\CustomerManagement\EnumType\CustomerNotificationEnum::valueIsValid($arrayOfCustomerNotificationEnumCustomerNotificationEnumItem)) {
                $invalidValues[] = is_object($arrayOfCustomerNotificationEnumCustomerNotificationEnumItem) ? get_class($arrayOfCustomerNotificationEnumCustomerNotificationEnumItem) : sprintf('%s(%s)', gettype($arrayOfCustomerNotificationEnumCustomerNotificationEnumItem), var_export($arrayOfCustomerNotificationEnumCustomerNotificationEnumItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\CustomerNotificationEnum', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \CustomerManagement\EnumType\CustomerNotificationEnum::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomerNotificationEnum value
     * @uses \CustomerManagement\EnumType\CustomerNotificationEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\CustomerNotificationEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $customerNotificationEnum
     * @return \CustomerManagement\ArrayType\ArrayOfCustomerNotificationEnum
     */
    public function setCustomerNotificationEnum(array $customerNotificationEnum = array())
    {
        // validation for constraint: array
        if ('' !== ($customerNotificationEnumArrayErrorMessage = self::validateCustomerNotificationEnumForArrayConstraintsFromSetCustomerNotificationEnum($customerNotificationEnum))) {
            throw new \InvalidArgumentException($customerNotificationEnumArrayErrorMessage, __LINE__);
        }
        $this->CustomerNotificationEnum = $customerNotificationEnum;
        return $this;
    }
    /**
     * Add item to CustomerNotificationEnum value
     * @uses \CustomerManagement\EnumType\CustomerNotificationEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\CustomerNotificationEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \CustomerManagement\ArrayType\ArrayOfCustomerNotificationEnum
     */
    public function addToCustomerNotificationEnum($item)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\CustomerNotificationEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\CustomerNotificationEnum', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \CustomerManagement\EnumType\CustomerNotificationEnum::getValidValues())), __LINE__);
        }
        $this->CustomerNotificationEnum[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \CustomerManagement\EnumType\CustomerNotificationEnum::valueIsValid()
     * @param string $item
     * @return \CustomerManagement\ArrayType\ArrayOfCustomerNotificationEnum
     */
    public function add($item)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\CustomerNotificationEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\CustomerNotificationEnum', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \CustomerManagement\EnumType\CustomerNotificationEnum::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomerNotificationEnum
     */
    public function getAttributeName()
    {
        return 'CustomerNotificationEnum';
    }
}
