<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateBusinessActivityAnalyticsMetricInfoInput StructType
 * @subpackage Structs
 */
class UpdateBusinessActivityAnalyticsMetricInfoInput extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerId;
    /**
     * The RowId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RowId;
    /**
     * The OccupancyCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $OccupancyCount;
    /**
     * The WaitTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $WaitTime;
    /**
     * The TrafficCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TrafficCount;
    /**
     * Constructor method for UpdateBusinessActivityAnalyticsMetricInfoInput
     * @uses UpdateBusinessActivityAnalyticsMetricInfoInput::setCustomerId()
     * @uses UpdateBusinessActivityAnalyticsMetricInfoInput::setRowId()
     * @uses UpdateBusinessActivityAnalyticsMetricInfoInput::setOccupancyCount()
     * @uses UpdateBusinessActivityAnalyticsMetricInfoInput::setWaitTime()
     * @uses UpdateBusinessActivityAnalyticsMetricInfoInput::setTrafficCount()
     * @param int $customerId
     * @param int $rowId
     * @param int $occupancyCount
     * @param int $waitTime
     * @param int $trafficCount
     */
    public function __construct($customerId = null, $rowId = null, $occupancyCount = null, $waitTime = null, $trafficCount = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setRowId($rowId)
            ->setOccupancyCount($occupancyCount)
            ->setWaitTime($waitTime)
            ->setTrafficCount($trafficCount);
    }
    /**
     * Get CustomerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->CustomerId;
    }
    /**
     * Set CustomerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdateBusinessActivityAnalyticsMetricInfoInput
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->CustomerId = $customerId;
        return $this;
    }
    /**
     * Get RowId value
     * @return int
     */
    public function getRowId()
    {
        return $this->RowId;
    }
    /**
     * Set RowId value
     * @param int $rowId
     * @return \CustomerManagement\StructType\UpdateBusinessActivityAnalyticsMetricInfoInput
     */
    public function setRowId($rowId = null)
    {
        // validation for constraint: int
        if (!is_null($rowId) && !(is_int($rowId) || ctype_digit($rowId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowId, true), gettype($rowId)), __LINE__);
        }
        $this->RowId = $rowId;
        return $this;
    }
    /**
     * Get OccupancyCount value
     * @return int
     */
    public function getOccupancyCount()
    {
        return $this->OccupancyCount;
    }
    /**
     * Set OccupancyCount value
     * @param int $occupancyCount
     * @return \CustomerManagement\StructType\UpdateBusinessActivityAnalyticsMetricInfoInput
     */
    public function setOccupancyCount($occupancyCount = null)
    {
        // validation for constraint: int
        if (!is_null($occupancyCount) && !(is_int($occupancyCount) || ctype_digit($occupancyCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($occupancyCount, true), gettype($occupancyCount)), __LINE__);
        }
        $this->OccupancyCount = $occupancyCount;
        return $this;
    }
    /**
     * Get WaitTime value
     * @return int
     */
    public function getWaitTime()
    {
        return $this->WaitTime;
    }
    /**
     * Set WaitTime value
     * @param int $waitTime
     * @return \CustomerManagement\StructType\UpdateBusinessActivityAnalyticsMetricInfoInput
     */
    public function setWaitTime($waitTime = null)
    {
        // validation for constraint: int
        if (!is_null($waitTime) && !(is_int($waitTime) || ctype_digit($waitTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($waitTime, true), gettype($waitTime)), __LINE__);
        }
        $this->WaitTime = $waitTime;
        return $this;
    }
    /**
     * Get TrafficCount value
     * @return int
     */
    public function getTrafficCount()
    {
        return $this->TrafficCount;
    }
    /**
     * Set TrafficCount value
     * @param int $trafficCount
     * @return \CustomerManagement\StructType\UpdateBusinessActivityAnalyticsMetricInfoInput
     */
    public function setTrafficCount($trafficCount = null)
    {
        // validation for constraint: int
        if (!is_null($trafficCount) && !(is_int($trafficCount) || ctype_digit($trafficCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($trafficCount, true), gettype($trafficCount)), __LINE__);
        }
        $this->TrafficCount = $trafficCount;
        return $this;
    }
}
