<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FrequentlyUsedDeviceItem StructType
 * @subpackage Structs
 */
class FrequentlyUsedDeviceItem extends AbstractStructBase
{
    /**
     * The Zone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Zone;
    /**
     * The Activations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Activations;
    /**
     * Constructor method for FrequentlyUsedDeviceItem
     * @uses FrequentlyUsedDeviceItem::setZone()
     * @uses FrequentlyUsedDeviceItem::setActivations()
     * @param int $zone
     * @param int $activations
     */
    public function __construct($zone = null, $activations = null)
    {
        $this
            ->setZone($zone)
            ->setActivations($activations);
    }
    /**
     * Get Zone value
     * @return int
     */
    public function getZone()
    {
        return $this->Zone;
    }
    /**
     * Set Zone value
     * @param int $zone
     * @return \CustomerManagement\StructType\FrequentlyUsedDeviceItem
     */
    public function setZone($zone = null)
    {
        // validation for constraint: int
        if (!is_null($zone) && !(is_int($zone) || ctype_digit($zone))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zone, true), gettype($zone)), __LINE__);
        }
        $this->Zone = $zone;
        return $this;
    }
    /**
     * Get Activations value
     * @return int
     */
    public function getActivations()
    {
        return $this->Activations;
    }
    /**
     * Set Activations value
     * @param int $activations
     * @return \CustomerManagement\StructType\FrequentlyUsedDeviceItem
     */
    public function setActivations($activations = null)
    {
        // validation for constraint: int
        if (!is_null($activations) && !(is_int($activations) || ctype_digit($activations))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($activations, true), gettype($activations)), __LINE__);
        }
        $this->Activations = $activations;
        return $this;
    }
}
