<?php

namespace CustomerManagement\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Bulk ServiceType
 * @subpackage Services
 */
class Bulk extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \CustomerManagement\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\CustomerManagement\StructType\Authentication $authentication, $nameSpace = 'http://www.alarm.com/WebServices', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named BulkAddSensorDevice
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Authentication
     * - SOAPHeaderNamespaces: http://www.alarm.com/WebServices
     * - SOAPHeaderTypes: \CustomerManagement\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: BulkAddSensorDevice. The SensorTypeId field is only needed for Qolsys panels. When naming sensors use SensorNamePrefix for the NX panel; SensorName for Qolsys; and Base, Suffix, Token3, and Token4 for XT/XTi. Please call
     * GetEligibleSensorNames to get the valid descriptors for XT/XTi. SignalSource for Qolsys.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \CustomerManagement\StructType\BulkAddSensorDevice $parameters
     * @return \CustomerManagement\StructType\BulkAddSensorDeviceResponse|bool
     */
    public function BulkAddSensorDevice(\CustomerManagement\StructType\BulkAddSensorDevice $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->BulkAddSensorDevice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \CustomerManagement\StructType\BulkAddSensorDeviceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
