<?php

namespace CustomerManagement\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for SystemCheckTestResultEnum EnumType
 * @subpackage Enumerations
 */
class SystemCheckTestResultEnum extends AbstractStructEnumBase
{
    /**
     * Constant for value 'NotSet'
     * @return string 'NotSet'
     */
    const VALUE_NOT_SET = 'NotSet';
    /**
     * Constant for value 'Success'
     * @return string 'Success'
     */
    const VALUE_SUCCESS = 'Success';
    /**
     * Constant for value 'Error'
     * @return string 'Error'
     */
    const VALUE_ERROR = 'Error';
    /**
     * Constant for value 'Warning'
     * @return string 'Warning'
     */
    const VALUE_WARNING = 'Warning';
    /**
     * Constant for value 'TimedOut'
     * @return string 'TimedOut'
     */
    const VALUE_TIMED_OUT = 'TimedOut';
    /**
     * Constant for value 'Skipped'
     * @return string 'Skipped'
     */
    const VALUE_SKIPPED = 'Skipped';
    /**
     * Constant for value 'Watch'
     * @return string 'Watch'
     */
    const VALUE_WATCH = 'Watch';
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_SET
     * @uses self::VALUE_SUCCESS
     * @uses self::VALUE_ERROR
     * @uses self::VALUE_WARNING
     * @uses self::VALUE_TIMED_OUT
     * @uses self::VALUE_SKIPPED
     * @uses self::VALUE_WATCH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_SET,
            self::VALUE_SUCCESS,
            self::VALUE_ERROR,
            self::VALUE_WARNING,
            self::VALUE_TIMED_OUT,
            self::VALUE_SKIPPED,
            self::VALUE_WATCH,
        );
    }
}
