<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdatePropertyType StructType
 * @subpackage Structs
 */
class UpdatePropertyType extends AbstractStructBase
{
    /**
     * The customerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The propertyType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $propertyType;
    /**
     * Constructor method for UpdatePropertyType
     * @uses UpdatePropertyType::setCustomerId()
     * @uses UpdatePropertyType::setPropertyType()
     * @param int $customerId
     * @param string $propertyType
     */
    public function __construct($customerId = null, $propertyType = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setPropertyType($propertyType);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\UpdatePropertyType
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get propertyType value
     * @return string
     */
    public function getPropertyType()
    {
        return $this->propertyType;
    }
    /**
     * Set propertyType value
     * @uses \CustomerManagement\EnumType\PropertyTypeEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\PropertyTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $propertyType
     * @return \CustomerManagement\StructType\UpdatePropertyType
     */
    public function setPropertyType($propertyType = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\PropertyTypeEnum::valueIsValid($propertyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\PropertyTypeEnum', is_array($propertyType) ? implode(', ', $propertyType) : var_export($propertyType, true), implode(', ', \CustomerManagement\EnumType\PropertyTypeEnum::getValidValues())), __LINE__);
        }
        $this->propertyType = $propertyType;
        return $this;
    }
}
