<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetUserCodesOutput StructType
 * @subpackage Structs
 */
class GetUserCodesOutput extends AbstractStructBase
{
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Success;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The UserCodes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfWsUserCodeInfo
     */
    public $UserCodes;
    /**
     * The DuressCodes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CustomerManagement\ArrayType\ArrayOfWsUserCodeInfo
     */
    public $DuressCodes;
    /**
     * Constructor method for GetUserCodesOutput
     * @uses GetUserCodesOutput::setSuccess()
     * @uses GetUserCodesOutput::setErrorMessage()
     * @uses GetUserCodesOutput::setUserCodes()
     * @uses GetUserCodesOutput::setDuressCodes()
     * @param bool $success
     * @param string $errorMessage
     * @param \CustomerManagement\ArrayType\ArrayOfWsUserCodeInfo $userCodes
     * @param \CustomerManagement\ArrayType\ArrayOfWsUserCodeInfo $duressCodes
     */
    public function __construct($success = null, $errorMessage = null, \CustomerManagement\ArrayType\ArrayOfWsUserCodeInfo $userCodes = null, \CustomerManagement\ArrayType\ArrayOfWsUserCodeInfo $duressCodes = null)
    {
        $this
            ->setSuccess($success)
            ->setErrorMessage($errorMessage)
            ->setUserCodes($userCodes)
            ->setDuressCodes($duressCodes);
    }
    /**
     * Get Success value
     * @return bool
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \CustomerManagement\StructType\GetUserCodesOutput
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \CustomerManagement\StructType\GetUserCodesOutput
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get UserCodes value
     * @return \CustomerManagement\ArrayType\ArrayOfWsUserCodeInfo|null
     */
    public function getUserCodes()
    {
        return $this->UserCodes;
    }
    /**
     * Set UserCodes value
     * @param \CustomerManagement\ArrayType\ArrayOfWsUserCodeInfo $userCodes
     * @return \CustomerManagement\StructType\GetUserCodesOutput
     */
    public function setUserCodes(\CustomerManagement\ArrayType\ArrayOfWsUserCodeInfo $userCodes = null)
    {
        $this->UserCodes = $userCodes;
        return $this;
    }
    /**
     * Get DuressCodes value
     * @return \CustomerManagement\ArrayType\ArrayOfWsUserCodeInfo|null
     */
    public function getDuressCodes()
    {
        return $this->DuressCodes;
    }
    /**
     * Set DuressCodes value
     * @param \CustomerManagement\ArrayType\ArrayOfWsUserCodeInfo $duressCodes
     * @return \CustomerManagement\StructType\GetUserCodesOutput
     */
    public function setDuressCodes(\CustomerManagement\ArrayType\ArrayOfWsUserCodeInfo $duressCodes = null)
    {
        $this->DuressCodes = $duressCodes;
        return $this;
    }
}
