<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountRecycleSearchResult StructType
 * @subpackage Structs
 */
class AccountRecycleSearchResult extends AbstractStructBase
{
    /**
     * The OldCustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OldCustomerId;
    /**
     * The NewCustomerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NewCustomerId;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The FailureReason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FailureReason;
    /**
     * The RecycleStartDateUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RecycleStartDateUtc;
    /**
     * The RecycleEndDateUtc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $RecycleEndDateUtc;
    /**
     * The FailureReasonDesc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FailureReasonDesc;
    /**
     * Constructor method for AccountRecycleSearchResult
     * @uses AccountRecycleSearchResult::setOldCustomerId()
     * @uses AccountRecycleSearchResult::setNewCustomerId()
     * @uses AccountRecycleSearchResult::setStatus()
     * @uses AccountRecycleSearchResult::setFailureReason()
     * @uses AccountRecycleSearchResult::setRecycleStartDateUtc()
     * @uses AccountRecycleSearchResult::setRecycleEndDateUtc()
     * @uses AccountRecycleSearchResult::setFailureReasonDesc()
     * @param int $oldCustomerId
     * @param int $newCustomerId
     * @param string $status
     * @param string $failureReason
     * @param string $recycleStartDateUtc
     * @param string $recycleEndDateUtc
     * @param string $failureReasonDesc
     */
    public function __construct($oldCustomerId = null, $newCustomerId = null, $status = null, $failureReason = null, $recycleStartDateUtc = null, $recycleEndDateUtc = null, $failureReasonDesc = null)
    {
        $this
            ->setOldCustomerId($oldCustomerId)
            ->setNewCustomerId($newCustomerId)
            ->setStatus($status)
            ->setFailureReason($failureReason)
            ->setRecycleStartDateUtc($recycleStartDateUtc)
            ->setRecycleEndDateUtc($recycleEndDateUtc)
            ->setFailureReasonDesc($failureReasonDesc);
    }
    /**
     * Get OldCustomerId value
     * @return int
     */
    public function getOldCustomerId()
    {
        return $this->OldCustomerId;
    }
    /**
     * Set OldCustomerId value
     * @param int $oldCustomerId
     * @return \CustomerManagement\StructType\AccountRecycleSearchResult
     */
    public function setOldCustomerId($oldCustomerId = null)
    {
        // validation for constraint: int
        if (!is_null($oldCustomerId) && !(is_int($oldCustomerId) || ctype_digit($oldCustomerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oldCustomerId, true), gettype($oldCustomerId)), __LINE__);
        }
        $this->OldCustomerId = $oldCustomerId;
        return $this;
    }
    /**
     * Get NewCustomerId value
     * @return int
     */
    public function getNewCustomerId()
    {
        return $this->NewCustomerId;
    }
    /**
     * Set NewCustomerId value
     * @param int $newCustomerId
     * @return \CustomerManagement\StructType\AccountRecycleSearchResult
     */
    public function setNewCustomerId($newCustomerId = null)
    {
        // validation for constraint: int
        if (!is_null($newCustomerId) && !(is_int($newCustomerId) || ctype_digit($newCustomerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($newCustomerId, true), gettype($newCustomerId)), __LINE__);
        }
        $this->NewCustomerId = $newCustomerId;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \CustomerManagement\EnumType\AccountRecycleStatusEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\AccountRecycleStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \CustomerManagement\StructType\AccountRecycleSearchResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\AccountRecycleStatusEnum::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\AccountRecycleStatusEnum', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \CustomerManagement\EnumType\AccountRecycleStatusEnum::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get FailureReason value
     * @return string
     */
    public function getFailureReason()
    {
        return $this->FailureReason;
    }
    /**
     * Set FailureReason value
     * @uses \CustomerManagement\EnumType\RecycleFailureReasonEnum::valueIsValid()
     * @uses \CustomerManagement\EnumType\RecycleFailureReasonEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $failureReason
     * @return \CustomerManagement\StructType\AccountRecycleSearchResult
     */
    public function setFailureReason($failureReason = null)
    {
        // validation for constraint: enumeration
        if (!\CustomerManagement\EnumType\RecycleFailureReasonEnum::valueIsValid($failureReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CustomerManagement\EnumType\RecycleFailureReasonEnum', is_array($failureReason) ? implode(', ', $failureReason) : var_export($failureReason, true), implode(', ', \CustomerManagement\EnumType\RecycleFailureReasonEnum::getValidValues())), __LINE__);
        }
        $this->FailureReason = $failureReason;
        return $this;
    }
    /**
     * Get RecycleStartDateUtc value
     * @return string
     */
    public function getRecycleStartDateUtc()
    {
        return $this->RecycleStartDateUtc;
    }
    /**
     * Set RecycleStartDateUtc value
     * @param string $recycleStartDateUtc
     * @return \CustomerManagement\StructType\AccountRecycleSearchResult
     */
    public function setRecycleStartDateUtc($recycleStartDateUtc = null)
    {
        // validation for constraint: string
        if (!is_null($recycleStartDateUtc) && !is_string($recycleStartDateUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recycleStartDateUtc, true), gettype($recycleStartDateUtc)), __LINE__);
        }
        $this->RecycleStartDateUtc = $recycleStartDateUtc;
        return $this;
    }
    /**
     * Get RecycleEndDateUtc value
     * @return string
     */
    public function getRecycleEndDateUtc()
    {
        return $this->RecycleEndDateUtc;
    }
    /**
     * Set RecycleEndDateUtc value
     * @param string $recycleEndDateUtc
     * @return \CustomerManagement\StructType\AccountRecycleSearchResult
     */
    public function setRecycleEndDateUtc($recycleEndDateUtc = null)
    {
        // validation for constraint: string
        if (!is_null($recycleEndDateUtc) && !is_string($recycleEndDateUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recycleEndDateUtc, true), gettype($recycleEndDateUtc)), __LINE__);
        }
        $this->RecycleEndDateUtc = $recycleEndDateUtc;
        return $this;
    }
    /**
     * Get FailureReasonDesc value
     * @return string|null
     */
    public function getFailureReasonDesc()
    {
        return $this->FailureReasonDesc;
    }
    /**
     * Set FailureReasonDesc value
     * @param string $failureReasonDesc
     * @return \CustomerManagement\StructType\AccountRecycleSearchResult
     */
    public function setFailureReasonDesc($failureReasonDesc = null)
    {
        // validation for constraint: string
        if (!is_null($failureReasonDesc) && !is_string($failureReasonDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($failureReasonDesc, true), gettype($failureReasonDesc)), __LINE__);
        }
        $this->FailureReasonDesc = $failureReasonDesc;
        return $this;
    }
}
