<?php

namespace CustomerManagement\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeServicePlanTemplate StructType
 * @subpackage Structs
 */
class ChangeServicePlanTemplate extends AbstractStructBase
{
    /**
     * The customerId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customerId;
    /**
     * The customPackageTemplateId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $customPackageTemplateId;
    /**
     * Constructor method for ChangeServicePlanTemplate
     * @uses ChangeServicePlanTemplate::setCustomerId()
     * @uses ChangeServicePlanTemplate::setCustomPackageTemplateId()
     * @param int $customerId
     * @param int $customPackageTemplateId
     */
    public function __construct($customerId = null, $customPackageTemplateId = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setCustomPackageTemplateId($customPackageTemplateId);
    }
    /**
     * Get customerId value
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }
    /**
     * Set customerId value
     * @param int $customerId
     * @return \CustomerManagement\StructType\ChangeServicePlanTemplate
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        $this->customerId = $customerId;
        return $this;
    }
    /**
     * Get customPackageTemplateId value
     * @return int
     */
    public function getCustomPackageTemplateId()
    {
        return $this->customPackageTemplateId;
    }
    /**
     * Set customPackageTemplateId value
     * @param int $customPackageTemplateId
     * @return \CustomerManagement\StructType\ChangeServicePlanTemplate
     */
    public function setCustomPackageTemplateId($customPackageTemplateId = null)
    {
        // validation for constraint: int
        if (!is_null($customPackageTemplateId) && !(is_int($customPackageTemplateId) || ctype_digit($customPackageTemplateId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customPackageTemplateId, true), gettype($customPackageTemplateId)), __LINE__);
        }
        $this->customPackageTemplateId = $customPackageTemplateId;
        return $this;
    }
}
