<?php

namespace CustomerManagement\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for MessagePermissionLevelEnum EnumType
 * @subpackage Enumerations
 */
class MessagePermissionLevelEnum extends AbstractStructEnumBase
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Read'
     * @return string 'Read'
     */
    const VALUE_READ = 'Read';
    /**
     * Constant for value 'ReadWrite'
     * @return string 'ReadWrite'
     */
    const VALUE_READ_WRITE = 'ReadWrite';
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_READ
     * @uses self::VALUE_READ_WRITE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_READ,
            self::VALUE_READ_WRITE,
        );
    }
}
