<?php

namespace CustomerManagement\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRiskScoreDetail ArrayType
 * @subpackage Arrays
 */
class ArrayOfRiskScoreDetail extends AbstractStructArrayBase
{
    /**
     * The RiskScoreDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CustomerManagement\StructType\RiskScoreDetail[]
     */
    public $RiskScoreDetail;
    /**
     * Constructor method for ArrayOfRiskScoreDetail
     * @uses ArrayOfRiskScoreDetail::setRiskScoreDetail()
     * @param \CustomerManagement\StructType\RiskScoreDetail[] $riskScoreDetail
     */
    public function __construct(array $riskScoreDetail = array())
    {
        $this
            ->setRiskScoreDetail($riskScoreDetail);
    }
    /**
     * Get RiskScoreDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CustomerManagement\StructType\RiskScoreDetail[]|null
     */
    public function getRiskScoreDetail()
    {
        return isset($this->RiskScoreDetail) ? $this->RiskScoreDetail : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRiskScoreDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRiskScoreDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRiskScoreDetailForArrayConstraintsFromSetRiskScoreDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfRiskScoreDetailRiskScoreDetailItem) {
            // validation for constraint: itemType
            if (!$arrayOfRiskScoreDetailRiskScoreDetailItem instanceof \CustomerManagement\StructType\RiskScoreDetail) {
                $invalidValues[] = is_object($arrayOfRiskScoreDetailRiskScoreDetailItem) ? get_class($arrayOfRiskScoreDetailRiskScoreDetailItem) : sprintf('%s(%s)', gettype($arrayOfRiskScoreDetailRiskScoreDetailItem), var_export($arrayOfRiskScoreDetailRiskScoreDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RiskScoreDetail property can only contain items of type \CustomerManagement\StructType\RiskScoreDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RiskScoreDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\RiskScoreDetail[] $riskScoreDetail
     * @return \CustomerManagement\ArrayType\ArrayOfRiskScoreDetail
     */
    public function setRiskScoreDetail(array $riskScoreDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($riskScoreDetailArrayErrorMessage = self::validateRiskScoreDetailForArrayConstraintsFromSetRiskScoreDetail($riskScoreDetail))) {
            throw new \InvalidArgumentException($riskScoreDetailArrayErrorMessage, __LINE__);
        }
        if (is_null($riskScoreDetail) || (is_array($riskScoreDetail) && empty($riskScoreDetail))) {
            unset($this->RiskScoreDetail);
        } else {
            $this->RiskScoreDetail = $riskScoreDetail;
        }
        return $this;
    }
    /**
     * Add item to RiskScoreDetail value
     * @throws \InvalidArgumentException
     * @param \CustomerManagement\StructType\RiskScoreDetail $item
     * @return \CustomerManagement\ArrayType\ArrayOfRiskScoreDetail
     */
    public function addToRiskScoreDetail(\CustomerManagement\StructType\RiskScoreDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CustomerManagement\StructType\RiskScoreDetail) {
            throw new \InvalidArgumentException(sprintf('The RiskScoreDetail property can only contain items of type \CustomerManagement\StructType\RiskScoreDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RiskScoreDetail[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \CustomerManagement\StructType\RiskScoreDetail|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \CustomerManagement\StructType\RiskScoreDetail|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \CustomerManagement\StructType\RiskScoreDetail|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \CustomerManagement\StructType\RiskScoreDetail|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \CustomerManagement\StructType\RiskScoreDetail|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RiskScoreDetail
     */
    public function getAttributeName()
    {
        return 'RiskScoreDetail';
    }
}
